/*
 * Decompiled with CFR 0.152.
 */
package org.buni.meldware.mail.imap4.commands.fetch;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.buni.meldware.mail.api.FolderMessage;
import org.buni.meldware.mail.imap4.commands.fetch.MsgFilter;
import org.buni.meldware.mail.mailbox.MessageData;
import org.jboss.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MsgRangeFilter
extends MsgFilter {
    private final Logger log = Logger.getLogger(MsgRangeFilter.class);
    static final Pattern TWO_PART = Pattern.compile("(\\d+|\\*):(\\d+|\\*)");
    int _top;
    int _bottom;
    boolean _isUID;
    boolean _unbounded;

    public MsgRangeFilter(int a, int b) {
        this._bottom = a;
        this._top = b;
        this._unbounded = a == -1 || b == Integer.MAX_VALUE;
    }

    public MsgRangeFilter(String rng, boolean uid) {
        if (rng.indexOf(58) == -1) {
            int value;
            this._top = value = Integer.parseInt(rng);
            this._bottom = value;
        } else {
            Matcher mat = TWO_PART.matcher(rng);
            mat.matches();
            if (mat.groupCount() != 2) {
                throw new RuntimeException("GroupCount was not 2!");
            }
            String bot = mat.group(1);
            String top = mat.group(2);
            if (bot.equals("*")) {
                this._bottom = 0;
                this._unbounded = true;
            } else {
                this._bottom = Integer.parseInt(bot);
            }
            if (top.equals("*")) {
                this._top = Integer.MAX_VALUE;
                this._unbounded = true;
            } else {
                this._top = Integer.parseInt(top);
            }
        }
        this._isUID = uid;
    }

    public int getTop() {
        return this._top;
    }

    public int getBottom() {
        return this._bottom;
    }

    public boolean isUnbounded() {
        return this._unbounded;
    }

    @Override
    public boolean includes(FolderMessage msg) {
        long msgValue = msg.getUid();
        return msgValue >= (long)this._bottom && msgValue <= (long)this._top;
    }

    public boolean includes(FolderMessage msg, int seqNum) {
        return seqNum >= this._bottom && seqNum <= this._top;
    }

    public List<MessageData> getMessagesFromList(List<MessageData> messageList) {
        ArrayList<MessageData> returnList = new ArrayList<MessageData>();
        if (messageList.size() == 0) {
            return returnList;
        }
        if (this._isUID) {
            messageList.get(messageList.size() - 1);
            for (MessageData msg : messageList) {
                long msgValue = msg.getId();
                if (msgValue < (long)this._bottom || msgValue > (long)this._top) continue;
                if (this.log.isDebugEnabled()) {
                    this.log.debug("unbounded " + this._unbounded);
                }
                returnList.add(msg);
            }
        } else {
            for (MessageData msg : messageList) {
                int index = messageList.indexOf(msg) + 1;
                if (index < this._bottom || index > this._top) continue;
                returnList.add(msg);
            }
        }
        return returnList;
    }
}

