/*
 * Decompiled with CFR 0.152.
 */
package org.buni.meldware.mail.imap4.commands.fetch;

import java.io.IOException;
import java.util.Set;
import org.buni.meldware.common.util.ArrayUtil;
import org.buni.meldware.mail.StreamWriteException;
import org.buni.meldware.mail.api.FolderMessage;
import org.buni.meldware.mail.imap4.IMAP4OutputStream;
import org.buni.meldware.mail.imap4.commands.fetch.FetchPart;
import org.buni.meldware.mail.imap4.commands.fetch.MessagePropertyPart;
import org.buni.meldware.mail.imap4.commands.fetch.RFC822PartRequest;
import org.buni.meldware.mail.imap4.commands.fetch.UnknownMacroException;

public class MacroFetchPart
extends FetchPart {
    Set<String> SUPPORTED = ArrayUtil.asSet((Object[])new String[]{"ALL", "FULL", "FAST"});
    private String name;
    private static FetchPart[] ALL_FETCH = new FetchPart[]{new MessagePropertyPart("FLAGS"), new MessagePropertyPart("INTERNALDATE"), new RFC822PartRequest("SIZE"), new MessagePropertyPart("ENVELOPE")};
    private static FetchPart[] FAST_FETCH = new FetchPart[]{new MessagePropertyPart("FLAGS"), new MessagePropertyPart("INTERNALDATE"), new RFC822PartRequest("SIZE")};
    private static FetchPart[] FULL_FETCH = new FetchPart[]{new MessagePropertyPart("FLAGS"), new MessagePropertyPart("INTERNALDATE"), new RFC822PartRequest("SIZE"), new MessagePropertyPart("ENVELOPE"), new MessagePropertyPart("BODY")};

    public MacroFetchPart(String name) {
        this.name = name;
    }

    private FetchPart[] expandMacro(String s) {
        if ("ALL".equals(s)) {
            return ALL_FETCH;
        }
        if ("FULL".equals(s)) {
            return FULL_FETCH;
        }
        if ("FAST".equals(s)) {
            return FAST_FETCH;
        }
        throw new UnknownMacroException("Unknown fetch macro: %s", s);
    }

    public void fetch(FolderMessage msg, IMAP4OutputStream out) {
        FetchPart[] parts = this.expandMacro(this.name);
        int i = 0;
        while (i < parts.length) {
            FetchPart part = parts[i];
            part.fetch(msg, out);
            if (i < parts.length - 1) {
                try {
                    out.write(32);
                }
                catch (IOException e) {
                    throw new StreamWriteException("Error writing fetch", e);
                }
            }
            ++i;
        }
    }

    public String toString() {
        return this.name;
    }
}

