/*
 * Decompiled with CFR 0.152.
 */
package org.buni.meldware.mail.imap4.commands;

import java.util.ArrayList;
import java.util.List;
import org.buni.meldware.mail.api.Folder;
import org.buni.meldware.mail.api.FolderMessage;
import org.buni.meldware.mail.api.Range;
import org.buni.meldware.mail.imap4.IMAP4ProtocolInstance;
import org.buni.meldware.mail.imap4.IMAP4Response;
import org.buni.meldware.mail.imap4.commands.AbstractImapCommand;
import org.buni.meldware.mail.imap4.commands.fetch.MsgFilter;
import org.buni.meldware.mail.imap4.commands.fetch.MsgSetFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StoreCommand
extends AbstractImapCommand {
    boolean isUID;
    MsgFilter range;
    List<String> flags = new ArrayList<String>();
    String type;
    private Action action;
    private boolean silent;

    public StoreCommand(boolean isUID) {
        super(isUID ? "UID STORE" : "STORE");
        this.isUID = isUID;
    }

    @Override
    public boolean isValidForState() {
        return this.getProtocolInstance().getState() == 2;
    }

    @Override
    public IMAP4Response execute() {
        IMAP4Response response = this.constructResponse();
        IMAP4ProtocolInstance pi = this.getProtocolInstance();
        if (pi.isFolderReadOnly()) {
            this.taggedFailure("STORE failure: can't store: this folder is opened Read-Only.");
            return response;
        }
        this.setAction(this.getAction(this.getType()));
        this.setSilent(this.getSilent(this.getType()));
        MsgSetFilter filter = (MsgSetFilter)this.getRange();
        Folder f = pi.getFolderProxy();
        int maxValue = this.isUID ? f.getMaxUid() : f.getMessageCount();
        Range[] ranges = this.createRanges(filter, maxValue);
        List<FolderMessage> messages = f.getMessages(this.isUID, ranges);
        int i = 0;
        while (i < messages.size()) {
            FolderMessage message = messages.get(i);
            switch (this.action) {
                case ADD: {
                    message.setFlags(false, this.getFlags());
                    break;
                }
                case REPLACE: {
                    message.setFlags(true, this.getFlags());
                    break;
                }
                case REMOVE: {
                    message.removeFlags(this.getFlags());
                }
            }
            if (!this.isSilent()) {
                StringBuffer result = new StringBuffer();
                result.append(i + 1).append(" FETCH (FLAGS (").append(message.getFlagString()).append(")");
                if (this.isUID) {
                    result.append(" UID ").append(message.getUid());
                }
                result.append(")");
                this.untaggedResponse(result.toString());
            }
            ++i;
        }
        this.taggedSimpleSuccess();
        this.flush();
        return response;
    }

    private Action getAction(String type) {
        if (type.startsWith("+")) {
            return Action.ADD;
        }
        if (type.startsWith("-")) {
            return Action.REMOVE;
        }
        return Action.REPLACE;
    }

    private boolean getSilent(String type) {
        return type.indexOf("SILENT") != -1;
    }

    public Action getAction() {
        return this.action;
    }

    public void setAction(Action action) {
        this.action = action;
    }

    public boolean isSilent() {
        return this.silent;
    }

    public void setSilent(boolean silent) {
        this.silent = silent;
    }

    public void setFlags(List<String> flags) {
        this.flags = flags;
    }

    public List<String> getFlags() {
        return this.flags;
    }

    public MsgFilter getRange() {
        return this.range;
    }

    public void setRange(MsgFilter range) {
        this.range = range;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public boolean isUid() {
        return this.isUID;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Action {
        ADD,
        REMOVE,
        REPLACE;

    }
}

