/*
 * Decompiled with CFR 0.152.
 */
package org.buni.meldware.mail.imap4.commands;

import java.util.List;
import org.buni.meldware.mail.api.Folder;
import org.buni.meldware.mail.imap4.IMAP4ProtocolInstance;
import org.buni.meldware.mail.imap4.IMAP4Response;
import org.buni.meldware.mail.imap4.commands.AbstractImapCommand;

public class StatusCommand
extends AbstractImapCommand {
    String _folder;
    List _requests;

    public StatusCommand() {
        super("STATUS");
    }

    public boolean isValidForState() {
        return this.getProtocolInstance().getState() == 1;
    }

    public StatusCommand(String name) {
        super(name);
    }

    public IMAP4Response execute() {
        IMAP4ProtocolInstance pi = this.getProtocolInstance();
        IMAP4Response res = this.constructResponse();
        String[] path = this.getPath(this.getFolder());
        Folder folder = pi.getMailboxProxy().getFolder(path);
        if (folder == null) {
            this.taggedFailure("status failure: no status for that name");
            return res;
        }
        String responseString = "(";
        if (this.getRequests().contains("MESSAGES")) {
            int messages = folder.getMessageCount();
            responseString = String.valueOf(responseString) + "MESSAGES " + messages + " ";
        }
        if (this.getRequests().contains("RECENT")) {
            int recent = folder.getRecentCount();
            responseString = String.valueOf(responseString) + "RECENT " + recent + " ";
        }
        if (this.getRequests().contains("UNSEEN")) {
            int unseen = folder.getUnseenCount();
            responseString = String.valueOf(responseString) + "UNSEEN " + unseen + " ";
        }
        if (this.getRequests().contains("UIDNEXT")) {
            long uid = folder.getLikelyUID();
            responseString = String.valueOf(responseString) + "UIDNEXT " + uid + " ";
        }
        if (this.getRequests().contains("UIDVALIDTY")) {
            responseString = String.valueOf(responseString) + "UIDVALIDITY 9223372036854775807";
        }
        responseString = String.valueOf(responseString.trim()) + ")";
        this.untaggedSimpleResponse("\"" + this.getFolder() + "\" " + responseString);
        this.taggedSimpleSuccess();
        return res;
    }

    public String getFolder() {
        return this._folder;
    }

    public void setFolder(String mailbox) {
        this._folder = mailbox;
    }

    public List getRequests() {
        return this._requests;
    }

    public void setRequests(List requests) {
        this._requests = requests;
    }
}

