/*
 * Decompiled with CFR 0.152.
 */
package org.buni.meldware.mail.imap4.commands;

import org.buni.meldware.common.util.ArrayUtil;
import org.buni.meldware.mail.api.Folder;
import org.buni.meldware.mail.api.FolderExistsException;
import org.buni.meldware.mail.api.Mailbox;
import org.buni.meldware.mail.imap4.IMAP4ProtocolInstance;
import org.buni.meldware.mail.imap4.IMAP4Response;
import org.buni.meldware.mail.imap4.commands.AbstractImapCommand;

public class RenameCommand
extends AbstractImapCommand {
    String old_folder;
    String new_folder;

    public RenameCommand() {
        super("RENAME");
    }

    public boolean isValidForState() {
        return this.getProtocolInstance().getState() == 1;
    }

    public IMAP4Response execute() {
        IMAP4Response response = this.constructResponse();
        IMAP4ProtocolInstance pi = this.getProtocolInstance();
        Object[] source = this.getPath(this.old_folder);
        String[] target = this.getPath(this.new_folder);
        Mailbox mailbox = pi.getMailboxProxy();
        Folder sf = mailbox.getFolder((String[])source);
        if (sf == null) {
            this.taggedResponse("NO rename failure: source folder %s does not exist", ArrayUtil.join((Object[])source, (String)"/"));
        } else {
            try {
                sf.rename(target);
            }
            catch (FolderExistsException e) {
                this.taggedResponse("NO rename failure: %s", e.getMessage());
            }
        }
        this.taggedSimpleSuccess();
        return response;
    }

    public String getOldFolder() {
        return this.old_folder;
    }

    public String getNewFolder() {
        return this.new_folder;
    }

    public void setOldFolder(String folder) {
        this.old_folder = folder;
    }

    public void setNewFolder(String folder) {
        this.new_folder = folder;
    }
}

