/*
 * Decompiled with CFR 0.152.
 */
package org.buni.meldware.mail.imap4.commands;

import java.util.List;
import org.buni.meldware.common.util.ArrayUtil;
import org.buni.meldware.mail.api.Folder;
import org.buni.meldware.mail.api.FolderFilter;
import org.buni.meldware.mail.api.Mailbox;
import org.buni.meldware.mail.imap4.IMAP4ProtocolInstance;
import org.buni.meldware.mail.imap4.IMAP4Response;
import org.buni.meldware.mail.imap4.commands.AbstractImapCommand;

public class ListCommand
extends AbstractImapCommand {
    String folder;
    String reference;

    public ListCommand(String name) {
        super(name);
    }

    public ListCommand() {
        this("LIST");
    }

    public boolean isValidForState() {
        return this.getProtocolInstance().getState() == 1;
    }

    public IMAP4Response execute() {
        IMAP4Response response = this.constructResponse();
        IMAP4ProtocolInstance pi = this.getProtocolInstance();
        if (!this.getFolder().equals("")) {
            Folder refFolder;
            Mailbox mailbox = pi.getMailboxProxy();
            if (this.getReference().trim().length() > 0) {
                String[] reference = this.getPath(this.getReference());
                refFolder = mailbox.getFolder(reference);
            } else {
                refFolder = mailbox.getRootFolder();
            }
            String[] tmpPath = this.getPath(this.getFolder());
            String[] path = new String[tmpPath.length - 1];
            System.arraycopy(tmpPath, 0, path, 0, path.length);
            IMAPFolderFilter filter = new IMAPFolderFilter(tmpPath[tmpPath.length - 1]);
            List<Folder> folders = refFolder.getSubFolders(path, filter);
            for (Folder folder : folders) {
                String folderPath = ArrayUtil.join((Object[])folder.getPath(), (String)"/");
                this.untaggedSimpleResponse("() \"/\" \"" + folderPath + "\"");
            }
        }
        if (this.getReference().equals("") && this.getFolder().equals("")) {
            this.untaggedSimpleResponse("(\\Noselect) \"/\" \"\"");
        }
        this.taggedSimpleSuccess();
        this.flush();
        return response;
    }

    public String getFolder() {
        return this.folder;
    }

    public void setFolder(String mailbox) {
        this.folder = mailbox;
    }

    public String getReference() {
        return this.reference;
    }

    public void setReference(String reference) {
        this.reference = reference;
    }

    private static class IMAPFolderFilter
    implements FolderFilter {
        private String name;
        private FilterType type;

        public IMAPFolderFilter(String name) {
            this.name = name;
            if ("*".equals(name) || "%".equals(name)) {
                this.type = FilterType.WILDCARD;
            } else if (name.endsWith("%")) {
                this.type = FilterType.PARTIAL;
                name = name.substring(0, name.length() - 1);
            } else {
                this.type = FilterType.COMPLETE;
            }
        }

        public boolean isRecursive() {
            return "*".equals(this.name);
        }

        public boolean match(String folder) {
            switch (this.type) {
                case WILDCARD: {
                    return true;
                }
                case PARTIAL: {
                    return folder.startsWith(this.name);
                }
                case COMPLETE: {
                    return folder.equals(this.name);
                }
            }
            return false;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static enum FilterType {
            WILDCARD,
            PARTIAL,
            COMPLETE;

        }
    }
}

