/*
 * Decompiled with CFR 0.152.
 */
package org.buni.meldware.mail.imap4.commands;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.buni.meldware.common.logging.Log;
import org.buni.meldware.mail.MailException;
import org.buni.meldware.mail.StreamWriteException;
import org.buni.meldware.mail.api.Folder;
import org.buni.meldware.mail.api.FolderMessage;
import org.buni.meldware.mail.api.Range;
import org.buni.meldware.mail.imap4.IMAP4OutputStream;
import org.buni.meldware.mail.imap4.IMAP4ProtocolInstance;
import org.buni.meldware.mail.imap4.IMAP4Response;
import org.buni.meldware.mail.imap4.commands.AbstractImapCommand;
import org.buni.meldware.mail.imap4.commands.fetch.BodyPartRequest;
import org.buni.meldware.mail.imap4.commands.fetch.FetchPart;
import org.buni.meldware.mail.imap4.commands.fetch.MessagePropertyPart;
import org.buni.meldware.mail.imap4.commands.fetch.MsgFilter;
import org.buni.meldware.mail.imap4.commands.fetch.MsgSetFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FetchCommand
extends AbstractImapCommand {
    private static final int BUFFER_SIZE = 8192;
    private static final Log log = Log.getLog(FetchCommand.class);
    private boolean isUID;
    private MsgFilter range;
    private List<FetchPart> parts = new ArrayList<FetchPart>();

    public FetchCommand(boolean isUID) {
        super(isUID ? "UID FETCH" : "FETCH");
        this.isUID = isUID;
    }

    @Override
    public boolean isValidForState() {
        return this.getProtocolInstance().getState() == 2;
    }

    @Override
    public IMAP4Response execute() {
        IMAP4Response result = this.constructResponse();
        IMAP4ProtocolInstance protocol = this.getProtocolInstance();
        MessagePropertyPart uidPart = new MessagePropertyPart("UID");
        if (this.isUID && !this.parts.contains(uidPart)) {
            this.parts.add(0, uidPart);
        }
        boolean isPeek = true;
        for (FetchPart obj : this.parts) {
            if (!(obj instanceof BodyPartRequest) || ((BodyPartRequest)obj).getPeek()) continue;
            isPeek = false;
        }
        IMAP4OutputStream out = new IMAP4OutputStream(new BufferedOutputStream(this.getOutputStream(), 8192), "US-ASCII");
        try {
            if (this.range instanceof MsgSetFilter) {
                MsgSetFilter filter = (MsgSetFilter)this.range;
                Folder f = protocol.getFolderProxy();
                int maxValue = this.isUID ? f.getMaxUid() : f.getMessageCount();
                Range[] ranges = this.createRanges(filter, maxValue);
                List<FolderMessage> messages = f.getMessages(this.isUID, ranges);
                List<String> flags = Arrays.asList("\\SEEN");
                for (FolderMessage msg : messages) {
                    if (!(isPeek || protocol.isFolderReadOnly() || msg.isSeen())) {
                        msg.setFlags(false, flags);
                    }
                    this.untaggedResponse(out);
                    int seqNum = f.getSeqNum(msg.getUid());
                    this.fetchMessage(msg, seqNum, out);
                }
            } else {
                throw new MailException("Fetch requires Sequence Set");
            }
            this.taggedSimpleSuccess(out);
            out.flush();
            this.flush();
        }
        catch (IOException e) {
            result.setFinish(true);
            log.error((Object)e);
        }
        catch (StreamWriteException e) {
            result.setFinish(true);
            log.error((Object)e);
        }
        catch (MailException e) {
            result.setFinish(true);
            log.error((Object)e);
        }
        return result;
    }

    private void fetchMessage(FolderMessage msg, int seq, IMAP4OutputStream out) {
        try {
            out.write(String.valueOf(seq));
            out.write(" FETCH (");
            Iterator<FetchPart> i = this.parts.iterator();
            while (i.hasNext()) {
                FetchPart part = i.next();
                part.fetch(msg, out);
                if (!i.hasNext()) continue;
                out.write(" ");
            }
            out.write(")\r\n");
        }
        catch (IOException e) {
            throw new StreamWriteException(e);
        }
    }

    public void appendPartRequest(FetchPart part) {
        if (this.parts.contains(part)) {
            return;
        }
        this.parts.add(part);
    }

    public List<FetchPart> getParts() {
        return this.parts;
    }

    public MsgFilter getRange() {
        return this.range;
    }

    public void setRange(MsgFilter range) {
        this.range = range;
    }

    public boolean isUid() {
        return this.isUID;
    }
}

