/*
 * Decompiled with CFR 0.152.
 */
package org.buni.meldware.mail.imap4.commands;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import org.buni.meldware.common.logging.Log;
import org.buni.meldware.mail.StreamWriteException;
import org.buni.meldware.mail.api.Folder;
import org.buni.meldware.mail.api.Range;
import org.buni.meldware.mail.imap4.IMAP4OutputStream;
import org.buni.meldware.mail.imap4.IMAP4ProtocolInstance;
import org.buni.meldware.mail.imap4.IMAP4Request;
import org.buni.meldware.mail.imap4.IMAP4Response;
import org.buni.meldware.mail.imap4.commands.fetch.MsgRangeFilter;
import org.buni.meldware.mail.imap4.commands.fetch.MsgSetFilter;

public abstract class AbstractImapCommand {
    private static final Log log = Log.getLog(AbstractImapCommand.class);
    String _tag;
    IMAP4ProtocolInstance protocol;
    IMAP4Request request;
    IMAP4Response response;
    PrintWriter writer;
    final String _cmdName;

    public AbstractImapCommand(String name) {
        this._cmdName = name;
    }

    void taggedResponse(String s) {
        try {
            this.response.getWriter().println(String.valueOf(this._tag) + " " + s);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    void taggedResponse(String format, Object ... args) {
        try {
            String s = String.format(format, args);
            this.response.getWriter().println(String.valueOf(this._tag) + " " + s);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected void taggedSuccess(String s) {
        try {
            this.response.getWriter().println(String.valueOf(this._tag) + " OK " + s);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected void taggedSimpleSuccess() {
        try {
            this.response.getWriter().println(String.valueOf(this._tag) + " OK " + this.getCmdName() + " completed");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected void taggedSimpleSuccess(IMAP4OutputStream out) {
        try {
            out.write(this._tag);
            out.write(" OK ");
            out.write(this.getCmdName());
            out.write(" completed\r\n");
        }
        catch (IOException e) {
            throw new StreamWriteException(e);
        }
    }

    protected void sendContinuation(String s) {
        try {
            this.response.getWriter().println("+" + (s == null || s.length() < 1 ? "" : " " + s));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected void println(String s) {
        try {
            this.response.getWriter().println(s);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected void flush() {
        try {
            this.response.getWriter().flush();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected void taggedFailure(String s) {
        try {
            this.response.getWriter().println(String.valueOf(this._tag) + " NO " + s);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected void taggedFailure(String msg, Object ... args) {
        try {
            String s = String.format(msg, args);
            this.response.getWriter().println(String.valueOf(this._tag) + " NO " + s);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected void taggedSimpleFailure() {
        try {
            this.response.getWriter().println(String.valueOf(this._tag) + " NO " + this.getCmdName() + " failed");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected void taggedExceptionFailure(Throwable exception) {
        try {
            this.response.getWriter().println(String.valueOf(this._tag) + " BAD " + exception.getMessage());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected void untaggedResponse(String s) {
        try {
            this.response.getWriter().println("* " + s);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected void untaggedResponse(IMAP4OutputStream out) {
        try {
            out.write("* ");
        }
        catch (IOException e) {
            throw new StreamWriteException(e);
        }
    }

    protected void untaggedSuccess(String format, Object ... args) {
        try {
            String s = String.format(format, args);
            this.response.getWriter().println("* OK " + s);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected void untaggedSuccess(String s) {
        try {
            this.response.getWriter().println("* OK " + s);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected void untaggedSimpleResponse(String s) {
        try {
            this.response.getWriter().println("* " + this.getCmdName() + " " + s);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public OutputStream getOutputStream() {
        OutputStream stream = null;
        try {
            stream = this.response.getOutputStream();
        }
        catch (Exception exception) {}
        return stream;
    }

    protected void untaggedMailboxChanges() {
        IMAP4ProtocolInstance pi = this.getProtocolInstance();
        Folder f = pi.getFolderProxy();
        if (f != null) {
            int exists = f.getMessageCount();
            int recent = f.getRecentCount();
            log.info("Exists: %d, Recent: %d", new Object[]{exists, recent});
            try {
                this.response.getWriter().println("* " + exists + " EXISTS");
                this.response.getWriter().println("* " + recent + " RECENT");
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public void setTag(String s) {
        this._tag = s;
    }

    public String getTag() {
        return this._tag;
    }

    public abstract boolean isValidForState();

    public abstract IMAP4Response execute();

    public void setProtocolInstance(IMAP4ProtocolInstance prot) {
        this.protocol = prot;
    }

    public IMAP4ProtocolInstance getProtocolInstance() {
        return this.protocol;
    }

    public void setRequest(IMAP4Request request) {
        this.request = request;
    }

    public IMAP4Request getRequest() {
        return this.request;
    }

    public Range[] createRanges(MsgSetFilter filter, int maxValue) {
        MsgRangeFilter[] filterRanges = filter.getMessageRangeFilters();
        Range[] ranges = new Range[filterRanges.length];
        int i = 0;
        while (i < filterRanges.length) {
            MsgRangeFilter filterRange = filterRanges[i];
            int bottom = filterRange.isUnbounded() && filterRange.getBottom() == 0 ? maxValue : filterRange.getBottom();
            int top = filterRange.isUnbounded() && filterRange.getTop() == Integer.MAX_VALUE ? maxValue : filterRange.getTop();
            ranges[i] = new Range(top, bottom);
            ++i;
        }
        return ranges;
    }

    public String[] getPath(String folderName) {
        String[] path = folderName.split("/");
        ArrayList<String> as = new ArrayList<String>();
        String[] stringArray = path;
        int n = 0;
        int n2 = stringArray.length;
        while (n < n2) {
            String pathElement = stringArray[n];
            if (pathElement != null && pathElement.trim().length() != 0) {
                as.add(pathElement);
            }
            ++n;
        }
        return as.toArray(new String[0]);
    }

    public IMAP4Response constructResponse() {
        if (this.response != null) {
            throw new RuntimeException("PROGRAMMING ERROR ATTEMPT TO CONSTRUCT RESPONSE WHEN RESPONSE IS NOT NULL");
        }
        try {
            this.response = new IMAP4Response(this.request, this.request.getSocket().getOutputStream(), this.protocol);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return this.response;
    }

    public void setResponse(IMAP4Response response) {
        if (response != null) {
            throw new RuntimeException("PROGRAMMING ERROR ATTEMPT TO SET RESPONSE WHEN RESPONSE IS NOT NULL");
        }
        this.response = response;
    }

    public String getCmdName() {
        return this._cmdName;
    }
}

