/*
 * Decompiled with CFR 0.152.
 */
package org.buni.meldware.mail.imap4.commands;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import org.buni.meldware.mail.imap4.IMAP4ProtocolInstance;
import org.buni.meldware.mail.imap4.commands.IMAP4MessageFlags;
import org.buni.meldware.mail.imap4.commands.IMAP4UserMessages;

public class AbstractCommand
implements IMAP4UserMessages,
IMAP4MessageFlags {
    protected void send(PrintWriter writer, String message) {
        writer.println(message);
    }

    protected void sendTagged(PrintWriter writer, String tag, String message) {
        this.send(writer, String.valueOf(tag) + " " + message);
    }

    protected void sendUntagged(PrintWriter writer, String message) {
        this.send(writer, "* " + message);
    }

    protected void sendContinuation(PrintWriter writer, String message) {
        this.send(writer, "+" + (message == null || message.length() < 1 ? "" : " " + message));
    }

    protected void sendContinuation(PrintWriter writer) {
        this.sendContinuation(writer, "");
    }

    boolean verifyArgumentCount(PrintWriter writer, String tag, String[] arguments, int expectedCount) {
        if (arguments.length < expectedCount) {
            this.sendTagged(writer, tag, "BAD This command requires a parameter.");
            return false;
        }
        if (arguments.length > expectedCount) {
            this.sendTagged(writer, tag, "BAD Too many parameters specified.");
            return false;
        }
        return true;
    }

    boolean verifyArgumentCount(String tag, String[] arguments, OutputStream out, int expectedCount) throws IOException {
        tag = String.valueOf(tag) + " ";
        if (arguments.length < expectedCount) {
            out.write(tag.getBytes());
            out.write(MESSAGE_ARGUMENT_MISSING_BYTES);
            out.write(ENDL);
            return false;
        }
        if (arguments.length > expectedCount) {
            out.write(tag.getBytes());
            out.write(MESSAGE_TOO_MANY_ARGUMENTS_BYTES);
            out.write(ENDL);
            return false;
        }
        return true;
    }

    boolean verifyState(PrintWriter writer, String tag, IMAP4ProtocolInstance protocol, int expectedState) {
        if (protocol.getState() != expectedState) {
            this.sendTagged(writer, tag, "BAD Command not allowed at this time");
            return false;
        }
        return true;
    }

    boolean verifyState(String tag, IMAP4ProtocolInstance protocol, OutputStream out, int expectedState) throws IOException {
        tag = String.valueOf(tag) + " ";
        if (protocol.getState() != expectedState) {
            out.write(tag.getBytes());
            out.write(MESSAGE_INVALID_STATE_BYTES);
            out.write(ENDL);
            return false;
        }
        return true;
    }
}

