/*
 * Decompiled with CFR 0.152.
 */
package org.buni.meldware.mail.imap4;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.management.ObjectName;
import org.buni.meldware.common.logging.Log;
import org.buni.meldware.mail.AbstractProtocol;
import org.buni.meldware.mail.AbstractResponse;
import org.buni.meldware.mail.MailException;
import org.buni.meldware.mail.Protocol;
import org.buni.meldware.mail.Request;
import org.buni.meldware.mail.Response;
import org.buni.meldware.mail.api.Folder;
import org.buni.meldware.mail.api.Mailbox;
import org.buni.meldware.mail.imap4.IMAP4Request;
import org.buni.meldware.mail.imap4.IMAP4Response;
import org.buni.meldware.mail.imap4.MutableIMAP4Request;
import org.buni.meldware.mail.imap4.commands.AbstractImapCommand;
import org.buni.meldware.mail.imap4.parser.ImapLineParser;
import org.buni.meldware.mail.mailbox.MailboxProxy;
import org.buni.meldware.mail.mailbox.MailboxService;
import org.buni.meldware.mail.mailbox.MessageData;
import org.buni.meldware.mail.message.Mail;
import org.buni.meldware.mail.message.MailBodyManager;
import org.buni.meldware.mail.userrepository.UserRepository;
import org.jboss.aop.Advised;
import org.jboss.aop.Advisor;
import org.jboss.aop.AspectManager;
import org.jboss.aop.ClassAdvisor;
import org.jboss.aop.ClassInstanceAdvisor;
import org.jboss.aop.InstanceAdvisor;
import org.jboss.aop.MethodInfo;
import org.jboss.aop.advice.Interceptor;
import org.jboss.aop.instrument.Untransformable;
import org.jboss.aop.joinpoint.Invocation;
import org.jboss.aop.joinpoint.InvocationBase;
import org.jboss.aop.joinpoint.MethodInvocation;
import org.jboss.aspects.tx.Tx;
import org.jboss.aspects.tx.TxType;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IMAP4ProtocolInstance
extends AbstractProtocol
implements Protocol,
Advised {
    private Log log = Log.getLog(IMAP4ProtocolInstance.class);
    public static final int STATE_NOT_AUTHENTICATED = 0;
    public static final int STATE_AUTHENTICATED = 1;
    public static final int STATE_SELECTED = 2;
    public static final int STATE_LOGOUT = 3;
    private int state;
    private String username = null;
    private MailboxProxy mailboxProxy = null;
    private Folder folderProxy = null;
    private boolean folderReadOnly;
    private MailboxService mailboxManager = null;
    private static ClassAdvisor aop$classAdvisor$aop = AspectManager.instance().getAdvisor(Class.forName("org.buni.meldware.mail.imap4.IMAP4ProtocolInstance"));
    protected transient ClassInstanceAdvisor _instanceAdvisor;
    private static WeakReference aop$MethodInfo_authenticate3447398754441971869;
    private static WeakReference aop$MethodInfo_createMail995489365440431252;

    public IMAP4ProtocolInstance(Map handlers, ObjectName parent, MailboxService mailboxManager) {
        super(parent);
        this.mailboxManager = mailboxManager;
        this.state = 0;
    }

    @Override
    public String getName() {
        return "IMAP4";
    }

    @Override
    public void greet(OutputStream stream) throws IOException {
        PrintWriter writer = AbstractResponse.getWrappedWriter(new PrintWriter(stream));
        writer.println("* OK " + this.getProperty("Servername") + " IMAP4 Server (Meldware Mail IMAP4rev1 Server version 0.7) ");
        writer.flush();
    }

    @Override
    public void greet(SocketChannel ioChannel) throws IOException {
        char[] chr = new String("* OK " + this.getProperty("Servername") + " IMAP4 Server (Meldware Mail IMAP4rev1 Server version 0.7) ").toCharArray();
        ByteBuffer buffer = ByteBuffer.allocate(chr.length * 2);
        buffer.asCharBuffer().put(chr);
        ioChannel.write(buffer);
    }

    @Override
    public Request parseRequest(InputStream stream, Socket socket) throws IOException {
        MutableIMAP4Request request = new MutableIMAP4Request(this, stream);
        String commandString = this.readCommand(stream);
        this.log.debug("Command: %s", new Object[]{commandString});
        String[] command = this.parseCommand(commandString);
        request.setTag(command[0].trim());
        if (command[1] == null) {
            command = null;
            return request;
        }
        ImapLineParser parser = new ImapLineParser();
        AbstractImapCommand c = parser.parseCommand(commandString);
        c.setProtocolInstance(this);
        request.setSocket(socket);
        c.setRequest(request);
        request.setCommand(c);
        return request;
    }

    @Override
    public Response handleRequest(OutputStream stream, Request request) {
        this.log.debug("HandleRequest called with request = %b", new Object[]{request == null});
        this.log.debug("HandleRequest called with command = %b", new Object[]{request == null});
        IMAP4Response response = null;
        try {
            if (((IMAP4Request)request).getCommand() != null) {
                response = ((IMAP4Request)request).getCommand().execute();
                response.getWriter().flush();
            } else {
                System.err.println("Got null command somehow");
            }
        }
        catch (IOException e) {
            this.log.error((Object)e);
            this.handleIOError(stream);
        }
        return response;
    }

    @Override
    public Response handleIOError(OutputStream stream) {
        this.log.error((Object)"Handle IO Error");
        return null;
    }

    public String readResponse(Request request) throws IOException {
        return this.readCommand(((IMAP4Request)request).getInputStream());
    }

    public Mailbox getMailboxProxy() {
        if (this.mailboxProxy == null) {
            org.buni.meldware.mail.mailbox.Mailbox mailbox = this.mailboxManager.getMailboxByAlias(this.username);
            this.mailboxProxy = new MailboxProxy(this.mailboxManager, mailbox);
        }
        return this.mailboxProxy;
    }

    public Folder getFolderProxy() {
        return this.folderProxy;
    }

    public Folder selectFolder(String[] path) {
        this.folderProxy = null;
        if (path != null) {
            if ("INBOX".equalsIgnoreCase(path[0])) {
                path[0] = "INBOX";
            }
        } else {
            throw new MailException("Path not properly specified");
        }
        this.folderProxy = this.getMailboxProxy().getFolder(path);
        return this.folderProxy;
    }

    public void clearFolder() {
        this.folderProxy = null;
    }

    public int getState() {
        return this.state;
    }

    public void setState(int state) {
        this.state = state;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setProperties(List properties) {
    }

    public Element getProperties() {
        return null;
    }

    public boolean lock(org.buni.meldware.mail.mailbox.Folder folder) {
        return this.mailboxManager.lock(this.username, folder, new Date(System.currentTimeMillis() + (long)((Integer)this.getState("life")).intValue()));
    }

    public void release(org.buni.meldware.mail.mailbox.Folder folder) {
        this.mailboxManager.release(this.username, folder);
    }

    @Override
    public void handleCleanup(OutputStream out) {
        try {
            Folder f = this.getFolderProxy();
            if (f != null && !this.isFolderReadOnly()) {
                this.log.debug((Object)"Cleaning up deleted messages");
                f.expunge(false);
            }
            out.write("* BYE IMAP4rev1 Server logging out\r\n".getBytes());
        }
        catch (Exception e) {
            this.log.error((Throwable)e, (Object)"Failure during cleanup");
        }
    }

    @Tx(value=TxType.REQUIRED)
    public boolean org$buni$meldware$mail$imap4$IMAP4ProtocolInstance$authenticate$aop(String user, String pass) {
        boolean result = ((UserRepository)this.getProperty("UserRepository")).test(user, pass);
        this.setState(1);
        return result;
    }

    public MailBodyManager getManager() {
        return this.mailboxManager.getBodyManager();
    }

    @Tx(value=TxType.REQUIRED)
    public void org$buni$meldware$mail$imap4$IMAP4ProtocolInstance$createMail$aop(Mail m, org.buni.meldware.mail.mailbox.Folder folder, List<String> flags) {
        MessageData data = new MessageData(m);
        data.getFlagList().setFlags(true, flags);
        this.mailboxManager.createMail(folder, data);
    }

    public boolean isFolderReadOnly() {
        return this.folderReadOnly;
    }

    public void setFolderReadOnly(boolean folderReadOnly) {
        this.folderReadOnly = folderReadOnly;
    }

    public Advisor _getAdvisor() {
        return aop$classAdvisor$aop;
    }

    public InstanceAdvisor _getInstanceAdvisor() {
        IMAP4ProtocolInstance iMAP4ProtocolInstance = this;
        synchronized (iMAP4ProtocolInstance) {
            if (this._instanceAdvisor == null) {
                this._instanceAdvisor = new ClassInstanceAdvisor((Object)this);
            }
            return this._instanceAdvisor;
        }
    }

    public void _setInstanceAdvisor(InstanceAdvisor instanceAdvisor) {
        IMAP4ProtocolInstance iMAP4ProtocolInstance = this;
        synchronized (iMAP4ProtocolInstance) {
            this._instanceAdvisor = (ClassInstanceAdvisor)instanceAdvisor;
        }
    }

    @Tx(value=TxType.REQUIRED)
    public boolean authenticate(String string, String string2) {
        MethodInfo methodInfo = (MethodInfo)aop$MethodInfo_authenticate3447398754441971869.get();
        ClassInstanceAdvisor classInstanceAdvisor = (ClassInstanceAdvisor)this._getInstanceAdvisor();
        Interceptor[] interceptorArray = methodInfo.getInterceptors();
        if (interceptorArray != (Object[])null || classInstanceAdvisor != null && classInstanceAdvisor.hasInstanceAspects) {
            if (classInstanceAdvisor != null) {
                interceptorArray = classInstanceAdvisor.getInterceptors(interceptorArray);
            }
            authenticate_3447398754441971869 authenticate_34473987544419718692 = new authenticate_3447398754441971869(methodInfo, interceptorArray);
            authenticate_34473987544419718692.arg0 = string;
            authenticate_34473987544419718692.arg1 = string2;
            authenticate_34473987544419718692.setTargetObject(this);
            authenticate_34473987544419718692.typedTargetObject = this;
            authenticate_34473987544419718692.setAdvisor((Advisor)aop$classAdvisor$aop);
            return (Boolean)authenticate_34473987544419718692.invokeNext();
        }
        return this.org$buni$meldware$mail$imap4$IMAP4ProtocolInstance$authenticate$aop(string, string2);
    }

    @Tx(value=TxType.REQUIRED)
    public void createMail(Mail mail, org.buni.meldware.mail.mailbox.Folder folder, List list) {
        MethodInfo methodInfo = (MethodInfo)aop$MethodInfo_createMail995489365440431252.get();
        ClassInstanceAdvisor classInstanceAdvisor = (ClassInstanceAdvisor)this._getInstanceAdvisor();
        Interceptor[] interceptorArray = methodInfo.getInterceptors();
        if (interceptorArray != (Object[])null || classInstanceAdvisor != null && classInstanceAdvisor.hasInstanceAspects) {
            if (classInstanceAdvisor != null) {
                interceptorArray = classInstanceAdvisor.getInterceptors(interceptorArray);
            }
            createMail_995489365440431252 createMail_9954893654404312522 = new createMail_995489365440431252(methodInfo, interceptorArray);
            createMail_9954893654404312522.arg0 = mail;
            createMail_9954893654404312522.arg1 = folder;
            createMail_9954893654404312522.arg2 = list;
            createMail_9954893654404312522.setTargetObject(this);
            createMail_9954893654404312522.typedTargetObject = this;
            createMail_9954893654404312522.setAdvisor((Advisor)aop$classAdvisor$aop);
            createMail_9954893654404312522.invokeNext();
        } else {
            this.org$buni$meldware$mail$imap4$IMAP4ProtocolInstance$createMail$aop(mail, folder, list);
        }
    }

    public static class authenticate_3447398754441971869
    extends MethodInvocation
    implements Untransformable {
        public String arg0;
        public String arg1;
        public IMAP4ProtocolInstance typedTargetObject;

        public authenticate_3447398754441971869(MethodInfo methodInfo, Interceptor[] interceptorArray) {
            super(methodInfo, interceptorArray);
        }

        public authenticate_3447398754441971869(Interceptor[] interceptorArray, long l, Method method, Method method2, Advisor advisor) {
            super(interceptorArray, l, method, method2, advisor);
        }

        public authenticate_3447398754441971869(Interceptor[] interceptorArray) {
            super(interceptorArray);
        }

        public authenticate_3447398754441971869() {
        }

        public Object invokeNext() throws Throwable {
            if (((InvocationBase)this).currentInterceptor < ((InvocationBase)this).interceptors.length) {
                try {
                    Object object = ((InvocationBase)this).interceptors[((InvocationBase)this).currentInterceptor++].invoke((Invocation)this);
                    Object var3_2 = null;
                    --((InvocationBase)this).currentInterceptor;
                    return object;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    --((InvocationBase)this).currentInterceptor;
                    throw throwable;
                }
            }
            return new Boolean(this.typedTargetObject.org$buni$meldware$mail$imap4$IMAP4ProtocolInstance$authenticate$aop(this.arg0, this.arg1));
        }

        public void setArguments(Object[] objectArray) {
            this.arguments = objectArray;
            Object object = objectArray[0];
            this.arg0 = (String)object;
            Object object2 = objectArray[1];
            this.arg1 = (String)object2;
        }

        public Object[] getArguments() {
            if (this.marshalledArguments != null) {
                Object[] objectArray = super.getArguments();
                this.setArguments(objectArray);
                return objectArray;
            }
            if (this.arguments != (Object[])null) {
                return this.arguments;
            }
            this.arguments = new Object[2];
            this.arguments[0] = this.arg0;
            this.arguments[1] = this.arg1;
            return this.arguments;
        }

        public Invocation copy() {
            authenticate_3447398754441971869 authenticate_34473987544419718692 = new authenticate_3447398754441971869(((InvocationBase)this).interceptors, this.methodHash, this.advisedMethod, this.unadvisedMethod, ((InvocationBase)this).advisor);
            authenticate_34473987544419718692.arguments = this.arguments;
            ((InvocationBase)authenticate_34473987544419718692).metadata = ((InvocationBase)this).metadata;
            ((InvocationBase)authenticate_34473987544419718692).currentInterceptor = ((InvocationBase)this).currentInterceptor;
            ((InvocationBase)authenticate_34473987544419718692).instanceResolver = ((InvocationBase)this).instanceResolver;
            authenticate_34473987544419718692.typedTargetObject = this.typedTargetObject;
            ((InvocationBase)authenticate_34473987544419718692).targetObject = ((InvocationBase)this).targetObject;
            authenticate_34473987544419718692.arg0 = this.arg0;
            authenticate_34473987544419718692.arg1 = this.arg1;
            return authenticate_34473987544419718692;
        }
    }

    public static class createMail_995489365440431252
    extends MethodInvocation
    implements Untransformable {
        public Mail arg0;
        public org.buni.meldware.mail.mailbox.Folder arg1;
        public List arg2;
        public IMAP4ProtocolInstance typedTargetObject;

        public createMail_995489365440431252(MethodInfo methodInfo, Interceptor[] interceptorArray) {
            super(methodInfo, interceptorArray);
        }

        public createMail_995489365440431252(Interceptor[] interceptorArray, long l, Method method, Method method2, Advisor advisor) {
            super(interceptorArray, l, method, method2, advisor);
        }

        public createMail_995489365440431252(Interceptor[] interceptorArray) {
            super(interceptorArray);
        }

        public createMail_995489365440431252() {
        }

        public Object invokeNext() throws Throwable {
            if (((InvocationBase)this).currentInterceptor < ((InvocationBase)this).interceptors.length) {
                try {
                    Object object = ((InvocationBase)this).interceptors[((InvocationBase)this).currentInterceptor++].invoke((Invocation)this);
                    Object var3_2 = null;
                    --((InvocationBase)this).currentInterceptor;
                    return object;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    --((InvocationBase)this).currentInterceptor;
                    throw throwable;
                }
            }
            this.typedTargetObject.org$buni$meldware$mail$imap4$IMAP4ProtocolInstance$createMail$aop(this.arg0, this.arg1, this.arg2);
            return null;
        }

        public void setArguments(Object[] objectArray) {
            this.arguments = objectArray;
            Object object = objectArray[0];
            this.arg0 = (Mail)object;
            Object object2 = objectArray[1];
            this.arg1 = (org.buni.meldware.mail.mailbox.Folder)object2;
            Object object3 = objectArray[2];
            this.arg2 = (List)object3;
        }

        public Object[] getArguments() {
            if (this.marshalledArguments != null) {
                Object[] objectArray = super.getArguments();
                this.setArguments(objectArray);
                return objectArray;
            }
            if (this.arguments != (Object[])null) {
                return this.arguments;
            }
            this.arguments = new Object[3];
            this.arguments[0] = this.arg0;
            this.arguments[1] = this.arg1;
            this.arguments[2] = this.arg2;
            return this.arguments;
        }

        public Invocation copy() {
            createMail_995489365440431252 createMail_9954893654404312522 = new createMail_995489365440431252(((InvocationBase)this).interceptors, this.methodHash, this.advisedMethod, this.unadvisedMethod, ((InvocationBase)this).advisor);
            createMail_9954893654404312522.arguments = this.arguments;
            ((InvocationBase)createMail_9954893654404312522).metadata = ((InvocationBase)this).metadata;
            ((InvocationBase)createMail_9954893654404312522).currentInterceptor = ((InvocationBase)this).currentInterceptor;
            ((InvocationBase)createMail_9954893654404312522).instanceResolver = ((InvocationBase)this).instanceResolver;
            createMail_9954893654404312522.typedTargetObject = this.typedTargetObject;
            ((InvocationBase)createMail_9954893654404312522).targetObject = ((InvocationBase)this).targetObject;
            createMail_9954893654404312522.arg0 = this.arg0;
            createMail_9954893654404312522.arg1 = this.arg1;
            createMail_9954893654404312522.arg2 = this.arg2;
            return createMail_9954893654404312522;
        }
    }
}

