/*
 * Decompiled with CFR 0.152.
 */
package org.buni.meldware.mail.fetchmail;

import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import javax.mail.Header;

public class MailConcatInputStream
extends InputStream {
    private InputStream bodyStream;
    private String headerString;
    private int curChar;
    private int headerLen;
    private int state;
    private static final int STATE_HEADER = 1;
    private static final int STATE_BODY = 2;
    private static final int STATE_END = 3;

    public MailConcatInputStream(InputStream body, Enumeration headers) {
        this.bodyStream = body;
        this.state = 1;
        StringBuffer hdrs = new StringBuffer();
        while (headers.hasMoreElements()) {
            Header h = (Header)headers.nextElement();
            hdrs.append(h.getName());
            hdrs.append(": ");
            hdrs.append(h.getValue());
            hdrs.append("\r\n");
        }
        hdrs.append("\r\n");
        hdrs.append("\r\n");
        this.headerString = hdrs.toString();
        this.curChar = 0;
        this.headerLen = this.headerString.length();
    }

    public int read() throws IOException {
        int ret = -1;
        if (this.state == 1) {
            ret = this.headerString.charAt(this.curChar);
            ++this.curChar;
            if (this.curChar >= this.headerLen) {
                this.state = 2;
            }
        } else if (this.state == 2) {
            ret = this.bodyStream.read();
            if (ret == -1) {
                this.state = 3;
                this.curChar = 0;
            }
        } else if (this.state == 3) {
            if (this.curChar == 0) {
                ret = 13;
                ++this.curChar;
            } else if (this.curChar == 1) {
                ret = 10;
                ++this.curChar;
            } else if (this.curChar == 2) {
                ret = 46;
                ++this.curChar;
            } else if (this.curChar == 3) {
                ret = 13;
                ++this.curChar;
            } else if (this.curChar == 4) {
                ret = 10;
                ++this.curChar;
            } else {
                ret = -1;
            }
        } else {
            throw new RuntimeException("unknown state, bailing out");
        }
        return ret;
    }
}

