/*
 * Decompiled with CFR 0.152.
 */
package org.buni.meldware.mail;

import java.util.Map;
import org.apache.log4j.Logger;
import org.buni.meldware.mail.Closable;

class TimeAndLife {
    private static final Logger log = Logger.getLogger(TimeAndLife.class);
    private long thistime;
    private long time;
    private long life;
    private Thread thread;
    private boolean locked;
    private Map reapables;
    private Closable closable;

    public TimeAndLife(Closable closable, Thread thread, long time, long life, Map reapables) {
        this.closable = closable;
        this.time = time;
        this.life = life;
        this.thread = thread;
        this.reapables = reapables;
    }

    public void kill() {
        try {
            log.warn("Reaping Thread: " + this.thread.getId());
            this.closable.close();
        }
        catch (Exception exception) {}
        this.thread.interrupt();
    }

    public synchronized boolean check(long thetime) {
        boolean retval = false;
        if (!this.locked && this.thistime + this.time < thetime) {
            log.warn("Reaping Thread: " + this.thread.getId());
            this.closable.close();
            this.thread.interrupt();
            retval = true;
            this.reapables.remove(this.thread);
        }
        if (this.life < thetime) {
            log.warn("Reaping Thread: " + this.thread.getId());
            this.closable.close();
            this.thread.interrupt();
            retval = true;
        }
        return retval;
    }

    public synchronized void update(long time) {
        this.thistime = time;
    }

    synchronized void lock() {
        this.locked = true;
    }

    synchronized void unlock() {
        this.locked = false;
    }
}

