/*
 * Decompiled with CFR 0.152.
 */
package org.buni.meldware.mail;

import EDU.oswego.cs.dl.util.concurrent.PooledExecutor;
import java.io.IOException;
import java.net.Socket;
import java.nio.channels.ServerSocketChannel;
import javax.management.ObjectName;
import org.buni.meldware.mail.ConnectionHandler;
import org.buni.meldware.mail.Reaper;
import org.buni.meldware.mail.ThreadPoolMBean;
import org.jboss.system.ServiceMBeanSupport;

public class ThreadPool
extends ServiceMBeanSupport
implements ThreadPoolMBean {
    private int initial;
    private int min;
    private int max;
    private int idleKeepAlive;
    private PooledExecutor executor = new PooledExecutor();
    private Thread reaperThread;
    private Reaper reaper = new Reaper(this.pulse);
    private long pulse = 1000L;

    public void startService() {
        this.updateParms();
        this.revise();
        this.reaper.start();
        this.reaperThread = new Thread(this.reaper);
        this.reaperThread.start();
    }

    public void stopService() {
        this.reaper.stop();
        this.reaperThread.interrupt();
    }

    private void updateParms() {
        if (this.max > 0) {
            this.executor.setMaximumPoolSize(this.max);
        }
        this.executor.setMinimumPoolSize(this.min);
        this.executor.setKeepAliveTime((long)this.idleKeepAlive);
    }

    private void revise() {
        if (this.initial > this.executor.getPoolSize()) {
            this.executor.createThreads(this.initial - this.executor.getPoolSize());
        }
        if (this.min > this.executor.getPoolSize()) {
            this.executor.createThreads(this.min - this.executor.getPoolSize());
        }
    }

    public void handleConnection(Socket socket, ObjectName protocolName, long timeout, long life) throws InterruptedException {
        ConnectionHandler ch = new ConnectionHandler(socket, protocolName, timeout, life, this.reaper);
        this.executor.execute((Runnable)ch);
    }

    public void handleConnection(ServerSocketChannel ssc, ObjectName protocolName, long timeout, long life) throws InterruptedException {
        try {
            ConnectionHandler ch = new ConnectionHandler(ssc, protocolName, timeout, life, this.reaper);
            this.executor.execute((Runnable)ch);
        }
        catch (IOException e) {
            this.log.warn("IOException in ThreadPool.handleConnection for NIO ", e);
        }
    }

    public void setInitial(int initial) {
        this.initial = initial;
        this.updateParms();
    }

    public int getInitial() {
        return this.initial;
    }

    public int getMax() {
        return this.max;
    }

    public void setMax(int max) {
        this.max = max;
        this.updateParms();
        this.revise();
    }

    public int getMin() {
        return this.min;
    }

    public void setMin(int min) {
        this.min = min;
        this.updateParms();
        this.revise();
    }

    public int getIdleKeepAlive() {
        return this.idleKeepAlive;
    }

    public void setIdleKeepAlive(int idleKeepAlive) {
        this.idleKeepAlive = idleKeepAlive;
        this.updateParms();
        this.revise();
    }

    public int getPoolSize() {
        return this.executor.getPoolSize();
    }

    public int getActivePoolSize() {
        return this.reaper.getReapableSize();
    }
}

