/*
 * Decompiled with CFR 0.152.
 */
package org.buni.meldware.mail;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import javax.management.ObjectName;
import org.apache.log4j.Logger;
import org.buni.meldware.mail.Closable;
import org.buni.meldware.mail.Protocol;
import org.buni.meldware.mail.ProtocolFactory;
import org.buni.meldware.mail.Reaper;
import org.buni.meldware.mail.Request;
import org.buni.meldware.mail.Response;
import org.buni.meldware.mail.util.MMJMXUtil;

public class ConnectionHandler
implements Runnable {
    static final Logger log = Logger.getLogger(ConnectionHandler.class);
    private Socket socket;
    private ObjectName protocolName;
    private long timeout;
    private long life;
    private Protocol protocol;
    private Reaper reaper;
    private ServerSocketChannel ssc;
    private SocketChannel ioChannel;

    public ConnectionHandler(Socket socket, ObjectName protocolName, long timeout, long life, Reaper reap) {
        this.socket = socket;
        this.protocolName = protocolName;
        this.timeout = timeout;
        this.life = life;
        this.reaper = reap;
    }

    public ConnectionHandler(ServerSocketChannel ssc, ObjectName protocolName, long timeout, long life, Reaper reap) throws IOException {
        this((Socket)null, protocolName, timeout, life, reap);
        this.ssc = ssc;
        this.ioChannel = ssc.accept();
    }

    public void run() {
        if (this.ssc == null && this.socket != null) {
            this.runSocket();
        } else {
            this.runChannel();
        }
    }

    private void runChannel() {
        Thread thisthread = Thread.currentThread();
        Closable c = new Closable(){

            public void close() {
                try {
                    ConnectionHandler.this.ssc.close();
                }
                catch (IOException e) {
                    log.error(e);
                }
            }
        };
        this.reaper.register(c, thisthread, this.timeout, this.life);
        try {
            try {
                try {
                    this.protocol = MMJMXUtil.getMBean(this.protocolName, Protocol.class);
                }
                catch (Exception e1) {
                    throw new RuntimeException(String.valueOf(e1.toString()) + " cannot get protocol " + this.protocolName, e1);
                }
                this.protocol.setState("client address", this.ssc.socket().getInetAddress());
                this.protocol.setState("local address", this.ssc.socket().getLocalSocketAddress());
                Selector selector = Selector.open();
                this.ioChannel.configureBlocking(false);
                this.ioChannel.register(selector, 5);
                this.protocol.greet(this.ioChannel);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        finally {
            c.close();
            log.debug("ConnectionHandler finished");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void runSocket() {
        Thread thisthread = Thread.currentThread();
        Closable c = new Closable(){
            boolean isClosed = false;

            public void close() {
                if (!this.isClosed) {
                    this.isClosed = true;
                    try {
                        log.debug("Sending protocol BYE command");
                        OutputStream out = ConnectionHandler.this.socket.getOutputStream();
                        ConnectionHandler.this.protocol.handleCleanup(out);
                        out.flush();
                        out.close();
                        ConnectionHandler.this.socket.close();
                    }
                    catch (IOException e) {
                        log.error(e);
                    }
                }
            }
        };
        this.reaper.register(c, thisthread, this.timeout, this.life);
        try {
            try {
                try {
                    ProtocolFactory fact = MMJMXUtil.getMBean(this.protocolName, ProtocolFactory.class);
                    this.protocol = fact.createInstance();
                }
                catch (Exception e1) {
                    throw new RuntimeException(String.valueOf(e1.toString()) + " cannot get protocol " + this.protocolName, e1);
                }
                this.protocol.setState("client address", this.socket.getInetAddress());
                this.protocol.setState("local address", this.socket.getLocalAddress());
                this.protocol.setState("life", this.life);
                log.info("connected: " + this.protocol.getState("client address") + " to: " + this.protocol.getState("local address") + " until: " + this.protocol.getState("life"));
                BufferedInputStream input = new BufferedInputStream(this.socket.getInputStream());
                OutputStream output = this.socket.getOutputStream();
                this.protocol.greet(output);
                boolean loop = true;
                ((InputStream)input).mark(2);
                while (loop) {
                    if (((InputStream)input).read() == -1) {
                        return;
                    }
                    ((InputStream)input).reset();
                    Request request = this.protocol.parseRequest(input, this.socket);
                    this.reaper.lock(thisthread);
                    this.reaper.update(thisthread);
                    ((InputStream)input).mark(2);
                    Response response = this.protocol.handleRequest(output, request);
                    if (response.isSocketOverride()) {
                        this.socket = response.getSocketOverride();
                        input = new BufferedInputStream(this.socket.getInputStream());
                        output = this.socket.getOutputStream();
                    }
                    this.reaper.unlock(thisthread);
                    Thread.sleep(50L);
                    ((InputStream)input).mark(2);
                    loop = !response.isFinish();
                }
                return;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            catch (InterruptedException e2) {
                e2.printStackTrace();
                return;
            }
            catch (NullPointerException e3) {
                e3.printStackTrace();
                return;
            }
        }
        finally {
            c.close();
            this.reaper.remove(Thread.currentThread());
            log.debug("ConnectionHandler finished");
        }
    }
}

