/*
 * Decompiled with CFR 0.152.
 */
package org.drools.base.accumulators;

import org.drools.base.accumulators.AccumulateFunction;

public class SumAccumulateFunction
implements AccumulateFunction {
    public Object createContext() {
        return new SumData();
    }

    public void init(Object context) throws Exception {
        SumData data = (SumData)context;
        data.total = 0.0;
    }

    public void accumulate(Object context, Object value) {
        SumData data = (SumData)context;
        data.total += ((Number)value).doubleValue();
    }

    public void reverse(Object context, Object value) throws Exception {
        SumData data = (SumData)context;
        data.total -= ((Number)value).doubleValue();
    }

    public Object getResult(Object context) throws Exception {
        SumData data = (SumData)context;
        return new Double(data.total);
    }

    public boolean supportsReverse() {
        return true;
    }

    protected static class SumData {
        public double total = 0.0;

        protected SumData() {
        }
    }
}

