/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.virtual.plugins.context.file;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.List;
import java.util.Properties;
import org.jboss.virtual.VFSUtils;
import org.jboss.virtual.VirtualFile;
import org.jboss.virtual.plugins.context.AbstractVFSContext;
import org.jboss.virtual.plugins.context.file.FileHandler;
import org.jboss.virtual.plugins.context.file.LinkHandler;
import org.jboss.virtual.plugins.context.jar.JarHandler;
import org.jboss.virtual.plugins.context.jar.JarUtils;
import org.jboss.virtual.spi.LinkInfo;
import org.jboss.virtual.spi.VirtualFileHandler;

public class FileSystemContext
extends AbstractVFSContext {
    private final VirtualFileHandler root;
    private final VirtualFile rootFile;

    private static File getFile(URI uri) throws IOException, URISyntaxException {
        if (uri == null) {
            throw new IllegalArgumentException("Null uri");
        }
        if (uri.getAuthority() != null || uri.getFragment() != null || uri.getQuery() != null) {
            uri = new URI("file", null, uri.getPath(), null);
        }
        return new File(uri);
    }

    private static URI getFileURI(File file) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException("Null file");
        }
        URI url = file.toURI();
        String path = url.getPath();
        if (!file.isDirectory()) {
            path = VFSUtils.fixName(path);
        } else if (!path.endsWith("/")) {
            path = path + '/';
        }
        try {
            return new URI("file", null, path, null);
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException("Failed to convert file.toURI", e);
        }
    }

    public FileSystemContext(URL rootURL) throws IOException, URISyntaxException {
        this(VFSUtils.toURI(rootURL));
    }

    public FileSystemContext(URI rootURI) throws IOException, URISyntaxException {
        this(rootURI, FileSystemContext.getFile(rootURI));
    }

    public FileSystemContext(File file) throws IOException, URISyntaxException {
        this(FileSystemContext.getFileURI(file), file);
    }

    private FileSystemContext(URI rootURI, File file) throws IOException {
        super(rootURI);
        this.root = this.createVirtualFileHandler(null, file);
        this.rootFile = this.root.getVirtualFile();
    }

    public VirtualFileHandler getRoot() throws IOException {
        return this.root;
    }

    public VirtualFileHandler createVirtualFileHandler(VirtualFileHandler parent, File file) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException("Null file");
        }
        URI fileURL = FileSystemContext.getFileURI(file);
        if (file.isFile() && JarUtils.isArchive(file.getName())) {
            String name = file.getName();
            try {
                return new JarHandler(this, parent, file, file.toURL(), name);
            }
            catch (IOException e) {
                this.log.debug((Object)e.getMessage());
            }
        }
        return this.createVirtualFileHandler(parent, file, fileURL);
    }

    public VirtualFileHandler createVirtualFileHandler(VirtualFileHandler parent, File file, URI uri) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException("Null file");
        }
        if (uri == null) {
            throw new IllegalArgumentException("Null uri");
        }
        VirtualFileHandler handler = null;
        if (VFSUtils.isLink(file.getName())) {
            Properties props = new Properties();
            FileInputStream fis = new FileInputStream(file);
            try {
                List<LinkInfo> links = VFSUtils.readLinkInfo(fis, file.getName(), props);
                String name = props.getProperty("vfs.link.name", "link");
                handler = new LinkHandler(this, parent, uri, name, links);
            }
            catch (URISyntaxException e) {
                IOException ex = new IOException("Failed to parse link URIs");
                ex.initCause(e);
                throw ex;
            }
            finally {
                try {
                    fis.close();
                }
                catch (IOException e) {
                    this.log.debug((Object)("Exception closing file input stream: " + fis), (Throwable)e);
                }
            }
        }
        if (!file.exists() && parent != null) {
            List<VirtualFileHandler> children = parent.getChildren(true);
            for (VirtualFileHandler vfh : children) {
                if (!vfh.getName().equals(file.getName())) continue;
                handler = vfh;
                break;
            }
            if (handler == null) {
                throw new FileNotFoundException("File does not exist: " + file.getCanonicalPath());
            }
        } else {
            handler = new FileHandler(this, parent, file, uri);
        }
        return handler;
    }

    protected void finalize() throws Throwable {
        if (this.rootFile != null) {
            this.rootFile.close();
        }
        super.finalize();
    }
}

