/*
 * Decompiled with CFR 0.152.
 */
package org.mvel.optimizers.impl.asm;

import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.mvel.Accessor;
import org.mvel.CompileException;
import org.mvel.DataConversion;
import org.mvel.ExecutableAccessor;
import org.mvel.ExecutableLiteral;
import org.mvel.ExecutableStatement;
import org.mvel.MVEL;
import org.mvel.OptimizationFailure;
import org.mvel.PropertyAccessException;
import org.mvel.SetAccessor;
import org.mvel.asm.ClassWriter;
import org.mvel.asm.FieldVisitor;
import org.mvel.asm.Label;
import org.mvel.asm.MethodVisitor;
import org.mvel.asm.Type;
import org.mvel.ast.LiteralNode;
import org.mvel.ast.PropertyASTNode;
import org.mvel.integration.VariableResolverFactory;
import org.mvel.optimizers.AbstractOptimizer;
import org.mvel.optimizers.AccessorOptimizer;
import org.mvel.optimizers.OptimizationNotSupported;
import org.mvel.optimizers.impl.refl.Union;
import org.mvel.util.ArrayTools;
import org.mvel.util.CollectionParser;
import org.mvel.util.MethodStub;
import org.mvel.util.ParseTools;
import org.mvel.util.PropertyTools;
import org.mvel.util.StringAppender;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ASMAccessorOptimizer
extends AbstractOptimizer
implements AccessorOptimizer {
    private static final String MAP_IMPL = "java/util/HashMap";
    private static final String LIST_IMPL = "org/mvel/util/FastList";
    private static final int OPCODES_VERSION;
    private Object ctx;
    private Object thisRef;
    private VariableResolverFactory variableFactory;
    private static final Object[] EMPTYARG;
    private static final Class[] EMPTYCLS;
    private boolean first = true;
    private boolean deferFinish = false;
    private String className;
    private ClassWriter cw;
    private MethodVisitor mv;
    private Object val;
    private int stacksize = 1;
    private long time;
    private ArrayList<ExecutableStatement> compiledInputs;
    private Class returnType;
    private StringAppender buildLog;
    private static final ClassLoader classLoader;
    private static final Method defineClass;
    private int cnum = 3;
    private int lastCnum = 0;
    private static final int ARRAY = 0;
    private static final int LIST = 1;
    private static final int MAP = 2;
    private static final int VAL = 3;

    static {
        String javaVersion = System.getProperty("java.version");
        OPCODES_VERSION = javaVersion.startsWith("1.4") ? 48 : (javaVersion.startsWith("1.5") ? 49 : (javaVersion.startsWith("1.6") || javaVersion.startsWith("1.7") ? 50 : 46));
        EMPTYARG = new Object[0];
        EMPTYCLS = new Class[0];
        try {
            Class<?> clazz;
            Class<?> clazz2;
            Class<?> clazz3;
            classLoader = Thread.currentThread().getContextClassLoader();
            try {
                clazz3 = Class.forName("java.lang.ClassLoader");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            Class[] classArray = new Class[4];
            try {
                clazz2 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            classArray[0] = clazz2;
            try {
                clazz = Class.forName("[B");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            classArray[1] = clazz;
            classArray[2] = Integer.TYPE;
            classArray[3] = Integer.TYPE;
            defineClass = clazz3.getDeclaredMethod("defineClass", classArray);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public ASMAccessorOptimizer() {
        new ClassWriter(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _initJIT() {
        if (MVEL.isAdvancedDebugging()) {
            this.buildLog = new StringAppender();
        }
        this.cw = new ClassWriter(3);
        Runtime runtime = Runtime.getRuntime();
        synchronized (runtime) {
            int r = (int)Math.random() * 100;
            this.className = new StringBuffer("ASMAccessorImpl_").append(String.valueOf(this.cw.hashCode()).replaceAll("\\-", "_")).append(System.currentTimeMillis() / 10L).append(r).toString();
            this.cw.visit(OPCODES_VERSION, 33, this.className, null, "java/lang/Object", new String[]{"org/mvel/Accessor"});
        }
        MethodVisitor m = this.cw.visitMethod(1, "<init>", "()V", null, null);
        m.visitCode();
        m.visitVarInsn(25, 0);
        m.visitMethodInsn(183, "java/lang/Object", "<init>", "()V");
        m.visitInsn(177);
        m.visitMaxs(1, 1);
        m.visitEnd();
        this.mv = this.cw.visitMethod(1, "getValue", "(Ljava/lang/Object;Ljava/lang/Object;Lorg/mvel/integration/VariableResolverFactory;)Ljava/lang/Object;", null, null);
        this.mv.visitCode();
    }

    @Override
    public Accessor optimizeAccessor(char[] property, Object staticContext, Object thisRef, VariableResolverFactory factory, boolean root) {
        this.time = System.currentTimeMillis();
        this.compiledInputs = new ArrayList();
        this.cursor = 0;
        this.start = 0;
        this.first = true;
        this.val = null;
        this.length = property.length;
        this.expr = property;
        this.ctx = staticContext;
        this.thisRef = thisRef;
        this.variableFactory = factory;
        this._initJIT();
        return this.compileAccessor();
    }

    @Override
    public SetAccessor optimizeSetAccessor(char[] property, Object ctx, Object thisRef, VariableResolverFactory factory, boolean rootThisRef, Object value) {
        throw new RuntimeException("not implemented");
    }

    private void _finishJIT() {
        if (!this.deferFinish) {
            if (this.returnType != null && this.returnType.isPrimitive()) {
                this.wrapPrimitive(this.returnType);
            }
            if (this.returnType == Void.TYPE) {
                this.debug("ACONST_NULL");
                this.mv.visitInsn(1);
            }
            this.debug("ARETURN");
            this.mv.visitInsn(176);
        }
        this.debug(new StringBuffer("\n{METHOD STATS (maxstack=").append(this.stacksize).append(")}\n").toString());
        this.mv.visitMaxs(this.stacksize, 1);
        this.mv.visitEnd();
        this.buildInputs();
        this.cw.visitEnd();
        this.dumpAdvancedDebugging();
    }

    private Accessor _initializeAccessor() throws Exception {
        Object o;
        block7: {
            Class cls = this.loadClass(this.className, this.cw.toByteArray());
            this.debug(new StringBuffer("[MVEL JIT Completed Optimization <<").append(new String(this.expr)).append(">>]::").append(cls).append(" (time: ").append(System.currentTimeMillis() - this.time).append("ms)").toString());
            try {
                if (this.compiledInputs.size() == 0) {
                    o = cls.newInstance();
                    break block7;
                }
                Class[] parms = new Class[this.compiledInputs.size()];
                int i = 0;
                while (i < this.compiledInputs.size()) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.mvel.ExecutableStatement");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    parms[i] = clazz;
                    ++i;
                }
                o = cls.getConstructor(parms).newInstance(this.compiledInputs.toArray(new ExecutableStatement[this.compiledInputs.size()]));
            }
            catch (VerifyError e) {
                System.out.println("**** COMPILER BUG! REPORT THIS IMMEDIATELY AT http://jira.codehaus.org/browse/mvel");
                System.out.println(new StringBuffer("Expression: ").append(new String(this.expr)).toString());
                throw e;
            }
        }
        if (!(o instanceof Accessor)) {
            this.dumpAdvancedDebugging();
            throw new RuntimeException("Classloader problem detected. JIT Class is not subclass of org.mvel.Accessor.");
        }
        return (Accessor)o;
    }

    private Accessor compileAccessor() {
        this.debug("<<INITIATE COMPILE>>");
        Object curr = this.ctx;
        try {
            while (this.cursor < this.length) {
                switch (this.nextSubToken()) {
                    case 0: {
                        curr = this.getBeanProperty(curr, this.capture());
                        break;
                    }
                    case 1: {
                        curr = this.getMethod(curr, this.capture());
                        break;
                    }
                    case 2: {
                        curr = this.getCollectionProperty(curr, this.capture());
                    }
                }
                this.first = false;
            }
            this.val = curr;
            this._finishJIT();
            return this._initializeAccessor();
        }
        catch (InvocationTargetException e) {
            throw new PropertyAccessException(new String(this.expr), e);
        }
        catch (IllegalAccessException e) {
            throw new PropertyAccessException(new String(this.expr), e);
        }
        catch (IndexOutOfBoundsException e) {
            throw new PropertyAccessException(new String(this.expr), e);
        }
        catch (PropertyAccessException e) {
            throw new CompileException(e.getMessage(), e);
        }
        catch (CompileException e) {
            throw e;
        }
        catch (NullPointerException e) {
            throw new PropertyAccessException(new String(this.expr), e);
        }
        catch (OptimizationNotSupported e) {
            throw e;
        }
        catch (Exception e) {
            throw new CompileException(e.getMessage(), e);
        }
    }

    private Object getBeanProperty(Object ctx, String property) throws IllegalAccessException, InvocationTargetException {
        Member member;
        this.debug(new StringBuffer("\n  **  ENTER -> {bean: ").append(property).append("; ctx=").append(ctx).append("}").toString());
        if (this.returnType != null && this.returnType.isPrimitive()) {
            this.wrapPrimitive(this.returnType);
        }
        Class<?> cls = ctx instanceof Class ? (Class<?>)ctx : (ctx != null ? ctx.getClass() : null);
        Member member2 = member = cls != null ? PropertyTools.getFieldOrAccessor(cls, property) : null;
        if (this.first) {
            if (this.variableFactory != null && this.variableFactory.isResolveable(property)) {
                try {
                    Class<?> clazz;
                    this.debug("ALOAD 3");
                    this.mv.visitVarInsn(25, 3);
                    this.debug(new StringBuffer("LDC :").append(property).toString());
                    this.mv.visitLdcInsn(property);
                    this.debug("INVOKEINTERFACE org/mvel/integration/VariableResolverFactory.getVariableResolver");
                    this.mv.visitMethodInsn(185, "org/mvel/integration/VariableResolverFactory", "getVariableResolver", "(Ljava/lang/String;)Lorg/mvel/integration/VariableResolver;");
                    this.debug("INVOKEINTERFACE org/mvel/integration/VariableResolver.getValue");
                    this.mv.visitMethodInsn(185, "org/mvel/integration/VariableResolver", "getValue", "()Ljava/lang/Object;");
                    try {
                        clazz = Class.forName("java.lang.Object");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    this.returnType = clazz;
                }
                catch (Exception e) {
                    throw new OptimizationFailure("critical error in JIT", e);
                }
                return this.variableFactory.getVariableResolver(property).getValue();
            }
            this.mv.visitVarInsn(25, 1);
        }
        if (member instanceof Field) {
            Object o = ((Field)member).get(ctx);
            if (this.first) {
                this.debug("ALOAD 1 (A)");
                this.mv.visitVarInsn(25, 1);
            }
            if ((member.getModifiers() & 8) != 0) {
                this.debug(new StringBuffer("GETSTATIC ").append(Type.getDescriptor(member.getDeclaringClass())).append(".").append(member.getName()).append("::").append(Type.getDescriptor(((Field)member).getType())).toString());
                this.returnType = ((Field)member).getType();
                this.mv.visitFieldInsn(178, Type.getInternalName(member.getDeclaringClass()), member.getName(), Type.getDescriptor(this.returnType));
            } else {
                this.debug(new StringBuffer("CHECKCAST ").append(Type.getInternalName(cls)).toString());
                this.mv.visitTypeInsn(192, Type.getInternalName(cls));
                this.debug(new StringBuffer("GETFIELD ").append(property).append(":").append(Type.getDescriptor(((Field)member).getType())).toString());
                this.returnType = ((Field)member).getType();
                this.mv.visitFieldInsn(180, Type.getInternalName(cls), property, Type.getDescriptor(this.returnType));
            }
            this.returnType = ((Field)member).getType();
            return o;
        }
        if (member != null) {
            Object o;
            if (this.first) {
                this.debug("ALOAD 1 (B)");
                this.mv.visitVarInsn(25, 1);
            }
            try {
                o = ((Method)member).invoke(ctx, EMPTYARG);
                if (this.returnType != member.getDeclaringClass()) {
                    this.debug(new StringBuffer("CHECKCAST ").append(Type.getInternalName(member.getDeclaringClass())).toString());
                    this.mv.visitTypeInsn(192, Type.getInternalName(member.getDeclaringClass()));
                }
                this.returnType = ((Method)member).getReturnType();
                this.debug(new StringBuffer("INVOKEVIRTUAL ").append(member.getName()).append(":").append(this.returnType).toString());
                this.mv.visitMethodInsn(182, Type.getInternalName(member.getDeclaringClass()), member.getName(), Type.getMethodDescriptor((Method)member));
            }
            catch (IllegalAccessException e) {
                Method iFaceMeth = ParseTools.determineActualTargetMethod((Method)member);
                this.debug(new StringBuffer("CHECKCAST ").append(Type.getInternalName(iFaceMeth.getDeclaringClass())).toString());
                this.mv.visitTypeInsn(192, Type.getInternalName(iFaceMeth.getDeclaringClass()));
                this.returnType = iFaceMeth.getReturnType();
                this.debug(new StringBuffer("INVOKEINTERFACE ").append(member.getName()).append(":").append(this.returnType).toString());
                this.mv.visitMethodInsn(185, Type.getInternalName(iFaceMeth.getDeclaringClass()), member.getName(), Type.getMethodDescriptor((Method)member));
                o = iFaceMeth.invoke(ctx, EMPTYARG);
            }
            return o;
        }
        if (ctx instanceof Map && ((Map)ctx).containsKey(property)) {
            this.debug("CHECKCAST java/util/Map");
            this.mv.visitTypeInsn(192, "java/util/Map");
            this.debug(new StringBuffer("LDC: \"").append(property).append("\"").toString());
            this.mv.visitLdcInsn(property);
            this.debug("INVOKEINTERFACE: get");
            this.mv.visitMethodInsn(185, "java/util/Map", "get", "(Ljava/lang/Object;)Ljava/lang/Object;");
            return ((Map)ctx).get(property);
        }
        if ("this".equals(property)) {
            this.debug("ALOAD 2");
            this.mv.visitVarInsn(25, 2);
            return this.thisRef;
        }
        if (LITERALS.containsKey(property)) {
            Object lit = LITERALS.get(property);
            if (lit instanceof Class) {
                this.ldcClassConstant((Class)lit);
            }
            return LITERALS.get(property);
        }
        Object ts = this.tryStaticAccess();
        if (ts != null) {
            if (ts instanceof Class) {
                this.ldcClassConstant((Class)ts);
                return ts;
            }
            this.debug(new StringBuffer("GETSTATIC ").append(Type.getDescriptor(((Field)ts).getDeclaringClass())).append(".").append(((Field)ts).getName()).append("::").append(Type.getDescriptor(((Field)ts).getType())).toString());
            this.returnType = ((Field)ts).getType();
            this.mv.visitFieldInsn(178, Type.getDescriptor(((Field)ts).getDeclaringClass()), ((Field)ts).getName(), Type.getDescriptor(this.returnType));
            return ((Field)ts).get(null);
        }
        if (ctx instanceof Class) {
            Class c = (Class)ctx;
            Method[] methodArray = c.getMethods();
            int n = methodArray.length;
            int n2 = 0;
            while (n2 < n) {
                Method m = methodArray[n2];
                if (property.equals(m.getName())) {
                    this.ldcClassConstant(c);
                    this.mv.visitMethodInsn(182, "java/lang/Class", "getMethods", "()[Ljava/lang/reflect/Method;");
                    this.mv.visitVarInsn(58, 7);
                    this.mv.visitInsn(3);
                    this.mv.visitVarInsn(54, 5);
                    this.mv.visitVarInsn(25, 7);
                    this.mv.visitInsn(190);
                    this.mv.visitVarInsn(54, 6);
                    Label l1 = new Label();
                    this.mv.visitJumpInsn(167, l1);
                    Label l2 = new Label();
                    this.mv.visitLabel(l2);
                    this.mv.visitVarInsn(25, 7);
                    this.mv.visitVarInsn(21, 5);
                    this.mv.visitInsn(50);
                    this.mv.visitVarInsn(58, 4);
                    Label l3 = new Label();
                    this.mv.visitLabel(l3);
                    this.mv.visitLdcInsn(m.getName());
                    this.mv.visitVarInsn(25, 4);
                    this.mv.visitMethodInsn(182, "java/lang/reflect/Method", "getName", "()Ljava/lang/String;");
                    this.mv.visitMethodInsn(182, "java/lang/String", "equals", "(Ljava/lang/Object;)Z");
                    Label l4 = new Label();
                    this.mv.visitJumpInsn(153, l4);
                    Label l5 = new Label();
                    this.mv.visitLabel(l5);
                    this.mv.visitVarInsn(25, 4);
                    this.mv.visitInsn(176);
                    this.mv.visitLabel(l4);
                    this.mv.visitIincInsn(5, 1);
                    this.mv.visitLabel(l1);
                    this.mv.visitVarInsn(21, 5);
                    this.mv.visitVarInsn(21, 6);
                    this.mv.visitJumpInsn(161, l2);
                    Label l6 = new Label();
                    this.mv.visitLabel(l6);
                    this.mv.visitInsn(1);
                    this.mv.visitInsn(176);
                    this.deferFinish = true;
                    return m;
                }
                ++n2;
            }
        }
        throw new PropertyAccessException(property);
    }

    private Object getCollectionProperty(Object ctx, String prop) throws IllegalAccessException, InvocationTargetException {
        Object item;
        if (prop.length() > 0) {
            ctx = this.getBeanProperty(ctx, prop);
        }
        this.debug(new StringBuffer("\n  **  ENTER -> {collections: ").append(prop).append("; ctx=").append(ctx).append("}").toString());
        int start = ++this.cursor;
        this.whiteSpaceSkip();
        if (this.cursor == this.length) {
            throw new CompileException("unterminated '['");
        }
        if (!this.scanTo(']')) {
            throw new CompileException("unterminated '['");
        }
        String tk = new String(this.expr, start, this.cursor - start);
        this.debug(new StringBuffer("{collection token:<<").append(tk).append(">>}").toString());
        boolean literal = false;
        ExecutableStatement compiled = (ExecutableStatement)ParseTools.subCompileExpression(tk);
        if (compiled instanceof ExecutableLiteral) {
            literal = true;
            item = ((ExecutableLiteral)compiled).getLiteral();
        } else {
            item = compiled.getValue(ctx, this.variableFactory);
            this.compiledInputs.add(compiled);
        }
        ++this.cursor;
        if (ctx instanceof Map) {
            this.debug("CHECKCAST java/util/Map");
            this.mv.visitTypeInsn(192, "java/util/Map");
            if (item instanceof Integer) {
                this.intPush((Integer)item);
                this.wrapPrimitive(Integer.TYPE);
                this.debug("INVOKEINTERFACE: get");
                this.mv.visitMethodInsn(185, "java/util/Map", "get", "(Ljava/lang/Object;)Ljava/lang/Object;");
                return ((Map)ctx).get(item);
            }
            if (!literal) {
                this.valueFromSubExpression();
            } else {
                this.writeOutLiteralWrapped(item);
            }
            this.debug("INVOKEINTERFACE: get");
            this.mv.visitMethodInsn(185, "java/util/Map", "get", "(Ljava/lang/Object;)Ljava/lang/Object;");
            return ((Map)ctx).get(item);
        }
        if (ctx instanceof List) {
            Class<?> clazz;
            Class<?> clazz2;
            this.debug("CHECKCAST java/util/List");
            this.mv.visitTypeInsn(192, "java/util/List");
            if (item instanceof Integer) {
                this.intPush((Integer)item);
                this.debug("INVOKEINTERFACE: java/util/List.get");
                this.mv.visitMethodInsn(185, "java/util/List", "get", "(I)Ljava/lang/Object;");
                return ((List)ctx).get((Integer)item);
            }
            if (!literal) {
                this.valueFromSubExpression();
            } else {
                this.writeOutLiteralWrapped(item);
            }
            this.debug("INVOKEINTERFACE: java/util/List.get");
            this.mv.visitMethodInsn(185, "java/util/List", "get", "(I)Ljava/lang/Object;");
            try {
                clazz2 = Class.forName("java.lang.Integer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            this.dataConversion(clazz2);
            this.unwrapPrimitive(Integer.TYPE);
            try {
                clazz = Class.forName("java.lang.Integer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            return ((List)ctx).get((Integer)DataConversion.convert(item, clazz));
        }
        if (ctx instanceof Object[]) {
            Class<?> clazz;
            Class<?> clazz3;
            this.debug("CHECKCAST [Ljava/lang/Object;");
            this.mv.visitTypeInsn(192, "[Ljava/lang/Object;");
            if (item instanceof Integer) {
                this.intPush((Integer)item);
                this.debug("AALOAD");
                this.mv.visitInsn(50);
                return ((Object[])ctx)[(Integer)item];
            }
            if (!literal) {
                this.valueFromSubExpression();
            } else {
                this.writeOutLiteralWrapped(item);
            }
            try {
                clazz3 = Class.forName("java.lang.Integer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            this.dataConversion(clazz3);
            this.unwrapPrimitive(Integer.TYPE);
            this.debug("AALOAD");
            this.mv.visitInsn(50);
            try {
                clazz = Class.forName("java.lang.Integer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            return ((Object[])ctx)[(Integer)DataConversion.convert(item, clazz)];
        }
        if (ctx instanceof CharSequence) {
            Class<?> clazz;
            Class<?> clazz4;
            this.debug("CHECKCAST java/lang/CharSequence");
            this.mv.visitTypeInsn(192, "java/lang/CharSequence");
            if (item instanceof Integer) {
                this.intPush((Integer)item);
                this.debug("INVOKEINTERFACE java/lang/CharSequence.charAt");
                this.mv.visitMethodInsn(185, "java/lang/CharSequence", "charAt", "(I)C");
                this.wrapPrimitive(Character.TYPE);
                return new Character(((CharSequence)ctx).charAt((Integer)item));
            }
            if (!literal) {
                this.valueFromSubExpression();
            } else {
                this.writeOutLiteralWrapped(item);
            }
            try {
                clazz4 = Class.forName("java.lang.Integer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            this.dataConversion(clazz4);
            this.unwrapPrimitive(Integer.TYPE);
            this.debug("INVOKEINTERFACE java/lang/CharSequence.charAt");
            this.mv.visitMethodInsn(185, "java/lang/CharSequence", "charAt", "(I)C");
            this.wrapPrimitive(Character.TYPE);
            try {
                clazz = Class.forName("java.lang.Integer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            return new Character(((CharSequence)ctx).charAt((Integer)DataConversion.convert(item, clazz)));
        }
        throw new CompileException(new StringBuffer("illegal use of []: unknown type: ").append(ctx == null ? null : ctx.getClass().getName()).toString());
    }

    /*
     * Unable to fully structure code
     */
    private Object getMethod(Object ctx, String name) throws IllegalAccessException, InvocationTargetException {
        block67: {
            block66: {
                this.debug(new StringBuffer("\n  **  {method: ").append(name).append("}").toString());
                if (this.first && this.variableFactory != null && this.variableFactory.isResolveable(name)) {
                    ptr = this.variableFactory.getVariableResolver(name).getValue();
                    if (ptr instanceof Method) {
                        ctx = ((Method)ptr).getDeclaringClass();
                        name = ((Method)ptr).getName();
                    } else if (ptr instanceof MethodStub) {
                        ctx = ((MethodStub)ptr).getClassReference();
                        name = ((MethodStub)ptr).getMethodName();
                    } else {
                        throw new OptimizationFailure(new StringBuffer("attempt to optimize a method call for a reference that does not point to a method: ").append(name).append(" (reference is type: ").append(ctx != null ? ctx.getClass().getName() : null).append(")").toString());
                    }
                    this.first = false;
                } else if (this.returnType != null && this.returnType.isPrimitive()) {
                    this.wrapPrimitive(this.returnType);
                }
                st = this.cursor;
                this.cursor = ParseTools.balancedCapture(this.expr, this.cursor, '(');
                tk = this.cursor - st > 1 ? new String(this.expr, st + 1, this.cursor - st - 1) : "";
                ++this.cursor;
                if (tk.length() == 0) {
                    args = new Object[]{};
                    preConvArgs = new Object[]{};
                    es = null;
                } else {
                    subtokens = ParseTools.parseParameterList(tk.toCharArray(), 0, -1);
                    es = new ExecutableStatement[subtokens.length];
                    args = new Object[subtokens.length];
                    preConvArgs = new Object[es.length];
                    i = 0;
                    while (i < subtokens.length) {
                        es[i] = (ExecutableStatement)ParseTools.subCompileExpression(subtokens[i]);
                        preConvArgs[i] = args[i] = es[i].getValue(this.ctx, this.thisRef, this.variableFactory);
                        ++i;
                    }
                }
                inputsOffset = this.compiledInputs.size();
                if (es != null) {
                    i = 0;
                    while (i < es.length) {
                        e = es[i];
                        if (!(e instanceof ExecutableLiteral)) {
                            if (e instanceof ExecutableAccessor && ((ExecutableAccessor)e).getNode() instanceof PropertyASTNode && ((PropertyASTNode)((ExecutableAccessor)e).getNode()).getWrappedNode() instanceof LiteralNode) {
                                es[i] = new ExecutableLiteral(((PropertyASTNode)((ExecutableAccessor)e).getNode()).getWrappedNode().getLiteralValue());
                            } else {
                                this.compiledInputs.add((ExecutableStatement)e);
                            }
                        }
                        ++i;
                    }
                }
                if (this.first) {
                    this.debug("ALOAD 1 (D) ");
                    this.mv.visitVarInsn(25, 1);
                }
                cls = ctx instanceof Class != false ? ctx : ctx.getClass();
                parameterTypes = null;
                m = ParseTools.getBestCandidate(args, name, cls.getMethods());
                if (m != null) {
                    parameterTypes = m.getParameterTypes();
                }
                if (m == null && (m = ParseTools.getBestCandidate(args, name, cls.getClass().getDeclaredMethods())) != null) {
                    parameterTypes = m.getParameterTypes();
                }
                if (m == null) {
                    errorBuild = new StringAppender();
                    if (parameterTypes != null) {
                        i = 0;
                        while (i < args.length) {
                            errorBuild.append(parameterTypes[i] != null ? parameterTypes[i].getClass().getName() : null);
                            if (i < args.length - 1) {
                                errorBuild.append(", ");
                            }
                            ++i;
                        }
                    }
                    if ("size".equals(name) && args.length == 0 && cls.isArray()) {
                        this.anyArrayCheck(cls);
                        this.debug("ARRAYLENGTH");
                        this.mv.visitInsn(190);
                        this.wrapPrimitive(Integer.TYPE);
                        return new Integer(Array.getLength(ctx));
                    }
                    throw new CompileException(new StringBuffer("unable to resolve method: ").append(cls.getName()).append(".").append(name).append("(").append(errorBuild.toString()).append(") [arglength=").append(args.length).append("]").toString());
                }
                m = ParseTools.getWidenedTarget(m);
                if (es != null) {
                    i = 0;
                    while (i < es.length) {
                        cExpr = (ExecutableStatement)es[i];
                        if (cExpr.getKnownIngressType() == null) {
                            cExpr.setKnownIngressType(parameterTypes[i]);
                            cExpr.computeTypeConversionRule();
                        }
                        if (!cExpr.isConvertableIngressEgress()) {
                            args[i] = DataConversion.convert(args[i], parameterTypes[i]);
                        }
                        ++i;
                    }
                } else {
                    i = 0;
                    while (i < args.length) {
                        args[i] = DataConversion.convert(args[i], parameterTypes[i]);
                        ++i;
                    }
                }
                if (m.getParameterTypes().length != 0) break block66;
                if ((m.getModifiers() & 8) != 0) {
                    this.debug(new StringBuffer("INVOKESTATIC ").append(m.getName()).toString());
                    this.mv.visitMethodInsn(184, Type.getInternalName(m.getDeclaringClass()), m.getName(), Type.getMethodDescriptor(m));
                } else {
                    this.debug(new StringBuffer("CHECKCAST ").append(Type.getInternalName(m.getDeclaringClass())).toString());
                    this.mv.visitTypeInsn(192, Type.getInternalName(m.getDeclaringClass()));
                    if (m.getDeclaringClass().isInterface()) {
                        this.debug(new StringBuffer("INVOKEINTERFACE ").append(m.getName()).toString());
                        this.mv.visitMethodInsn(185, Type.getInternalName(m.getDeclaringClass()), m.getName(), Type.getMethodDescriptor(m));
                    } else {
                        this.debug(new StringBuffer("INVOKEVIRTUAL ").append(m.getName()).toString());
                        this.mv.visitMethodInsn(182, Type.getInternalName(m.getDeclaringClass()), m.getName(), Type.getMethodDescriptor(m));
                    }
                }
                this.returnType = m.getReturnType();
                ++this.stacksize;
                break block67;
            }
            if ((m.getModifiers() & 8) == 0) {
                this.debug(new StringBuffer("CHECKCAST ").append(Type.getInternalName(cls)).toString());
                this.mv.visitTypeInsn(192, Type.getInternalName(cls));
            }
            i = 0;
            while (i < es.length) {
                block70: {
                    block75: {
                        block68: {
                            block74: {
                                block73: {
                                    block72: {
                                        block71: {
                                            block69: {
                                                if (!(es[i] instanceof ExecutableLiteral)) break block68;
                                                literal = (ExecutableLiteral)es[i];
                                                if (literal.getLiteral() != null) break block69;
                                                this.debug("ICONST_NULL");
                                                this.mv.visitInsn(1);
                                                break block70;
                                            }
                                            if (parameterTypes[i] != Integer.TYPE || !literal.intOptimized()) break block71;
                                            this.intPush(literal.getInteger32());
                                            break block70;
                                        }
                                        if (parameterTypes[i] != Integer.TYPE || !(preConvArgs[i] instanceof Integer)) break block72;
                                        this.intPush((Integer)preConvArgs[i]);
                                        break block70;
                                    }
                                    if (parameterTypes[i] != Boolean.TYPE) break block73;
                                    try {
                                        v0 = Class.forName("java.lang.Boolean");
                                    }
                                    catch (ClassNotFoundException v1) {
                                        throw new NoClassDefFoundError(v1.getMessage());
                                    }
                                    bool = (Boolean)DataConversion.convert(literal.getLiteral(), v0);
                                    this.debug(bool != false ? "ICONST_1" : "ICONST_0");
                                    this.mv.visitInsn(bool != false ? 4 : 3);
                                    break block70;
                                }
                                lit = literal.getLiteral();
                                try {
                                    v2 = Class.forName("java.lang.Object");
                                }
                                catch (ClassNotFoundException v3) {
                                    throw new NoClassDefFoundError(v3.getMessage());
                                }
                                if (parameterTypes[i] != v2) break block74;
                                if (ParseTools.isPrimitiveWrapper(lit.getClass())) {
                                    try {
                                        v4 = Class.forName("java.lang.Integer");
                                    }
                                    catch (ClassNotFoundException v5) {
                                        throw new NoClassDefFoundError(v5.getMessage());
                                    }
                                    if (lit.getClass() == v4) {
                                        this.intPush((Integer)lit);
                                    } else {
                                        this.debug(new StringBuffer("LDC ").append(lit).toString());
                                        this.mv.visitLdcInsn(lit);
                                    }
                                    this.wrapPrimitive(lit.getClass());
                                } else if (lit instanceof String) {
                                    this.mv.visitLdcInsn(lit);
                                    try {
                                        v6 = Class.forName("java.lang.Object");
                                    }
                                    catch (ClassNotFoundException v7) {
                                        throw new NoClassDefFoundError(v7.getMessage());
                                    }
                                    this.checkcast(v6);
                                }
                                break block70;
                            }
                            if (!DataConversion.canConvert(parameterTypes[i], lit.getClass())) break block68;
                            this.debug(new StringBuffer("LDC ").append(lit).append(" (").append(lit.getClass().getName()).append(")").toString());
                            this.mv.visitLdcInsn(DataConversion.convert(lit, parameterTypes[i]));
                            break block70;
                        }
                        this.debug("ALOAD 0");
                        this.mv.visitVarInsn(25, 0);
                        this.debug(new StringBuffer("GETFIELD p").append(inputsOffset).toString());
                        this.mv.visitFieldInsn(180, this.className, new StringBuffer("p").append(inputsOffset).toString(), "Lorg/mvel/ExecutableStatement;");
                        ++inputsOffset;
                        this.debug("ALOAD 2");
                        this.mv.visitVarInsn(25, 2);
                        this.debug("ALOAD 3");
                        this.mv.visitVarInsn(25, 3);
                        this.debug("INVOKEINTERFACE ExecutableStatement.getValue");
                        try {
                            v8 = Class.forName("org.mvel.ExecutableStatement");
                        }
                        catch (ClassNotFoundException v9) {
                            throw new NoClassDefFoundError(v9.getMessage());
                        }
                        this.mv.visitMethodInsn(185, Type.getInternalName(v8), "getValue", "(Ljava/lang/Object;Lorg/mvel/integration/VariableResolverFactory;)Ljava/lang/Object;");
                        if (!parameterTypes[i].isPrimitive()) break block75;
                        if (preConvArgs[i] == null) ** GOTO lbl-1000
                        try {
                            v10 = Class.forName("java.lang.String");
                        }
                        catch (ClassNotFoundException v11) {
                            throw new NoClassDefFoundError(v11.getMessage());
                        }
                        if (parameterTypes[i] != v10 && !parameterTypes[i].isAssignableFrom(preConvArgs[i].getClass())) lbl-1000:
                        // 2 sources

                        {
                            this.ldcClassConstant(this.getWrapperClass(parameterTypes[i]));
                            this.debug("INVOKESTATIC DataConversion.convert");
                            this.mv.visitMethodInsn(184, "org/mvel/DataConversion", "convert", "(Ljava/lang/Object;Ljava/lang/Class;)Ljava/lang/Object;");
                            this.unwrapPrimitive(parameterTypes[i]);
                        } else {
                            this.unwrapPrimitive(parameterTypes[i]);
                        }
                        break block70;
                    }
                    if (preConvArgs[i] == null) ** GOTO lbl-1000
                    try {
                        v12 = Class.forName("java.lang.String");
                    }
                    catch (ClassNotFoundException v13) {
                        throw new NoClassDefFoundError(v13.getMessage());
                    }
                    if (parameterTypes[i] != v12 && !parameterTypes[i].isAssignableFrom(preConvArgs[i].getClass())) lbl-1000:
                    // 2 sources

                    {
                        this.ldcClassConstant(parameterTypes[i]);
                        this.debug("INVOKESTATIC DataConversion.convert");
                        this.mv.visitMethodInsn(184, "org/mvel/DataConversion", "convert", "(Ljava/lang/Object;Ljava/lang/Class;)Ljava/lang/Object;");
                        this.debug(new StringBuffer("CHECKCAST ").append(Type.getInternalName(parameterTypes[i])).toString());
                        this.mv.visitTypeInsn(192, Type.getInternalName(parameterTypes[i]));
                    } else {
                        try {
                            v14 = Class.forName("java.lang.String");
                        }
                        catch (ClassNotFoundException v15) {
                            throw new NoClassDefFoundError(v15.getMessage());
                        }
                        if (parameterTypes[i] == v14) {
                            this.debug("<<<DYNAMIC TYPE OPTIMIZATION STRING>>");
                            this.mv.visitMethodInsn(184, "java/lang/String", "valueOf", "(Ljava/lang/Object;)Ljava/lang/String;");
                        } else {
                            this.debug("<<<DYNAMIC TYPING BYPASS>>>");
                            this.debug(new StringBuffer("<<<OPT. JUSTIFICATION ").append(parameterTypes[i]).append("=").append(preConvArgs[i].getClass()).append(">>>").toString());
                            this.debug(new StringBuffer("CHECKCAST ").append(Type.getInternalName(parameterTypes[i])).toString());
                            this.mv.visitTypeInsn(192, Type.getInternalName(parameterTypes[i]));
                        }
                    }
                }
                ++i;
            }
            if ((m.getModifiers() & 8) != 0) {
                this.debug(new StringBuffer("INVOKESTATIC: ").append(m.getName()).toString());
                this.mv.visitMethodInsn(184, Type.getInternalName(m.getDeclaringClass()), m.getName(), Type.getMethodDescriptor(m));
            } else if (m.getDeclaringClass() != cls && m.getDeclaringClass().isInterface()) {
                this.debug(new StringBuffer("INVOKEINTERFACE: ").append(Type.getInternalName(m.getDeclaringClass())).append(".").append(m.getName()).toString());
                this.mv.visitMethodInsn(185, Type.getInternalName(m.getDeclaringClass()), m.getName(), Type.getMethodDescriptor(m));
            } else {
                this.debug(new StringBuffer("INVOKEVIRTUAL: ").append(Type.getInternalName(cls)).append(".").append(m.getName()).toString());
                this.mv.visitMethodInsn(182, Type.getInternalName(cls), m.getName(), Type.getMethodDescriptor(m));
            }
            this.returnType = m.getReturnType();
            ++this.stacksize;
        }
        return m.invoke(ctx, args);
    }

    private void valueFromSubExpression() {
        this.debug("ALOAD 0");
        this.mv.visitVarInsn(25, 0);
        this.debug(new StringBuffer("GETFIELD p").append(this.compiledInputs.size() - 1).toString());
        this.mv.visitFieldInsn(180, this.className, new StringBuffer("p").append(this.compiledInputs.size() - 1).toString(), "Lorg/mvel/ExecutableStatement;");
        this.debug("ALOAD 1");
        this.mv.visitVarInsn(25, 1);
        this.debug("ALOAD 3");
        this.mv.visitVarInsn(25, 3);
        this.debug("INVOKEINTERFACE org/mvel/ExecutableStatement.getValue");
        this.mv.visitMethodInsn(185, "org/mvel/ExecutableStatement", "getValue", "(Ljava/lang/Object;Lorg/mvel/integration/VariableResolverFactory;)Ljava/lang/Object;");
    }

    private void dataConversion(Class target) {
        this.ldcClassConstant(target);
        this.debug("INVOKESTATIC org/mvel/DataConversion.convert");
        this.mv.visitMethodInsn(184, "org/mvel/DataConversion", "convert", "(Ljava/lang/Object;Ljava/lang/Class;)Ljava/lang/Object;");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Class loadClass(String className, byte[] b) throws Exception {
        Method method = defineClass;
        synchronized (method) {
            defineClass.setAccessible(true);
            try {
                Class clazz = (Class)defineClass.invoke((Object)classLoader, className, b, new Integer(0), new Integer(b.length));
                return clazz;
            }
            catch (Exception t) {
                this.dumpAdvancedDebugging();
                throw t;
            }
            finally {
                defineClass.setAccessible(false);
            }
        }
    }

    private void debug(String instruction) {
        if (this.buildLog != null) {
            this.buildLog.append(instruction).append("\n");
        }
    }

    public String getName() {
        return "ASM";
    }

    @Override
    public Object getResultOptPass() {
        return this.val;
    }

    private Class getWrapperClass(Class cls) {
        if (cls == Boolean.TYPE) {
            Class<?> clazz;
            try {
                clazz = Class.forName("java.lang.Boolean");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            return clazz;
        }
        if (cls == Integer.TYPE) {
            Class<?> clazz;
            try {
                clazz = Class.forName("java.lang.Integer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            return clazz;
        }
        if (cls == Float.TYPE) {
            Class<?> clazz;
            try {
                clazz = Class.forName("java.lang.Float");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            return clazz;
        }
        if (cls == Double.TYPE) {
            Class<?> clazz;
            try {
                clazz = Class.forName("java.lang.Double");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            return clazz;
        }
        if (cls == Short.TYPE) {
            Class<?> clazz;
            try {
                clazz = Class.forName("java.lang.Short");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            return clazz;
        }
        if (cls == Long.TYPE) {
            Class<?> clazz;
            try {
                clazz = Class.forName("java.lang.Long");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            return clazz;
        }
        if (cls == Byte.TYPE) {
            Class<?> clazz;
            try {
                clazz = Class.forName("java.lang.Byte");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            return clazz;
        }
        if (cls == Character.TYPE) {
            Class<?> clazz;
            try {
                clazz = Class.forName("java.lang.Character");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            return clazz;
        }
        return null;
    }

    private void unwrapPrimitive(Class cls) {
        if (cls == Boolean.TYPE) {
            this.debug("CHECKCAST java/lang/Boolean");
            this.mv.visitTypeInsn(192, "java/lang/Boolean");
            this.debug("INVOKEVIRTUAL java/lang/Boolean.booleanValue");
            this.mv.visitMethodInsn(182, "java/lang/Boolean", "booleanValue", "()Z");
        } else if (cls == Integer.TYPE) {
            this.debug("CHECKCAST java/lang/Integer");
            this.mv.visitTypeInsn(192, "java/lang/Integer");
            this.debug("INVOKEVIRTUAL java/lang/Integer.intValue");
            this.mv.visitMethodInsn(182, "java/lang/Integer", "intValue", "()I");
        } else if (cls == Float.TYPE) {
            this.debug("CHECKCAST java/lang/Float");
            this.mv.visitTypeInsn(192, "java/lang/Float");
            this.debug("INVOKEVIRTUAL java/lang/Float.floatValue");
            this.mv.visitMethodInsn(182, "java/lang/Float", "floatValue", "()F");
        } else if (cls == Double.TYPE) {
            this.debug("CHECKCAST java/lang/Double");
            this.mv.visitTypeInsn(192, "java/lang/Double");
            this.debug("INVOKEVIRTUAL java/lang/Double.doubleValue");
            this.mv.visitMethodInsn(182, "java/lang/Double", "doubleValue", "()D");
        } else if (cls == Short.TYPE) {
            this.debug("CHECKCAST java/lang/Short");
            this.mv.visitTypeInsn(192, "java/lang/Short");
            this.debug("INVOKEVIRTUAL java/lang/Short.shortValue");
            this.mv.visitMethodInsn(182, "java/lang/Short", "shortValue", "()S");
        } else if (cls == Long.TYPE) {
            this.debug("CHECKCAST java/lang/Long");
            this.mv.visitTypeInsn(192, "java/lang/Long");
            this.debug("INVOKEVIRTUAL java/lang/Long.longValue");
            this.mv.visitMethodInsn(182, "java/lang/Long", "longValue", "()J");
        } else if (cls == Byte.TYPE) {
            this.debug("CHECKCAST java/lang/Byte");
            this.mv.visitTypeInsn(192, "java/lang/Byte");
            this.debug("INVOKEVIRTUAL java/lang/Byte.byteValue");
            this.mv.visitMethodInsn(182, "java/lang/Byte", "byteValue", "()B");
        } else if (cls == Character.TYPE) {
            this.debug("CHECKCAST java/lang/Character");
            this.mv.visitTypeInsn(192, "java/lang/Character");
            this.debug("INVOKEVIRTUAL java/lang/Character.charValue");
            this.mv.visitMethodInsn(182, "java/lang/Character", "charValue", "()C");
        }
    }

    private void wrapPrimitive(Class<? extends Object> cls) {
        block70: {
            Class<?> clazz;
            block98: {
                Class<?> clazz2;
                block97: {
                    Class<?> clazz3;
                    block96: {
                        Class<?> clazz4;
                        block95: {
                            Class<?> clazz5;
                            block94: {
                                Class<?> clazz6;
                                block93: {
                                    Class<?> clazz7;
                                    block92: {
                                        Class<?> clazz8;
                                        block91: {
                                            Class<?> clazz9;
                                            block90: {
                                                Class<?> clazz10;
                                                block89: {
                                                    Class<?> clazz11;
                                                    block88: {
                                                        Class<?> clazz12;
                                                        block87: {
                                                            Class<?> clazz13;
                                                            block86: {
                                                                Class<?> clazz14;
                                                                block85: {
                                                                    Class<?> clazz15;
                                                                    block84: {
                                                                        Class<?> clazz16;
                                                                        block67: {
                                                                            Class<?> clazz17;
                                                                            block83: {
                                                                                Class<?> clazz18;
                                                                                block82: {
                                                                                    Class<?> clazz19;
                                                                                    block81: {
                                                                                        Class<?> clazz20;
                                                                                        block80: {
                                                                                            Class<?> clazz21;
                                                                                            block79: {
                                                                                                Class<?> clazz22;
                                                                                                block78: {
                                                                                                    Class<?> clazz23;
                                                                                                    block77: {
                                                                                                        Class<?> clazz24;
                                                                                                        block76: {
                                                                                                            Class<?> clazz25;
                                                                                                            block75: {
                                                                                                                Class<?> clazz26;
                                                                                                                block74: {
                                                                                                                    Class<?> clazz27;
                                                                                                                    block73: {
                                                                                                                        Class<?> clazz28;
                                                                                                                        block72: {
                                                                                                                            Class<?> clazz29;
                                                                                                                            block71: {
                                                                                                                                Class<?> clazz30;
                                                                                                                                block69: {
                                                                                                                                    Class<?> clazz31;
                                                                                                                                    block68: {
                                                                                                                                        Class<?> clazz32;
                                                                                                                                        if (OPCODES_VERSION != 48) break block67;
                                                                                                                                        if (cls == Boolean.TYPE) break block68;
                                                                                                                                        try {
                                                                                                                                            clazz32 = Class.forName("java.lang.Boolean");
                                                                                                                                        }
                                                                                                                                        catch (ClassNotFoundException classNotFoundException) {
                                                                                                                                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                                                                                                                        }
                                                                                                                                        if (cls != clazz32) break block69;
                                                                                                                                    }
                                                                                                                                    this.debug("NEW java/lang/Boolean");
                                                                                                                                    this.mv.visitTypeInsn(187, "java/lang/Boolean");
                                                                                                                                    this.debug("DUP X1");
                                                                                                                                    this.mv.visitInsn(90);
                                                                                                                                    this.debug("SWAP");
                                                                                                                                    this.mv.visitInsn(95);
                                                                                                                                    this.debug("INVOKESPECIAL java/lang/Boolan.<init>::(Z)V");
                                                                                                                                    this.mv.visitMethodInsn(183, "java/lang/Boolean", "<init>", "(Z)V");
                                                                                                                                    try {
                                                                                                                                        clazz31 = Class.forName("java.lang.Boolean");
                                                                                                                                    }
                                                                                                                                    catch (ClassNotFoundException classNotFoundException) {
                                                                                                                                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                                                                                                                    }
                                                                                                                                    this.returnType = clazz31;
                                                                                                                                    break block70;
                                                                                                                                }
                                                                                                                                if (cls == Integer.TYPE) break block71;
                                                                                                                                try {
                                                                                                                                    clazz30 = Class.forName("java.lang.Integer");
                                                                                                                                }
                                                                                                                                catch (ClassNotFoundException classNotFoundException) {
                                                                                                                                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                                                                                                                }
                                                                                                                                if (cls != clazz30) break block72;
                                                                                                                            }
                                                                                                                            this.debug("NEW java/lang/Integer");
                                                                                                                            this.mv.visitTypeInsn(187, "java/lang/Integer");
                                                                                                                            this.debug("DUP X1");
                                                                                                                            this.mv.visitInsn(90);
                                                                                                                            this.debug("SWAP");
                                                                                                                            this.mv.visitInsn(95);
                                                                                                                            this.debug("INVOKESPECIAL java/lang/Integer.<init>::(I)V");
                                                                                                                            this.mv.visitMethodInsn(183, "java/lang/Integer", "<init>", "(I)V");
                                                                                                                            try {
                                                                                                                                clazz29 = Class.forName("java.lang.Integer");
                                                                                                                            }
                                                                                                                            catch (ClassNotFoundException classNotFoundException) {
                                                                                                                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                                                                                                            }
                                                                                                                            this.returnType = clazz29;
                                                                                                                            break block70;
                                                                                                                        }
                                                                                                                        if (cls == Float.TYPE) break block73;
                                                                                                                        try {
                                                                                                                            clazz28 = Class.forName("java.lang.Float");
                                                                                                                        }
                                                                                                                        catch (ClassNotFoundException classNotFoundException) {
                                                                                                                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                                                                                                        }
                                                                                                                        if (cls != clazz28) break block74;
                                                                                                                    }
                                                                                                                    this.debug("NEW java/lang/Float");
                                                                                                                    this.mv.visitTypeInsn(187, "java/lang/Float");
                                                                                                                    this.debug("DUP X1");
                                                                                                                    this.mv.visitInsn(90);
                                                                                                                    this.debug("SWAP");
                                                                                                                    this.mv.visitInsn(95);
                                                                                                                    this.debug("INVOKESPECIAL java/lang/Float.<init>::(F)V");
                                                                                                                    this.mv.visitMethodInsn(183, "java/lang/Float", "<init>", "(F)V");
                                                                                                                    try {
                                                                                                                        clazz27 = Class.forName("java.lang.Float");
                                                                                                                    }
                                                                                                                    catch (ClassNotFoundException classNotFoundException) {
                                                                                                                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                                                                                                    }
                                                                                                                    this.returnType = clazz27;
                                                                                                                    break block70;
                                                                                                                }
                                                                                                                if (cls == Double.TYPE) break block75;
                                                                                                                try {
                                                                                                                    clazz26 = Class.forName("java.lang.Double");
                                                                                                                }
                                                                                                                catch (ClassNotFoundException classNotFoundException) {
                                                                                                                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                                                                                                }
                                                                                                                if (cls != clazz26) break block76;
                                                                                                            }
                                                                                                            this.debug("NEW java/lang/Double");
                                                                                                            this.mv.visitTypeInsn(187, "java/lang/Double");
                                                                                                            this.debug("DUP X1");
                                                                                                            this.mv.visitInsn(90);
                                                                                                            this.debug("SWAP");
                                                                                                            this.mv.visitInsn(95);
                                                                                                            this.debug("INVOKESPECIAL java/lang/Double.<init>::(D)V");
                                                                                                            this.mv.visitMethodInsn(183, "java/lang/Doble", "<init>", "(D)V");
                                                                                                            try {
                                                                                                                clazz25 = Class.forName("java.lang.Double");
                                                                                                            }
                                                                                                            catch (ClassNotFoundException classNotFoundException) {
                                                                                                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                                                                                            }
                                                                                                            this.returnType = clazz25;
                                                                                                            break block70;
                                                                                                        }
                                                                                                        if (cls == Short.TYPE) break block77;
                                                                                                        try {
                                                                                                            clazz24 = Class.forName("java.lang.Short");
                                                                                                        }
                                                                                                        catch (ClassNotFoundException classNotFoundException) {
                                                                                                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                                                                                        }
                                                                                                        if (cls != clazz24) break block78;
                                                                                                    }
                                                                                                    this.debug("NEW java/lang/Short");
                                                                                                    this.mv.visitTypeInsn(187, "java/lang/Short");
                                                                                                    this.debug("DUP X1");
                                                                                                    this.mv.visitInsn(90);
                                                                                                    this.debug("SWAP");
                                                                                                    this.mv.visitInsn(95);
                                                                                                    this.debug("INVOKESPECIAL java/lang/Short.<init>::(S)V");
                                                                                                    this.mv.visitMethodInsn(183, "java/lang/Short", "<init>", "(S)V");
                                                                                                    try {
                                                                                                        clazz23 = Class.forName("java.lang.Short");
                                                                                                    }
                                                                                                    catch (ClassNotFoundException classNotFoundException) {
                                                                                                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                                                                                    }
                                                                                                    this.returnType = clazz23;
                                                                                                    break block70;
                                                                                                }
                                                                                                if (cls == Long.TYPE) break block79;
                                                                                                try {
                                                                                                    clazz22 = Class.forName("java.lang.Long");
                                                                                                }
                                                                                                catch (ClassNotFoundException classNotFoundException) {
                                                                                                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                                                                                }
                                                                                                if (cls != clazz22) break block80;
                                                                                            }
                                                                                            this.debug("NEW java/lang/Long");
                                                                                            this.mv.visitTypeInsn(187, "java/lang/Long");
                                                                                            this.debug("DUP X1");
                                                                                            this.mv.visitInsn(90);
                                                                                            this.debug("SWAP");
                                                                                            this.mv.visitInsn(95);
                                                                                            this.debug("INVOKESPECIAL java/lang/Long.<init>::(L)V");
                                                                                            this.mv.visitMethodInsn(183, "java/lang/Float", "<init>", "(L)V");
                                                                                            try {
                                                                                                clazz21 = Class.forName("java.lang.Long");
                                                                                            }
                                                                                            catch (ClassNotFoundException classNotFoundException) {
                                                                                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                                                                            }
                                                                                            this.returnType = clazz21;
                                                                                            break block70;
                                                                                        }
                                                                                        if (cls == Byte.TYPE) break block81;
                                                                                        try {
                                                                                            clazz20 = Class.forName("java.lang.Byte");
                                                                                        }
                                                                                        catch (ClassNotFoundException classNotFoundException) {
                                                                                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                                                                        }
                                                                                        if (cls != clazz20) break block82;
                                                                                    }
                                                                                    this.debug("NEW java/lang/Byte");
                                                                                    this.mv.visitTypeInsn(187, "java/lang/Byte");
                                                                                    this.debug("DUP X1");
                                                                                    this.mv.visitInsn(90);
                                                                                    this.debug("SWAP");
                                                                                    this.mv.visitInsn(95);
                                                                                    this.debug("INVOKESPECIAL java/lang/Byte.<init>::(B)V");
                                                                                    this.mv.visitMethodInsn(183, "java/lang/Byte", "<init>", "(B)V");
                                                                                    try {
                                                                                        clazz19 = Class.forName("java.lang.Byte");
                                                                                    }
                                                                                    catch (ClassNotFoundException classNotFoundException) {
                                                                                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                                                                    }
                                                                                    this.returnType = clazz19;
                                                                                    break block70;
                                                                                }
                                                                                if (cls == Character.TYPE) break block83;
                                                                                try {
                                                                                    clazz18 = Class.forName("java.lang.Character");
                                                                                }
                                                                                catch (ClassNotFoundException classNotFoundException) {
                                                                                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                                                                }
                                                                                if (cls != clazz18) break block70;
                                                                            }
                                                                            this.debug("NEW java/lang/Character");
                                                                            this.mv.visitTypeInsn(187, "java/lang/Character");
                                                                            this.debug("DUP X1");
                                                                            this.mv.visitInsn(90);
                                                                            this.debug("SWAP");
                                                                            this.mv.visitInsn(95);
                                                                            this.debug("INVOKESPECIAL java/lang/Character.<init>::(C)V");
                                                                            this.mv.visitMethodInsn(183, "java/lang/Character", "<init>", "(C)V");
                                                                            try {
                                                                                clazz17 = Class.forName("java.lang.Character");
                                                                            }
                                                                            catch (ClassNotFoundException classNotFoundException) {
                                                                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                                                            }
                                                                            this.returnType = clazz17;
                                                                            break block70;
                                                                        }
                                                                        if (cls == Boolean.TYPE) break block84;
                                                                        try {
                                                                            clazz16 = Class.forName("java.lang.Boolean");
                                                                        }
                                                                        catch (ClassNotFoundException classNotFoundException) {
                                                                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                                                        }
                                                                        if (cls != clazz16) break block85;
                                                                    }
                                                                    this.debug("INVOKESTATIC java/lang/Boolean.valueOf");
                                                                    this.mv.visitMethodInsn(184, "java/lang/Boolean", "valueOf", "(Z)Ljava/lang/Boolean;");
                                                                    try {
                                                                        clazz15 = Class.forName("java.lang.Boolean");
                                                                    }
                                                                    catch (ClassNotFoundException classNotFoundException) {
                                                                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                                                    }
                                                                    this.returnType = clazz15;
                                                                    break block70;
                                                                }
                                                                if (cls == Integer.TYPE) break block86;
                                                                try {
                                                                    clazz14 = Class.forName("java.lang.Integer");
                                                                }
                                                                catch (ClassNotFoundException classNotFoundException) {
                                                                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                                                }
                                                                if (cls != clazz14) break block87;
                                                            }
                                                            this.debug("INVOKESTATIC java/lang/Integer.valueOf");
                                                            this.mv.visitMethodInsn(184, "java/lang/Integer", "valueOf", "(I)Ljava/lang/Integer;");
                                                            try {
                                                                clazz13 = Class.forName("java.lang.Integer");
                                                            }
                                                            catch (ClassNotFoundException classNotFoundException) {
                                                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                                            }
                                                            this.returnType = clazz13;
                                                            break block70;
                                                        }
                                                        if (cls == Float.TYPE) break block88;
                                                        try {
                                                            clazz12 = Class.forName("java.lang.Float");
                                                        }
                                                        catch (ClassNotFoundException classNotFoundException) {
                                                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                                        }
                                                        if (cls != clazz12) break block89;
                                                    }
                                                    this.debug("INVOKESTATIC java/lang/Float.valueOf");
                                                    this.mv.visitMethodInsn(184, "java/lang/Float", "valueOf", "(F)Ljava/lang/Float;");
                                                    try {
                                                        clazz11 = Class.forName("java.lang.Float");
                                                    }
                                                    catch (ClassNotFoundException classNotFoundException) {
                                                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                                    }
                                                    this.returnType = clazz11;
                                                    break block70;
                                                }
                                                if (cls == Double.TYPE) break block90;
                                                try {
                                                    clazz10 = Class.forName("java.lang.Double");
                                                }
                                                catch (ClassNotFoundException classNotFoundException) {
                                                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                                }
                                                if (cls != clazz10) break block91;
                                            }
                                            this.debug("INVOKESTATIC java/lang/Double.valueOf");
                                            this.mv.visitMethodInsn(184, "java/lang/Double", "valueOf", "(D)Ljava/lang/Double;");
                                            try {
                                                clazz9 = Class.forName("java.lang.Double");
                                            }
                                            catch (ClassNotFoundException classNotFoundException) {
                                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                            }
                                            this.returnType = clazz9;
                                            break block70;
                                        }
                                        if (cls == Short.TYPE) break block92;
                                        try {
                                            clazz8 = Class.forName("java.lang.Short");
                                        }
                                        catch (ClassNotFoundException classNotFoundException) {
                                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                        }
                                        if (cls != clazz8) break block93;
                                    }
                                    this.debug("INVOKESTATIC java/lang/Short.valueOf");
                                    this.mv.visitMethodInsn(184, "java/lang/Short", "valueOf", "(S)Ljava/lang/Short;");
                                    try {
                                        clazz7 = Class.forName("java.lang.Short");
                                    }
                                    catch (ClassNotFoundException classNotFoundException) {
                                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                    }
                                    this.returnType = clazz7;
                                    break block70;
                                }
                                if (cls == Long.TYPE) break block94;
                                try {
                                    clazz6 = Class.forName("java.lang.Long");
                                }
                                catch (ClassNotFoundException classNotFoundException) {
                                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                }
                                if (cls != clazz6) break block95;
                            }
                            this.debug("INVOKESTATIC java/lang/Long.valueOf");
                            this.mv.visitMethodInsn(184, "java/lang/Long", "valueOf", "(J)Ljava/lang/Long;");
                            try {
                                clazz5 = Class.forName("java.lang.Long");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                            this.returnType = clazz5;
                            break block70;
                        }
                        if (cls == Byte.TYPE) break block96;
                        try {
                            clazz4 = Class.forName("java.lang.Byte");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                        if (cls != clazz4) break block97;
                    }
                    this.debug("INVOKESTATIC java/lang/Byte.valueOf");
                    this.mv.visitMethodInsn(184, "java/lang/Byte", "valueOf", "(B)Ljava/lang/Byte;");
                    try {
                        clazz3 = Class.forName("java.lang.Byte");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    this.returnType = clazz3;
                    break block70;
                }
                if (cls == Character.TYPE) break block98;
                try {
                    clazz2 = Class.forName("java.lang.Character");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                if (cls != clazz2) break block70;
            }
            this.debug("INVOKESTATIC java/lang/Character.valueOf");
            this.mv.visitMethodInsn(184, "java/lang/Character", "valueOf", "(C)Ljava/lang/Character;");
            try {
                clazz = Class.forName("java.lang.Character");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            this.returnType = clazz;
        }
    }

    private void anyArrayCheck(Class<? extends Object> cls) {
        Class<?> clazz;
        try {
            clazz = Class.forName("[Z");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        if (cls == clazz) {
            this.debug("CHECKCAST [Z");
            this.mv.visitTypeInsn(192, "[Z");
        } else {
            Class<?> clazz2;
            try {
                clazz2 = Class.forName("[I");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            if (cls == clazz2) {
                this.debug("CHECKCAST [I");
                this.mv.visitTypeInsn(192, "[I");
            } else {
                Class<?> clazz3;
                try {
                    clazz3 = Class.forName("[F");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                if (cls == clazz3) {
                    this.debug("CHECKCAST [F");
                    this.mv.visitTypeInsn(192, "[F");
                } else {
                    Class<?> clazz4;
                    try {
                        clazz4 = Class.forName("[D");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    if (cls == clazz4) {
                        this.debug("CHECKCAST [D");
                        this.mv.visitTypeInsn(192, "[D");
                    } else {
                        Class<?> clazz5;
                        try {
                            clazz5 = Class.forName("[S");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                        if (cls == clazz5) {
                            this.debug("CHECKCAST [S");
                            this.mv.visitTypeInsn(192, "[S");
                        } else {
                            Class<?> clazz6;
                            try {
                                clazz6 = Class.forName("[J");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                            if (cls == clazz6) {
                                this.debug("CHECKCAST [J");
                                this.mv.visitTypeInsn(192, "[J");
                            } else {
                                Class<?> clazz7;
                                try {
                                    clazz7 = Class.forName("[B");
                                }
                                catch (ClassNotFoundException classNotFoundException) {
                                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                }
                                if (cls == clazz7) {
                                    this.debug("CHECKCAST [B");
                                    this.mv.visitTypeInsn(192, "[B");
                                } else {
                                    Class<?> clazz8;
                                    try {
                                        clazz8 = Class.forName("[C");
                                    }
                                    catch (ClassNotFoundException classNotFoundException) {
                                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                    }
                                    if (cls == clazz8) {
                                        this.debug("CHECKCAST [C");
                                        this.mv.visitTypeInsn(192, "[C");
                                    } else {
                                        this.debug("CHECKCAST [Ljava/lang/Object;");
                                        this.mv.visitTypeInsn(192, "[Ljava/lang/Object;");
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    private void writeOutLiteralWrapped(Object lit) {
        if (lit instanceof Integer) {
            this.intPush((Integer)lit);
            this.wrapPrimitive(Integer.TYPE);
            return;
        }
        this.debug(new StringBuffer("LDC ").append(lit).toString());
        if (lit instanceof String) {
            this.mv.visitLdcInsn(lit);
        } else if (lit instanceof Long) {
            this.mv.visitLdcInsn(lit);
            this.wrapPrimitive(Long.TYPE);
        } else if (lit instanceof Float) {
            this.mv.visitLdcInsn(lit);
            this.wrapPrimitive(Float.TYPE);
        } else if (lit instanceof Double) {
            this.mv.visitLdcInsn(lit);
            this.wrapPrimitive(Double.TYPE);
        } else if (lit instanceof Short) {
            this.mv.visitLdcInsn(lit);
            this.wrapPrimitive(Short.TYPE);
        } else if (lit instanceof Character) {
            this.mv.visitLdcInsn(lit);
            this.wrapPrimitive(Character.TYPE);
        } else if (lit instanceof Boolean) {
            this.mv.visitLdcInsn(lit);
            this.wrapPrimitive(Boolean.TYPE);
        } else if (lit instanceof Byte) {
            this.mv.visitLdcInsn(lit);
            this.wrapPrimitive(Byte.TYPE);
        }
    }

    private void ldcClassConstant(Class cls) {
        if (OPCODES_VERSION == 48) {
            this.debug(new StringBuffer("LDC \"").append(cls.getName()).append("\"").toString());
            this.mv.visitLdcInsn(cls.getName());
            this.mv.visitMethodInsn(184, "java/lang/Class", "forName", "(Ljava/lang/String;)Ljava/lang/Class;");
            Label l4 = new Label();
            this.mv.visitJumpInsn(167, l4);
            this.mv.visitTypeInsn(187, "java/lang/NoClassDefFoundError");
            this.mv.visitInsn(90);
            this.mv.visitInsn(95);
            this.mv.visitMethodInsn(182, "java/lang/Throwable", "getMessage", "()Ljava/lang/String;");
            this.mv.visitMethodInsn(183, "java/lang/NoClassDefFoundError", "<init>", "(Ljava/lang/String;)V");
            this.mv.visitInsn(191);
            this.mv.visitLabel(l4);
        } else {
            this.debug(new StringBuffer("LDC ").append(Type.getType(cls)).toString());
            this.mv.visitLdcInsn(Type.getType(cls));
        }
    }

    private void buildInputs() {
        if (this.compiledInputs.size() == 0) {
            return;
        }
        this.debug("\n{SETTING UP MEMBERS...}\n");
        StringAppender constSig = new StringAppender("(");
        int size = this.compiledInputs.size();
        int i = 0;
        while (i < size) {
            this.debug(new StringBuffer("ACC_PRIVATE p").append(i).toString());
            FieldVisitor fv = this.cw.visitField(2, new StringBuffer("p").append(i).toString(), "Lorg/mvel/ExecutableStatement;", null, null);
            fv.visitEnd();
            constSig.append("Lorg/mvel/ExecutableStatement;");
            ++i;
        }
        constSig.append(")V");
        this.debug("\n{CREATING INJECTION CONSTRUCTOR}\n");
        MethodVisitor cv = this.cw.visitMethod(1, "<init>", constSig.toString(), null, null);
        cv.visitCode();
        this.debug("ALOAD 0");
        cv.visitVarInsn(25, 0);
        this.debug("INVOKESPECIAL java/lang/Object.<init>");
        cv.visitMethodInsn(183, "java/lang/Object", "<init>", "()V");
        int i2 = 0;
        while (i2 < size) {
            this.debug("ALOAD 0");
            cv.visitVarInsn(25, 0);
            this.debug(new StringBuffer("ALOAD ").append(i2 + 1).toString());
            cv.visitVarInsn(25, i2 + 1);
            this.debug(new StringBuffer("PUTFIELD p").append(i2).toString());
            cv.visitFieldInsn(181, this.className, new StringBuffer("p").append(i2).toString(), "Lorg/mvel/ExecutableStatement;");
            ++i2;
        }
        this.debug("RETURN");
        cv.visitInsn(177);
        cv.visitMaxs(0, 0);
        cv.visitEnd();
        this.debug("}");
    }

    private int _getAccessor(Object o, int type, int register, int index) {
        Class<?> clazz;
        if (o instanceof List) {
            this.debug("NEW org/mvel/util/FastList");
            this.mv.visitTypeInsn(187, LIST_IMPL);
            this.debug("DUP");
            this.mv.visitInsn(89);
            this.intPush(((List)o).size());
            this.debug("INVOKESPECIAL org/mvel/util/FastList.<init>");
            this.mv.visitMethodInsn(183, LIST_IMPL, "<init>", "(I)V");
            this.debug(new StringBuffer("ASTORE ").append(this.cnum + 1).toString());
            int c = ++this.cnum;
            this.mv.visitVarInsn(58, this.cnum);
            for (Object item : (List)o) {
                if (this._getAccessor(item, 1, c, 0) != 3) {
                    this.debug(new StringBuffer("ALOAD ").append(c).toString());
                    this.mv.visitVarInsn(25, c);
                    this.debug(new StringBuffer("ALOAD ").append(this.lastCnum).toString());
                    this.mv.visitVarInsn(25, this.lastCnum);
                }
                this.debug("INVOKEINTERFACE java/util/List.add");
                this.mv.visitMethodInsn(185, "java/util/List", "add", "(Ljava/lang/Object;)Z");
                this.debug("POP");
                this.mv.visitInsn(87);
            }
            this.lastCnum = c;
            return 1;
        }
        if (o instanceof Map) {
            this.debug("NEW java/util/HashMap");
            this.mv.visitTypeInsn(187, MAP_IMPL);
            this.debug("DUP");
            this.mv.visitInsn(89);
            this.intPush(((Map)o).size());
            this.debug("INVOKESPECIAL java/util/HashMap.<init>");
            this.mv.visitMethodInsn(183, MAP_IMPL, "<init>", "(I)V");
            this.debug(new StringBuffer("ASTORE ").append(this.cnum + 1).toString());
            int c = ++this.cnum;
            this.mv.visitVarInsn(58, this.cnum);
            for (Object item : ((Map)o).keySet()) {
                this._getAccessor(item, 2, c, 0);
                int firstParm = this.lastCnum;
                this._getAccessor(((Map)o).get(item), 2, c, 0);
                this.debug(new StringBuffer("ALOAD ").append(c).toString());
                this.mv.visitVarInsn(25, c);
                this.debug(new StringBuffer("ALOAD ").append(firstParm).append(" (").append(((Map)o).get(item)).append(")").toString());
                this.mv.visitVarInsn(25, firstParm);
                this.debug(new StringBuffer("ALOAD ").append(this.lastCnum).append(" (").append(item).append(")").toString());
                this.mv.visitVarInsn(25, this.lastCnum);
                this.debug("INVOKEINTERFACE java/util/Map.put");
                this.mv.visitMethodInsn(185, "java/util/Map", "put", "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
                this.debug("POP");
                this.mv.visitInsn(87);
            }
            this.lastCnum = c;
            return 2;
        }
        if (o instanceof Object[]) {
            this.intPush(((Object[])o).length);
            this.debug(new StringBuffer("ANEWARRAY (").append(o.hashCode()).append(")").toString());
            this.mv.visitTypeInsn(189, "java/lang/Object");
            this.debug(new StringBuffer("ASTORE ").append(this.cnum + 1).toString());
            int c = ++this.cnum;
            this.mv.visitVarInsn(58, this.cnum);
            int i = 0;
            Object[] objectArray = (Object[])o;
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object item = objectArray[n2];
                if (this._getAccessor(item, 0, c, i) != 3) {
                    this.debug(new StringBuffer("ALOAD ").append(c).toString());
                    this.mv.visitVarInsn(25, c);
                    this.intPush(i);
                    this.debug(new StringBuffer("ALOAD + ").append(this.lastCnum).toString());
                    this.mv.visitVarInsn(25, this.lastCnum);
                }
                this.debug(new StringBuffer("AASTORE (").append(o.hashCode()).append(")").toString());
                this.mv.visitInsn(83);
                ++i;
                ++n2;
            }
            this.lastCnum = c;
            return 0;
        }
        this.compiledInputs.add((ExecutableStatement)ParseTools.subCompileExpression((String)o));
        switch (type) {
            case 0: {
                this.debug(new StringBuffer("ALOAD ").append(register).toString());
                this.mv.visitVarInsn(25, register);
                this.intPush(index);
                break;
            }
            case 1: {
                this.debug(new StringBuffer("ALOAD ").append(register).toString());
                this.mv.visitVarInsn(25, register);
            }
        }
        this.debug("ALOAD 0");
        this.mv.visitVarInsn(25, 0);
        this.debug(new StringBuffer("GETFIELD p").append(this.compiledInputs.size() - 1).toString());
        this.mv.visitFieldInsn(180, this.className, new StringBuffer("p").append(this.compiledInputs.size() - 1).toString(), "Lorg/mvel/ExecutableStatement;");
        this.debug("ALOAD 2");
        this.mv.visitVarInsn(25, 2);
        this.debug("ALOAD 3");
        this.mv.visitVarInsn(25, 3);
        this.debug("INVOKEINTERFACE ExecutableStatement.getValue");
        try {
            clazz = Class.forName("org.mvel.ExecutableStatement");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        this.mv.visitMethodInsn(185, Type.getInternalName(clazz), "getValue", "(Ljava/lang/Object;Lorg/mvel/integration/VariableResolverFactory;)Ljava/lang/Object;");
        switch (type) {
            case 2: {
                this.debug(new StringBuffer("ASTORE ").append(this.cnum + 1).append("(").append(o).append(")").toString());
                this.lastCnum = ++this.cnum;
                this.mv.visitVarInsn(58, this.cnum);
            }
        }
        return 3;
    }

    @Override
    public Accessor optimizeCollection(char[] property, Object ctx, Object thisRef, VariableResolverFactory factory) {
        this.cursor = 0;
        this.expr = property;
        this.length = property.length;
        this.compiledInputs = new ArrayList();
        this.ctx = ctx;
        this.thisRef = thisRef;
        this.variableFactory = factory;
        CollectionParser parser = new CollectionParser();
        Object o = ((List)parser.parseCollection(property)).get(0);
        this._initJIT();
        this._getAccessor(o, 1, 0, 0);
        this.debug("ALOAD 4");
        this.mv.visitVarInsn(25, 4);
        this._finishJIT();
        int end = parser.getCursor() + 2;
        try {
            Accessor compiledAccessor = this._initializeAccessor();
            if (end < property.length) {
                return new Union(compiledAccessor, ParseTools.subset(property, end));
            }
            return compiledAccessor;
        }
        catch (Exception e) {
            throw new OptimizationFailure("could not optimize collection", e);
        }
    }

    private void checkcast(Class cls) {
        this.mv.visitTypeInsn(192, Type.getInternalName(cls));
    }

    private void intPush(int index) {
        if (index < 6) {
            switch (index) {
                case 0: {
                    this.debug("ICONST_0");
                    this.mv.visitInsn(3);
                    break;
                }
                case 1: {
                    this.debug("ICONST_1");
                    this.mv.visitInsn(4);
                    break;
                }
                case 2: {
                    this.debug("ICONST_2");
                    this.mv.visitInsn(5);
                    break;
                }
                case 3: {
                    this.debug("ICONST_3");
                    this.mv.visitInsn(6);
                    break;
                }
                case 4: {
                    this.debug("ICONST_4");
                    this.mv.visitInsn(7);
                    break;
                }
                case 5: {
                    this.debug("ICONST_5");
                    this.mv.visitInsn(8);
                }
            }
        } else {
            this.debug(new StringBuffer("BIPUSH ").append(index).toString());
            this.mv.visitIntInsn(16, index);
        }
    }

    @Override
    public Accessor optimizeObjectCreation(char[] property, Object ctx, Object thisRef, VariableResolverFactory factory) {
        this._initJIT();
        this.compiledInputs = new ArrayList();
        this.expr = property;
        this.length = property.length;
        this.ctx = ctx;
        this.thisRef = thisRef;
        this.variableFactory = factory;
        String[] cnsRes = ParseTools.captureContructorAndResidual(property);
        String[] constructorParms = ParseTools.parseMethodOrConstructor(cnsRes[0].toCharArray());
        try {
            if (constructorParms != null) {
                String[] stringArray = constructorParms;
                int n = constructorParms.length;
                int n2 = 0;
                while (n2 < n) {
                    String constructorParm = stringArray[n2];
                    this.compiledInputs.add((ExecutableStatement)ParseTools.subCompileExpression(constructorParm));
                    ++n2;
                }
                String s = new String(ParseTools.subset(property, 0, ArrayTools.findFirst('(', property)));
                Class cls = ParseTools.findClass(factory, s);
                this.debug(new StringBuffer("NEW ").append(Type.getInternalName(cls)).toString());
                this.mv.visitTypeInsn(187, Type.getInternalName(cls));
                this.debug("DUP");
                this.mv.visitInsn(89);
                Object[] parms = new Object[constructorParms.length];
                int i = 0;
                for (ExecutableStatement es : this.compiledInputs) {
                    parms[i++] = es.getValue(ctx, factory);
                }
                Constructor cns = ParseTools.getBestConstructorCanadidate(parms, cls);
                if (cns == null) {
                    throw new CompileException(new StringBuffer("unable to find constructor for: ").append(cls.getName()).toString());
                }
                i = 0;
                while (i < constructorParms.length) {
                    Class tg;
                    this.debug("ALOAD 0");
                    this.mv.visitVarInsn(25, 0);
                    this.debug(new StringBuffer("GETFIELD p").append(i).toString());
                    this.mv.visitFieldInsn(180, this.className, new StringBuffer("p").append(i).toString(), "Lorg/mvel/ExecutableStatement;");
                    this.debug("ALOAD 2");
                    this.mv.visitVarInsn(25, 2);
                    this.debug("ALOAD 3");
                    this.mv.visitVarInsn(25, 3);
                    this.debug("INVOKEINTERFACE org/mvel/ExecutableStatement.getValue");
                    this.mv.visitMethodInsn(185, "org/mvel/ExecutableStatement", "getValue", "(Ljava/lang/Object;Lorg/mvel/integration/VariableResolverFactory;)Ljava/lang/Object;");
                    Class clazz = tg = cns.getParameterTypes()[i].isPrimitive() ? this.getWrapperClass(cns.getParameterTypes()[i]) : cns.getParameterTypes()[i];
                    if (!parms[i].getClass().isAssignableFrom(cns.getParameterTypes()[i])) {
                        this.ldcClassConstant(tg);
                        this.debug("INVOKESTATIC org/mvel/DataConversion.convert");
                        this.mv.visitMethodInsn(184, "org/mvel/DataConversion", "convert", "(Ljava/lang/Object;Ljava/lang/Class;)Ljava/lang/Object;");
                        if (cns.getParameterTypes()[i].isPrimitive()) {
                            this.unwrapPrimitive(cns.getParameterTypes()[i]);
                        } else {
                            this.debug(new StringBuffer("CHECKCAST ").append(Type.getInternalName(tg)).toString());
                            this.mv.visitTypeInsn(192, Type.getInternalName(tg));
                        }
                    } else {
                        this.debug(new StringBuffer("CHECKCAST ").append(Type.getInternalName(cns.getParameterTypes()[i])).toString());
                        this.mv.visitTypeInsn(192, Type.getInternalName(cns.getParameterTypes()[i]));
                    }
                    ++i;
                }
                this.debug(new StringBuffer("INVOKESPECIAL ").append(Type.getInternalName(cls)).append(".<init> : ").append(Type.getConstructorDescriptor(cns)).toString());
                this.mv.visitMethodInsn(183, Type.getInternalName(cls), "<init>", Type.getConstructorDescriptor(cns));
                this._finishJIT();
                Accessor acc = this._initializeAccessor();
                if (cnsRes.length > 1 && cnsRes[1] != null && !cnsRes[1].trim().equals("")) {
                    return new Union(acc, cnsRes[1].toCharArray());
                }
                return acc;
            }
            Class cls = ParseTools.findClass(factory, new String(property));
            this.debug(new StringBuffer("NEW ").append(Type.getInternalName(cls)).toString());
            this.mv.visitTypeInsn(187, Type.getInternalName(cls));
            this.debug("DUP");
            this.mv.visitInsn(89);
            Constructor cns = cls.getConstructor(EMPTYCLS);
            this.debug("INVOKESPECIAL <init>");
            this.mv.visitMethodInsn(183, Type.getInternalName(cls), "<init>", Type.getConstructorDescriptor(cns));
            this._finishJIT();
            Accessor acc = this._initializeAccessor();
            if (cnsRes.length > 1 && cnsRes[1] != null && !cnsRes[1].trim().equals("")) {
                return new Union(acc, cnsRes[1].toCharArray());
            }
            return acc;
        }
        catch (ClassNotFoundException e) {
            throw new CompileException(new StringBuffer("class or class reference not found: ").append(new String(property)).toString());
        }
        catch (Exception e) {
            throw new OptimizationFailure(new StringBuffer("could not optimize construtor: ").append(new String(property)).toString(), e);
        }
    }

    @Override
    public Accessor optimizeFold(char[] property, Object ctx, Object thisRef, VariableResolverFactory factory) {
        throw new OptimizationNotSupported("JIT does not yet support fold operations.");
    }

    @Override
    public Class getEgressType() {
        return this.returnType;
    }

    private void dumpAdvancedDebugging() {
        if (this.buildLog == null) {
            return;
        }
        System.out.println(new StringBuffer("JIT Compiler Dump for: <<").append(new String(this.expr)).append(">>\n-------------------------------\n").toString());
        System.out.println(this.buildLog.toString());
        System.out.println("\n<END OF DUMP>\n");
        if (MVEL.isFileDebugging()) {
            try {
                FileWriter writer = ParseTools.getDebugFileWriter();
                writer.write(this.buildLog.toString());
                writer.flush();
                writer.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

