/*
 * Decompiled with CFR 0.152.
 */
package org.mvel.util;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.WeakHashMap;
import org.mvel.ASTIterator;
import org.mvel.ASTNode;
import org.mvel.AbstractParser;
import org.mvel.CompileException;
import org.mvel.CompiledExpression;
import org.mvel.DataConversion;
import org.mvel.ExecutableAccessor;
import org.mvel.ExecutableLiteral;
import org.mvel.ExpressionCompiler;
import org.mvel.MVEL;
import org.mvel.OptimizationFailure;
import org.mvel.ParseException;
import org.mvel.integration.ResolverTools;
import org.mvel.integration.VariableResolverFactory;
import org.mvel.integration.impl.ClassImportResolverFactory;
import org.mvel.integration.impl.DefaultLocalVariableResolverFactory;
import org.mvel.integration.impl.LocalVariableResolverFactory;
import org.mvel.integration.impl.StaticMethodImportResolverFactory;
import org.mvel.math.MathProcessor;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParseTools {
    public static final Object[] EMPTY_OBJ_ARR;
    public static final MathProcessor MATH_PROCESSOR;
    public static final boolean JDK_14_COMPATIBILITY;
    private static Map<String, Map<Integer, Method>> RESOLVED_METH_CACHE;
    private static Map<Class, Map<Integer, Constructor>> RESOLVED_CONST_CACHE;
    private static Map<Constructor, Class[]> CONSTRUCTOR_PARMS_CACHE;
    private static Map<ClassLoader, Map<String, Class>> CLASS_RESOLVER_CACHE;
    private static Map<Class, Constructor[]> CLASS_CONSTRUCTOR_CACHE;

    static {
        block5: {
            EMPTY_OBJ_ARR = new Object[0];
            try {
                double version = Double.parseDouble(System.getProperty("java.version").substring(0, 3));
                if (version == 1.4) {
                    MATH_PROCESSOR = (MathProcessor)Thread.currentThread().getContextClassLoader().loadClass("org.mvel.math.JDK14CompatabilityMath").newInstance();
                    JDK_14_COMPATIBILITY = true;
                    break block5;
                }
                if (version > 1.4) {
                    MATH_PROCESSOR = (MathProcessor)Thread.currentThread().getContextClassLoader().loadClass("org.mvel.math.IEEEFloatingPointMath").newInstance();
                    JDK_14_COMPATIBILITY = false;
                    break block5;
                }
                throw new RuntimeException(new StringBuffer("unsupported java version: ").append(version).toString());
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException("unable to initialize math processor", e);
            }
        }
        RESOLVED_METH_CACHE = new WeakHashMap<String, Map<Integer, Method>>(10);
        RESOLVED_CONST_CACHE = new WeakHashMap<Class, Map<Integer, Constructor>>(10);
        CONSTRUCTOR_PARMS_CACHE = new WeakHashMap<Constructor, Class[]>(10);
        CLASS_RESOLVER_CACHE = new WeakHashMap<ClassLoader, Map<String, Class>>(1, 1.0f);
        CLASS_CONSTRUCTOR_CACHE = new WeakHashMap<Class, Constructor[]>(10);
    }

    public static String[] parseMethodOrConstructor(char[] parm) {
        int start = -1;
        int i = 0;
        while (i < parm.length) {
            if (parm[i] == '(') {
                start = ++i;
                break;
            }
            ++i;
        }
        if (start != -1) {
            return ParseTools.parseParameterList(parm, --start + 1, ParseTools.balancedCapture(parm, start, '(') - start - 1);
        }
        return null;
    }

    public static String[] parseParameterList(char[] parm, int offset, int length) {
        String s;
        LinkedList<String> list = new LinkedList<String>();
        if (length == -1) {
            length = parm.length;
        }
        int start = offset;
        int i = offset;
        int end = i + length;
        while (i < end) {
            switch (parm[i]) {
                case '(': 
                case '[': 
                case '{': {
                    i = ParseTools.balancedCapture(parm, i, parm[i]);
                    break;
                }
                case '\'': {
                    i = ParseTools.captureStringLiteral('\'', parm, i, parm.length);
                    break;
                }
                case '\"': {
                    i = ParseTools.captureStringLiteral('\"', parm, i, parm.length);
                    break;
                }
                case ',': {
                    if (i > start) {
                        while (Character.isWhitespace(parm[start])) {
                            ++start;
                        }
                        list.add(new String(parm, start, i - start));
                    }
                    while (Character.isWhitespace(parm[i])) {
                        ++i;
                    }
                    start = i + 1;
                }
            }
            ++i;
        }
        if (start < length + offset && i > start) {
            String s2 = new String(parm, start, i - start).trim();
            if (s2.length() > 0) {
                list.add(s2);
            }
        } else if (list.size() == 0 && (s = new String(parm, start, length).trim()).length() > 0) {
            list.add(s);
        }
        return list.toArray(new String[list.size()]);
    }

    public static Method getBestCandidate(Object[] arguments, String method, Method[] methods) {
        Class[] targetParms = new Class[arguments.length];
        int i = 0;
        while (i < arguments.length) {
            Class<?> clazz;
            if (arguments[i] != null) {
                clazz = arguments[i].getClass();
            } else {
                try {
                    clazz = Class.forName("java.lang.Object");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            targetParms[i] = clazz;
            ++i;
        }
        return ParseTools.getBestCandidate(targetParms, method, methods);
    }

    /*
     * Unable to fully structure code
     */
    public static Method getBestCandidate(Class[] arguments, String method, Method[] methods) {
        if (methods.length == 0) {
            return null;
        }
        bestCandidate = null;
        bestScore = 0;
        score = 0;
        hash = new Integer(ParseTools.createClassSignatureHash(methods[0].getDeclaringClass(), arguments));
        if (ParseTools.RESOLVED_METH_CACHE.containsKey(method) && ParseTools.RESOLVED_METH_CACHE.get(method).containsKey(hash)) {
            return ParseTools.RESOLVED_METH_CACHE.get(method).get(hash);
        }
        var11_7 = methods;
        var10_8 = methods.length;
        var9_9 = 0;
        while (var9_9 < var10_8) {
            block12: {
                meth = var11_7[var9_9];
                if (!method.equals(meth.getName()) || (parmTypes = meth.getParameterTypes()).length != arguments.length) break block12;
                if (arguments.length == 0 && parmTypes.length == 0) {
                    bestCandidate = meth;
                    break;
                }
                i = 0;
                while (i < arguments.length) {
                    block14: {
                        block18: {
                            block17: {
                                block16: {
                                    block15: {
                                        block13: {
                                            if (parmTypes[i] != arguments[i]) break block13;
                                            score += 5;
                                            break block14;
                                        }
                                        if (!parmTypes[i].isPrimitive() || ParseTools.boxPrimitive(parmTypes[i]) != arguments[i]) break block15;
                                        score += 4;
                                        break block14;
                                    }
                                    if (!arguments[i].isPrimitive() || ParseTools.unboxPrimitive(arguments[i]) != parmTypes[i]) break block16;
                                    score += 4;
                                    break block14;
                                }
                                if (!ParseTools.isNumericallyCoercible(arguments[i], parmTypes[i])) break block17;
                                score += 3;
                                break block14;
                            }
                            if (!parmTypes[i].isAssignableFrom(arguments[i])) break block18;
                            score += 2;
                            break block14;
                        }
                        if (DataConversion.canConvert(parmTypes[i], arguments[i])) ** GOTO lbl-1000
                        try {
                            v0 = Class.forName("java.lang.Object");
                        }
                        catch (ClassNotFoundException v1) {
                            throw new NoClassDefFoundError(v1.getMessage());
                        }
                        if (arguments[i] == v0) lbl-1000:
                        // 2 sources

                        {
                            ++score;
                        } else {
                            score = 0;
                            break;
                        }
                    }
                    ++i;
                }
                if (score != 0 && score > bestScore) {
                    bestCandidate = meth;
                    bestScore = score;
                }
                score = 0;
            }
            ++var9_9;
        }
        if (bestCandidate != null) {
            if (!ParseTools.RESOLVED_METH_CACHE.containsKey(method)) {
                ParseTools.RESOLVED_METH_CACHE.put(method, new WeakHashMap<K, V>());
            }
            ParseTools.RESOLVED_METH_CACHE.get(method).put(hash, bestCandidate);
        }
        return bestCandidate;
    }

    public static Method getWidenedTarget(Method method) {
        Class<?> cls = method.getDeclaringClass();
        Method m = method;
        Class[] args = method.getParameterTypes();
        String name = method.getName();
        do {
            Class<?>[] classArray = cls.getInterfaces();
            int n = classArray.length;
            int n2 = 0;
            while (n2 < n) {
                Class<?> iface = classArray[n2];
                m = ParseTools.getBestCandidate(args, name, iface.getMethods());
                if (m != null && m.getDeclaringClass().getSuperclass() != null) {
                    cls = m.getDeclaringClass();
                }
                ++n2;
            }
        } while ((cls = cls.getSuperclass()) != null);
        return m != null ? m : method;
    }

    private static Class[] getConstructors(Constructor cns) {
        if (CONSTRUCTOR_PARMS_CACHE.containsKey(cns)) {
            return CONSTRUCTOR_PARMS_CACHE.get(cns);
        }
        Class[] c = cns.getParameterTypes();
        CONSTRUCTOR_PARMS_CACHE.put(cns, c);
        return c;
    }

    public static Constructor getBestConstructorCanadidate(Object[] arguments, Class cls) {
        Constructor bestCandidate = null;
        int bestScore = 0;
        int score = 0;
        Class[] targetParms = new Class[arguments.length];
        int i = 0;
        while (i < arguments.length) {
            Class<?> clazz;
            if (arguments[i] != null) {
                clazz = arguments[i].getClass();
            } else {
                try {
                    clazz = Class.forName("java.lang.Object");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            targetParms[i] = clazz;
            ++i;
        }
        Integer hash = new Integer(ParseTools.createClassSignatureHash(cls, targetParms));
        if (RESOLVED_CONST_CACHE.containsKey(cls) && RESOLVED_CONST_CACHE.get(cls).containsKey(hash)) {
            return RESOLVED_CONST_CACHE.get(cls).get(hash);
        }
        Constructor[] constructorArray = ParseTools.getConstructors(cls);
        int n = constructorArray.length;
        int n2 = 0;
        while (n2 < n) {
            Constructor construct = constructorArray[n2];
            Class[] parmTypes = ParseTools.getConstructors(construct);
            if (parmTypes.length == arguments.length) {
                if (arguments.length == 0 && parmTypes.length == 0) {
                    return construct;
                }
                int i2 = 0;
                while (i2 < arguments.length) {
                    if (parmTypes[i2] == targetParms[i2]) {
                        score += 5;
                    } else if (parmTypes[i2].isPrimitive() && ParseTools.boxPrimitive(parmTypes[i2]) == targetParms[i2]) {
                        score += 4;
                    } else if (targetParms[i2].isPrimitive() && ParseTools.unboxPrimitive(targetParms[i2]) == parmTypes[i2]) {
                        score += 4;
                    } else if (ParseTools.isNumericallyCoercible(targetParms[i2], parmTypes[i2])) {
                        score += 3;
                    } else if (parmTypes[i2].isAssignableFrom(targetParms[i2])) {
                        score += 2;
                    } else if (DataConversion.canConvert(parmTypes[i2], targetParms[i2])) {
                        ++score;
                    } else {
                        score = 0;
                        break;
                    }
                    ++i2;
                }
                if (score != 0 && score > bestScore) {
                    bestCandidate = construct;
                    bestScore = score;
                }
                score = 0;
            }
            ++n2;
        }
        if (bestCandidate != null) {
            if (!RESOLVED_CONST_CACHE.containsKey(cls)) {
                RESOLVED_CONST_CACHE.put(cls, new WeakHashMap());
            }
            RESOLVED_CONST_CACHE.get(cls).put(hash, bestCandidate);
        }
        return bestCandidate;
    }

    public static Class createClassSafe(String className) {
        try {
            return ParseTools.createClass(className);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    public static Class createClass(String className) throws ClassNotFoundException {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (!CLASS_RESOLVER_CACHE.containsKey(classLoader)) {
            CLASS_RESOLVER_CACHE.put(classLoader, new WeakHashMap(10));
        }
        if (CLASS_RESOLVER_CACHE.get(classLoader).containsKey(className)) {
            return CLASS_RESOLVER_CACHE.get(classLoader).get(className);
        }
        Class<?> cls = Thread.currentThread().getContextClassLoader().loadClass(className);
        CLASS_RESOLVER_CACHE.get(classLoader).put(className, cls);
        return cls;
    }

    public static Constructor[] getConstructors(Class cls) {
        if (CLASS_CONSTRUCTOR_CACHE.containsKey(cls)) {
            return CLASS_CONSTRUCTOR_CACHE.get(cls);
        }
        Constructor[] cns = cls.getConstructors();
        CLASS_CONSTRUCTOR_CACHE.put(cls, cns);
        return cns;
    }

    public static String[] captureContructorAndResidual(String token) {
        char[] cs = token.toCharArray();
        int depth = 0;
        int i = 0;
        while (i < cs.length) {
            switch (cs[i]) {
                case '(': {
                    ++depth;
                    break;
                }
                case ')': {
                    if (1 != depth--) break;
                    return new String[]{new String(cs, 0, ++i), new String(cs, i, cs.length - i)};
                }
            }
            ++i;
        }
        return new String[]{token};
    }

    public static String[] captureContructorAndResidual(char[] cs) {
        int depth = 0;
        int i = 0;
        while (i < cs.length) {
            switch (cs[i]) {
                case '(': {
                    ++depth;
                    break;
                }
                case ')': {
                    if (1 != depth--) break;
                    return new String[]{new String(cs, 0, ++i), new String(cs, i, cs.length - i)};
                }
            }
            ++i;
        }
        return new String[]{new String(cs)};
    }

    public static Class boxPrimitive(Class cls) {
        block111: {
            Class<?> clazz;
            block110: {
                Class<?> clazz2;
                Class<?> clazz3;
                block109: {
                    Class<?> clazz4;
                    block108: {
                        Class<?> clazz5;
                        block107: {
                            Class<?> clazz6;
                            block106: {
                                Class<?> clazz7;
                                Class<?> clazz8;
                                block105: {
                                    Class<?> clazz9;
                                    block104: {
                                        Class<?> clazz10;
                                        block103: {
                                            Class<?> clazz11;
                                            block102: {
                                                Class<?> clazz12;
                                                Class<?> clazz13;
                                                block101: {
                                                    Class<?> clazz14;
                                                    block100: {
                                                        Class<?> clazz15;
                                                        block99: {
                                                            Class<?> clazz16;
                                                            block98: {
                                                                Class<?> clazz17;
                                                                Class<?> clazz18;
                                                                block97: {
                                                                    Class<?> clazz19;
                                                                    block96: {
                                                                        Class<?> clazz20;
                                                                        block95: {
                                                                            Class<?> clazz21;
                                                                            block94: {
                                                                                Class<?> clazz22;
                                                                                Class<?> clazz23;
                                                                                block93: {
                                                                                    Class<?> clazz24;
                                                                                    block92: {
                                                                                        Class<?> clazz25;
                                                                                        block91: {
                                                                                            Class<?> clazz26;
                                                                                            block90: {
                                                                                                Class<?> clazz27;
                                                                                                Class<?> clazz28;
                                                                                                block89: {
                                                                                                    Class<?> clazz29;
                                                                                                    block88: {
                                                                                                        Class<?> clazz30;
                                                                                                        block87: {
                                                                                                            Class<?> clazz31;
                                                                                                            block86: {
                                                                                                                Class<?> clazz32;
                                                                                                                Class<?> clazz33;
                                                                                                                block85: {
                                                                                                                    Class<?> clazz34;
                                                                                                                    block84: {
                                                                                                                        Class<?> clazz35;
                                                                                                                        if (cls == Integer.TYPE) break block84;
                                                                                                                        try {
                                                                                                                            clazz35 = Class.forName("java.lang.Integer");
                                                                                                                        }
                                                                                                                        catch (ClassNotFoundException classNotFoundException) {
                                                                                                                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                                                                                                        }
                                                                                                                        if (cls != clazz35) break block85;
                                                                                                                    }
                                                                                                                    try {
                                                                                                                        clazz34 = Class.forName("java.lang.Integer");
                                                                                                                    }
                                                                                                                    catch (ClassNotFoundException classNotFoundException) {
                                                                                                                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                                                                                                    }
                                                                                                                    return clazz34;
                                                                                                                }
                                                                                                                try {
                                                                                                                    clazz33 = Class.forName("[I");
                                                                                                                }
                                                                                                                catch (ClassNotFoundException classNotFoundException) {
                                                                                                                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                                                                                                }
                                                                                                                if (cls == clazz33) break block86;
                                                                                                                try {
                                                                                                                    clazz32 = Class.forName("[Ljava.lang.Integer;");
                                                                                                                }
                                                                                                                catch (ClassNotFoundException classNotFoundException) {
                                                                                                                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                                                                                                }
                                                                                                                if (cls != clazz32) break block87;
                                                                                                            }
                                                                                                            try {
                                                                                                                clazz31 = Class.forName("[Ljava.lang.Integer;");
                                                                                                            }
                                                                                                            catch (ClassNotFoundException classNotFoundException) {
                                                                                                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                                                                                            }
                                                                                                            return clazz31;
                                                                                                        }
                                                                                                        if (cls == Long.TYPE) break block88;
                                                                                                        try {
                                                                                                            clazz30 = Class.forName("java.lang.Long");
                                                                                                        }
                                                                                                        catch (ClassNotFoundException classNotFoundException) {
                                                                                                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                                                                                        }
                                                                                                        if (cls != clazz30) break block89;
                                                                                                    }
                                                                                                    try {
                                                                                                        clazz29 = Class.forName("java.lang.Long");
                                                                                                    }
                                                                                                    catch (ClassNotFoundException classNotFoundException) {
                                                                                                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                                                                                    }
                                                                                                    return clazz29;
                                                                                                }
                                                                                                try {
                                                                                                    clazz28 = Class.forName("[J");
                                                                                                }
                                                                                                catch (ClassNotFoundException classNotFoundException) {
                                                                                                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                                                                                }
                                                                                                if (cls == clazz28) break block90;
                                                                                                try {
                                                                                                    clazz27 = Class.forName("[Ljava.lang.Long;");
                                                                                                }
                                                                                                catch (ClassNotFoundException classNotFoundException) {
                                                                                                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                                                                                }
                                                                                                if (cls != clazz27) break block91;
                                                                                            }
                                                                                            try {
                                                                                                clazz26 = Class.forName("[Ljava.lang.Long;");
                                                                                            }
                                                                                            catch (ClassNotFoundException classNotFoundException) {
                                                                                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                                                                            }
                                                                                            return clazz26;
                                                                                        }
                                                                                        if (cls == Short.TYPE) break block92;
                                                                                        try {
                                                                                            clazz25 = Class.forName("java.lang.Short");
                                                                                        }
                                                                                        catch (ClassNotFoundException classNotFoundException) {
                                                                                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                                                                        }
                                                                                        if (cls != clazz25) break block93;
                                                                                    }
                                                                                    try {
                                                                                        clazz24 = Class.forName("java.lang.Short");
                                                                                    }
                                                                                    catch (ClassNotFoundException classNotFoundException) {
                                                                                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                                                                    }
                                                                                    return clazz24;
                                                                                }
                                                                                try {
                                                                                    clazz23 = Class.forName("[S");
                                                                                }
                                                                                catch (ClassNotFoundException classNotFoundException) {
                                                                                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                                                                }
                                                                                if (cls == clazz23) break block94;
                                                                                try {
                                                                                    clazz22 = Class.forName("[Ljava.lang.Short;");
                                                                                }
                                                                                catch (ClassNotFoundException classNotFoundException) {
                                                                                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                                                                }
                                                                                if (cls != clazz22) break block95;
                                                                            }
                                                                            try {
                                                                                clazz21 = Class.forName("[Ljava.lang.Short;");
                                                                            }
                                                                            catch (ClassNotFoundException classNotFoundException) {
                                                                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                                                            }
                                                                            return clazz21;
                                                                        }
                                                                        if (cls == Double.TYPE) break block96;
                                                                        try {
                                                                            clazz20 = Class.forName("java.lang.Double");
                                                                        }
                                                                        catch (ClassNotFoundException classNotFoundException) {
                                                                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                                                        }
                                                                        if (cls != clazz20) break block97;
                                                                    }
                                                                    try {
                                                                        clazz19 = Class.forName("java.lang.Double");
                                                                    }
                                                                    catch (ClassNotFoundException classNotFoundException) {
                                                                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                                                    }
                                                                    return clazz19;
                                                                }
                                                                try {
                                                                    clazz18 = Class.forName("[D");
                                                                }
                                                                catch (ClassNotFoundException classNotFoundException) {
                                                                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                                                }
                                                                if (cls == clazz18) break block98;
                                                                try {
                                                                    clazz17 = Class.forName("[Ljava.lang.Double;");
                                                                }
                                                                catch (ClassNotFoundException classNotFoundException) {
                                                                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                                                }
                                                                if (cls != clazz17) break block99;
                                                            }
                                                            try {
                                                                clazz16 = Class.forName("[Ljava.lang.Double;");
                                                            }
                                                            catch (ClassNotFoundException classNotFoundException) {
                                                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                                            }
                                                            return clazz16;
                                                        }
                                                        if (cls == Float.TYPE) break block100;
                                                        try {
                                                            clazz15 = Class.forName("java.lang.Float");
                                                        }
                                                        catch (ClassNotFoundException classNotFoundException) {
                                                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                                        }
                                                        if (cls != clazz15) break block101;
                                                    }
                                                    try {
                                                        clazz14 = Class.forName("java.lang.Float");
                                                    }
                                                    catch (ClassNotFoundException classNotFoundException) {
                                                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                                    }
                                                    return clazz14;
                                                }
                                                try {
                                                    clazz13 = Class.forName("[F");
                                                }
                                                catch (ClassNotFoundException classNotFoundException) {
                                                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                                }
                                                if (cls == clazz13) break block102;
                                                try {
                                                    clazz12 = Class.forName("[Ljava.lang.Float;");
                                                }
                                                catch (ClassNotFoundException classNotFoundException) {
                                                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                                }
                                                if (cls != clazz12) break block103;
                                            }
                                            try {
                                                clazz11 = Class.forName("[Ljava.lang.Float;");
                                            }
                                            catch (ClassNotFoundException classNotFoundException) {
                                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                            }
                                            return clazz11;
                                        }
                                        if (cls == Boolean.TYPE) break block104;
                                        try {
                                            clazz10 = Class.forName("java.lang.Boolean");
                                        }
                                        catch (ClassNotFoundException classNotFoundException) {
                                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                        }
                                        if (cls != clazz10) break block105;
                                    }
                                    try {
                                        clazz9 = Class.forName("java.lang.Boolean");
                                    }
                                    catch (ClassNotFoundException classNotFoundException) {
                                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                    }
                                    return clazz9;
                                }
                                try {
                                    clazz8 = Class.forName("[Z");
                                }
                                catch (ClassNotFoundException classNotFoundException) {
                                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                }
                                if (cls == clazz8) break block106;
                                try {
                                    clazz7 = Class.forName("[Ljava.lang.Boolean;");
                                }
                                catch (ClassNotFoundException classNotFoundException) {
                                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                }
                                if (cls != clazz7) break block107;
                            }
                            try {
                                clazz6 = Class.forName("[Ljava.lang.Boolean;");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                            return clazz6;
                        }
                        if (cls == Byte.TYPE) break block108;
                        try {
                            clazz5 = Class.forName("java.lang.Byte");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                        if (cls != clazz5) break block109;
                    }
                    try {
                        clazz4 = Class.forName("java.lang.Byte");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    return clazz4;
                }
                try {
                    clazz3 = Class.forName("[B");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                if (cls == clazz3) break block110;
                try {
                    clazz2 = Class.forName("[Ljava.lang.Byte;");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                if (cls != clazz2) break block111;
            }
            try {
                clazz = Class.forName("[Ljava.lang.Byte;");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            return clazz;
        }
        return null;
    }

    public static Class unboxPrimitive(Class cls) {
        block83: {
            Class<?> clazz;
            block82: {
                Class<?> clazz2;
                Class<?> clazz3;
                Class<?> clazz4;
                block81: {
                    Class<?> clazz5;
                    block80: {
                        Class<?> clazz6;
                        Class<?> clazz7;
                        Class<?> clazz8;
                        block79: {
                            Class<?> clazz9;
                            block78: {
                                Class<?> clazz10;
                                Class<?> clazz11;
                                Class<?> clazz12;
                                block77: {
                                    Class<?> clazz13;
                                    block76: {
                                        Class<?> clazz14;
                                        Class<?> clazz15;
                                        Class<?> clazz16;
                                        block75: {
                                            Class<?> clazz17;
                                            block74: {
                                                Class<?> clazz18;
                                                Class<?> clazz19;
                                                Class<?> clazz20;
                                                block73: {
                                                    Class<?> clazz21;
                                                    block72: {
                                                        Class<?> clazz22;
                                                        Class<?> clazz23;
                                                        Class<?> clazz24;
                                                        block71: {
                                                            Class<?> clazz25;
                                                            block70: {
                                                                Class<?> clazz26;
                                                                Class<?> clazz27;
                                                                Class<?> clazz28;
                                                                try {
                                                                    clazz28 = Class.forName("java.lang.Integer");
                                                                }
                                                                catch (ClassNotFoundException classNotFoundException) {
                                                                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                                                }
                                                                if (cls == clazz28 || cls == Integer.TYPE) {
                                                                    return Integer.TYPE;
                                                                }
                                                                try {
                                                                    clazz27 = Class.forName("[Ljava.lang.Integer;");
                                                                }
                                                                catch (ClassNotFoundException classNotFoundException) {
                                                                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                                                }
                                                                if (cls == clazz27) break block70;
                                                                try {
                                                                    clazz26 = Class.forName("[I");
                                                                }
                                                                catch (ClassNotFoundException classNotFoundException) {
                                                                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                                                }
                                                                if (cls != clazz26) break block71;
                                                            }
                                                            try {
                                                                clazz25 = Class.forName("[I");
                                                            }
                                                            catch (ClassNotFoundException classNotFoundException) {
                                                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                                            }
                                                            return clazz25;
                                                        }
                                                        try {
                                                            clazz24 = Class.forName("java.lang.Long");
                                                        }
                                                        catch (ClassNotFoundException classNotFoundException) {
                                                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                                        }
                                                        if (cls == clazz24 || cls == Long.TYPE) {
                                                            return Long.TYPE;
                                                        }
                                                        try {
                                                            clazz23 = Class.forName("[Ljava.lang.Long;");
                                                        }
                                                        catch (ClassNotFoundException classNotFoundException) {
                                                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                                        }
                                                        if (cls == clazz23) break block72;
                                                        try {
                                                            clazz22 = Class.forName("[J");
                                                        }
                                                        catch (ClassNotFoundException classNotFoundException) {
                                                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                                        }
                                                        if (cls != clazz22) break block73;
                                                    }
                                                    try {
                                                        clazz21 = Class.forName("[J");
                                                    }
                                                    catch (ClassNotFoundException classNotFoundException) {
                                                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                                    }
                                                    return clazz21;
                                                }
                                                try {
                                                    clazz20 = Class.forName("java.lang.Short");
                                                }
                                                catch (ClassNotFoundException classNotFoundException) {
                                                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                                }
                                                if (cls == clazz20 || cls == Short.TYPE) {
                                                    return Short.TYPE;
                                                }
                                                try {
                                                    clazz19 = Class.forName("[Ljava.lang.Short;");
                                                }
                                                catch (ClassNotFoundException classNotFoundException) {
                                                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                                }
                                                if (cls == clazz19) break block74;
                                                try {
                                                    clazz18 = Class.forName("[S");
                                                }
                                                catch (ClassNotFoundException classNotFoundException) {
                                                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                                }
                                                if (cls != clazz18) break block75;
                                            }
                                            try {
                                                clazz17 = Class.forName("[S");
                                            }
                                            catch (ClassNotFoundException classNotFoundException) {
                                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                            }
                                            return clazz17;
                                        }
                                        try {
                                            clazz16 = Class.forName("java.lang.Double");
                                        }
                                        catch (ClassNotFoundException classNotFoundException) {
                                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                        }
                                        if (cls == clazz16 || cls == Double.TYPE) {
                                            return Double.TYPE;
                                        }
                                        try {
                                            clazz15 = Class.forName("[Ljava.lang.Double;");
                                        }
                                        catch (ClassNotFoundException classNotFoundException) {
                                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                        }
                                        if (cls == clazz15) break block76;
                                        try {
                                            clazz14 = Class.forName("[D");
                                        }
                                        catch (ClassNotFoundException classNotFoundException) {
                                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                        }
                                        if (cls != clazz14) break block77;
                                    }
                                    try {
                                        clazz13 = Class.forName("[D");
                                    }
                                    catch (ClassNotFoundException classNotFoundException) {
                                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                    }
                                    return clazz13;
                                }
                                try {
                                    clazz12 = Class.forName("java.lang.Float");
                                }
                                catch (ClassNotFoundException classNotFoundException) {
                                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                }
                                if (cls == clazz12 || cls == Float.TYPE) {
                                    return Float.TYPE;
                                }
                                try {
                                    clazz11 = Class.forName("[Ljava.lang.Float;");
                                }
                                catch (ClassNotFoundException classNotFoundException) {
                                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                }
                                if (cls == clazz11) break block78;
                                try {
                                    clazz10 = Class.forName("[F");
                                }
                                catch (ClassNotFoundException classNotFoundException) {
                                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                }
                                if (cls != clazz10) break block79;
                            }
                            try {
                                clazz9 = Class.forName("[F");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                            return clazz9;
                        }
                        try {
                            clazz8 = Class.forName("java.lang.Boolean");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                        if (cls == clazz8 || cls == Boolean.TYPE) {
                            return Boolean.TYPE;
                        }
                        try {
                            clazz7 = Class.forName("[Ljava.lang.Boolean;");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                        if (cls == clazz7) break block80;
                        try {
                            clazz6 = Class.forName("[Z");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                        if (cls != clazz6) break block81;
                    }
                    try {
                        clazz5 = Class.forName("[Z");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    return clazz5;
                }
                try {
                    clazz4 = Class.forName("java.lang.Byte");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                if (cls == clazz4 || cls == Byte.TYPE) {
                    return Byte.TYPE;
                }
                try {
                    clazz3 = Class.forName("[Ljava.lang.Byte;");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                if (cls == clazz3) break block82;
                try {
                    clazz2 = Class.forName("[B");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                if (cls != clazz2) break block83;
            }
            try {
                clazz = Class.forName("[B");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            return clazz;
        }
        return null;
    }

    public static boolean containsCheck(Object compareTo, Object compareTest) {
        if (compareTo == null) {
            return false;
        }
        if (compareTo instanceof String) {
            return ((String)compareTo).indexOf(String.valueOf(compareTest)) > -1;
        }
        if (compareTo instanceof Collection) {
            return ((Collection)compareTo).contains(compareTest);
        }
        if (compareTo instanceof Map) {
            return ((Map)compareTo).containsKey(compareTest);
        }
        if (compareTo.getClass().isArray()) {
            Object[] objectArray = (Object[])compareTo;
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object o = objectArray[n2];
                if (compareTest == null && o == null) {
                    return true;
                }
                if (((Boolean)ParseTools.doOperations(o, 10, compareTest)).booleanValue()) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    public static int createClassSignatureHash(Class declaring, Class[] sig) {
        int hash = 0;
        Class[] classArray = sig;
        int n = sig.length;
        int n2 = 0;
        while (n2 < n) {
            Class cls = classArray[n2];
            if (cls != null) {
                hash += cls.hashCode();
            }
            ++n2;
        }
        return hash + sig.length + declaring.hashCode();
    }

    public static char handleEscapeSequence(char escapedChar) {
        switch (escapedChar) {
            case '\\': {
                return '\\';
            }
            case 't': {
                return '\t';
            }
            case 'r': {
                return '\r';
            }
            case 'n': {
                return '\n';
            }
            case '\'': {
                return '\'';
            }
            case '\"': {
                return '\"';
            }
        }
        throw new ParseException(new StringBuffer("illegal escape sequence: ").append(escapedChar).toString());
    }

    public static char[] createShortFormOperativeAssignment(String name, char[] statement, int operation) {
        if (operation == -1) {
            return statement;
        }
        int op = 0;
        switch (operation) {
            case 0: {
                op = 43;
                break;
            }
            case 1: {
                op = 45;
                break;
            }
            case 2: {
                op = 42;
                break;
            }
            case 3: {
                op = 47;
                break;
            }
            case 21: {
                op = 38;
                break;
            }
            case 22: {
                op = 124;
            }
        }
        char[] stmt = new char[name.length() + statement.length + 1];
        System.arraycopy(name.toCharArray(), 0, stmt, 0, name.length());
        stmt[name.length()] = op;
        System.arraycopy(statement, 0, stmt, name.length() + 1, statement.length);
        return stmt;
    }

    public static VariableResolverFactory finalLocalVariableFactory(VariableResolverFactory factory) {
        VariableResolverFactory v = factory;
        while (v != null) {
            if (v instanceof LocalVariableResolverFactory) {
                return v;
            }
            v = v.getNextFactory();
        }
        if (factory == null) {
            throw new OptimizationFailure("unable to assign variables.  no variable resolver factory available.");
        }
        return new DefaultLocalVariableResolverFactory((Map<String, Object>)new HashMap<String, Object>()).setNextFactory(factory);
    }

    public static ClassImportResolverFactory findClassImportResolverFactory(VariableResolverFactory factory) {
        VariableResolverFactory v = factory;
        while (v != null) {
            if (v instanceof ClassImportResolverFactory) {
                return (ClassImportResolverFactory)v;
            }
            v = v.getNextFactory();
        }
        if (factory == null) {
            throw new OptimizationFailure("unable to import classes.  no variable resolver factory available.");
        }
        return ResolverTools.insertFactory(factory, new ClassImportResolverFactory());
    }

    public static StaticMethodImportResolverFactory findStaticMethodImportResolverFactory(VariableResolverFactory factory) {
        VariableResolverFactory v = factory;
        while (v != null) {
            if (v instanceof StaticMethodImportResolverFactory) {
                return (StaticMethodImportResolverFactory)v;
            }
            v = v.getNextFactory();
        }
        if (factory == null) {
            throw new OptimizationFailure("unable to import classes.  no variable resolver factory available.");
        }
        return ResolverTools.insertFactory(factory, new StaticMethodImportResolverFactory());
    }

    public static Class findClass(VariableResolverFactory factory, String name) throws ClassNotFoundException {
        try {
            if (AbstractParser.LITERALS.containsKey(name)) {
                return (Class)AbstractParser.LITERALS.get(name);
            }
            if (factory != null && factory.isResolveable(name)) {
                return (Class)factory.getVariableResolver(name).getValue();
            }
            if (AbstractParser.getCurrentThreadParserContext() != null && AbstractParser.getCurrentThreadParserContext().hasImport(name)) {
                return AbstractParser.getCurrentThreadParserContext().getImport(name);
            }
            return ParseTools.createClass(name);
        }
        catch (ClassNotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CompileException(new StringBuffer("class not found: ").append(name).toString(), e);
        }
    }

    public static boolean debug(String str) {
        return true;
    }

    public static boolean debug(Throwable t) {
        t.printStackTrace();
        return true;
    }

    public static char[] subset(char[] array, int start, int length) {
        char[] newArray = new char[length];
        System.arraycopy(array, start, newArray, 0, length);
        return newArray;
    }

    public static char[] subset(char[] array, int start) {
        char[] newArray = new char[array.length - start];
        System.arraycopy(array, start, newArray, 0, newArray.length);
        return newArray;
    }

    public static int resolveType(Class cls) {
        Class<?> clazz;
        Class<?> clazz2;
        Class<?> clazz3;
        Class<?> clazz4;
        Class<?> clazz5;
        Class<?> clazz6;
        Class<?> clazz7;
        Class<?> clazz8;
        Class<?> clazz9;
        Class<?> clazz10;
        Class<?> clazz11;
        if (cls == null) {
            return 0;
        }
        try {
            clazz11 = Class.forName("java.math.BigDecimal");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        if (clazz11 == cls) {
            return 110;
        }
        try {
            clazz10 = Class.forName("java.math.BigInteger");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        if (clazz10 == cls) {
            return 111;
        }
        try {
            clazz9 = Class.forName("java.lang.String");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        if (clazz9 == cls) {
            return 1;
        }
        if (Integer.TYPE == cls) {
            return 101;
        }
        if (Short.TYPE == cls) {
            return 100;
        }
        if (Float.TYPE == cls) {
            return 104;
        }
        if (Double.TYPE == cls) {
            return 103;
        }
        if (Long.TYPE == cls) {
            return 102;
        }
        if (Boolean.TYPE == cls) {
            return 7;
        }
        if (Byte.TYPE == cls) {
            return 9;
        }
        if (Character.TYPE == cls) {
            return 8;
        }
        try {
            clazz8 = Class.forName("java.lang.Integer");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        if (clazz8 == cls) {
            return 106;
        }
        try {
            clazz7 = Class.forName("java.lang.Short");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        if (clazz7 == cls) {
            return 105;
        }
        try {
            clazz6 = Class.forName("java.lang.Float");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        if (clazz6 == cls) {
            return 109;
        }
        try {
            clazz5 = Class.forName("java.lang.Double");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        if (clazz5 == cls) {
            return 108;
        }
        try {
            clazz4 = Class.forName("java.lang.Long");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        if (clazz4 == cls) {
            return 107;
        }
        try {
            clazz3 = Class.forName("java.lang.Boolean");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        if (clazz3 == cls) {
            return 15;
        }
        try {
            clazz2 = Class.forName("java.lang.Byte");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        if (clazz2 == cls) {
            return 17;
        }
        try {
            clazz = Class.forName("java.lang.Character");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        if (clazz == cls) {
            return 16;
        }
        return 0;
    }

    public static Object valueOnly(Object o) {
        return o instanceof ASTNode ? ((ASTNode)o).getLiteralValue() : o;
    }

    public static boolean isNumericallyCoercible(Class target, Class parm) {
        Class boxedTarget;
        Class clazz = boxedTarget = target.isPrimitive() ? ParseTools.boxPrimitive(target) : target;
        if (boxedTarget != null) {
            Class<?> clazz2;
            try {
                clazz2 = Class.forName("java.lang.Number");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            if (clazz2.isAssignableFrom(target)) {
                Class boxedParm;
                Class clazz3 = boxedParm = parm.isPrimitive() ? ParseTools.boxPrimitive(parm) : parm;
                if (boxedParm != null) {
                    Class<?> clazz4;
                    try {
                        clazz4 = Class.forName("java.lang.Number");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    return clazz4.isAssignableFrom(boxedParm);
                }
            }
        }
        return false;
    }

    public static Object handleParserEgress(Object result, boolean returnBigDecimal) {
        if (result instanceof BigDecimal) {
            if (returnBigDecimal) {
                return result;
            }
            if (((BigDecimal)result).scale() > 14) {
                return new Double(((BigDecimal)result).doubleValue());
            }
            if (((BigDecimal)result).scale() > 0) {
                return new Float(((BigDecimal)result).floatValue());
            }
            if (((BigDecimal)result).longValue() > Integer.MAX_VALUE) {
                return new Long(((BigDecimal)result).longValue());
            }
            return new Integer(((BigDecimal)result).intValue());
        }
        return result;
    }

    public static Method determineActualTargetMethod(Method method) {
        String name = method.getName();
        Class<?>[] classArray = method.getDeclaringClass().getInterfaces();
        int n = classArray.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> cls = classArray[n2];
            Method[] methodArray = cls.getMethods();
            int n3 = methodArray.length;
            int n4 = 0;
            while (n4 < n3) {
                Method meth = methodArray[n4];
                if (meth.getParameterTypes().length == 0 && name.equals(meth.getName())) {
                    return meth;
                }
                ++n4;
            }
            ++n2;
        }
        return null;
    }

    public static Object doOperations(Object val1, int operation, Object val2) {
        return MATH_PROCESSOR.doOperation(val1, operation, val2);
    }

    public static Object increment(Object o) {
        if (o instanceof Integer) {
            return new Integer((Integer)o + 1);
        }
        if (o instanceof Double) {
            return new Double((Double)o + 1.0);
        }
        if (o instanceof Float) {
            return new Float(((Float)o).floatValue() + 1.0f);
        }
        if (o instanceof Short) {
            return new Integer((Short)o + 1);
        }
        if (o instanceof Character) {
            return new Integer(((Character)o).charValue() + '\u0001');
        }
        throw new CompileException(new StringBuffer("unable to increment type: ").append(o != null ? o.getClass().getName() : "null").toString());
    }

    public static Map<String, String> parseParameters(char[] parms) {
        HashMap<String, String> allParms = new HashMap<String, String>();
        boolean capture = false;
        int start = 0;
        String parmName = null;
        int i = 0;
        while (i < parms.length) {
            switch (parms[i]) {
                case '=': {
                    parmName = new String(parms, start, ++i - start - 1).trim();
                    capture = true;
                    start = i;
                    break;
                }
                case ',': {
                    if (!capture) break;
                    allParms.put(parmName, new String(parms, start, i - start).trim());
                    start = ++i;
                    capture = false;
                }
            }
            ++i;
        }
        if (capture) {
            allParms.put(parmName, new String(parms, start, i - start).trim());
        }
        return allParms;
    }

    public static int balancedCapture(char[] chars, int start, char type) {
        int depth = 1;
        char term = type;
        switch (type) {
            case '[': {
                term = ']';
                break;
            }
            case '{': {
                term = '}';
                break;
            }
            case '(': {
                term = ')';
            }
        }
        if (type == term) {
            ++start;
            while (start < chars.length) {
                if (chars[start] == type) {
                    return start;
                }
                ++start;
            }
        } else {
            ++start;
            while (start < chars.length) {
                if (chars[start] == '\'' || chars[start] == '\"') {
                    start = ParseTools.captureStringLiteral(chars[start], chars, start, chars.length);
                } else if (chars[start] == type) {
                    ++depth;
                } else if (chars[start] == term && --depth == 0) {
                    return start;
                }
                ++start;
            }
        }
        return -1;
    }

    public static int[] balancedCaptureWithLineAccounting(char[] chars, int start, char type) {
        int depth = 1;
        char term = type;
        switch (type) {
            case '[': {
                term = ']';
                break;
            }
            case '{': {
                term = '}';
                break;
            }
            case '(': {
                term = ')';
            }
        }
        if (type == term) {
            ++start;
            while (start < chars.length) {
                if (chars[start] == type) {
                    int[] nArray = new int[2];
                    nArray[0] = start;
                    return nArray;
                }
                ++start;
            }
        } else {
            int lines = 0;
            ++start;
            while (start < chars.length) {
                if (Character.isWhitespace(chars[start])) {
                    switch (chars[start]) {
                        case '\r': {
                            break;
                        }
                        case '\n': {
                            ++lines;
                        }
                    }
                } else if (chars[start] == '\'' || chars[start] == '\"') {
                    start = ParseTools.captureStringLiteral(chars[start], chars, start, chars.length);
                } else if (chars[start] == type) {
                    ++depth;
                } else if (chars[start] == term && --depth == 0) {
                    return new int[]{start, lines};
                }
                ++start;
            }
        }
        int[] nArray = new int[2];
        nArray[0] = -1;
        return nArray;
    }

    public static String handleStringEscapes(char[] input) {
        int escapes = 0;
        int i = 0;
        while (i < input.length) {
            if (input[i] == '\\') {
                input[i++] = '\u0000';
                input[i] = ParseTools.handleEscapeSequence(input[i]);
                ++escapes;
            }
            ++i;
        }
        char[] processedEscapeString = new char[input.length - escapes];
        int cursor = 0;
        char[] cArray = input;
        int n = input.length;
        int n2 = 0;
        while (n2 < n) {
            char aName = cArray[n2];
            if (aName != '\u0000') {
                processedEscapeString[cursor++] = aName;
            }
            ++n2;
        }
        return new String(processedEscapeString);
    }

    public static int captureStringLiteral(char type, char[] expr, int cursor, int length) {
        while (++cursor < length && expr[cursor] != type) {
            if (expr[cursor] != '\\') continue;
            ParseTools.handleEscapeSequence(expr[++cursor]);
        }
        if (cursor == length || expr[cursor] != type) {
            throw new CompileException("unterminated literal", expr, cursor);
        }
        return cursor;
    }

    public static String getSimpleClassName(Class cls) {
        if (JDK_14_COMPATIBILITY) {
            int lastIndex = cls.getName().lastIndexOf(36);
            if (lastIndex < 0) {
                lastIndex = cls.getName().lastIndexOf(46);
            }
            if (cls.isArray()) {
                return new StringBuffer(String.valueOf(cls.getName().substring(lastIndex + 1))).append("[]").toString();
            }
            return cls.getName().substring(lastIndex + 1);
        }
        return cls.getSimpleName();
    }

    public static void checkNameSafety(String name) {
        if (AbstractParser.isReservedWord(name)) {
            throw new CompileException(new StringBuffer("reserved word in assignment: ").append(name).toString());
        }
    }

    public static FileWriter getDebugFileWriter() throws IOException {
        return new FileWriter(new File(MVEL.getDebuggingOutputFileName()), true);
    }

    public static boolean isPrimitiveWrapper(Class clazz) {
        Class<?> clazz2;
        try {
            clazz2 = Class.forName("java.lang.Integer");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        if (clazz != clazz2) {
            Class<?> clazz3;
            try {
                clazz3 = Class.forName("java.lang.Boolean");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            if (clazz != clazz3) {
                Class<?> clazz4;
                try {
                    clazz4 = Class.forName("java.lang.Long");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                if (clazz != clazz4) {
                    Class<?> clazz5;
                    try {
                        clazz5 = Class.forName("java.lang.Double");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    if (clazz != clazz5) {
                        Class<?> clazz6;
                        try {
                            clazz6 = Class.forName("java.lang.Float");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                        if (clazz != clazz6) {
                            Class<?> clazz7;
                            try {
                                clazz7 = Class.forName("java.lang.Short");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                            if (clazz != clazz7) {
                                Class<?> clazz8;
                                try {
                                    clazz8 = Class.forName("java.lang.Byte");
                                }
                                catch (ClassNotFoundException classNotFoundException) {
                                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                }
                                if (clazz != clazz8) {
                                    Class<?> clazz9;
                                    try {
                                        clazz9 = Class.forName("java.lang.Character");
                                    }
                                    catch (ClassNotFoundException classNotFoundException) {
                                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                    }
                                    if (clazz != clazz9) {
                                        return false;
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return true;
    }

    public static Serializable subCompileExpression(String expression) {
        return ParseTools.optimizeTree(new ExpressionCompiler(expression)._compile());
    }

    public static Serializable subCompileExpression(char[] expression) {
        return ParseTools.optimizeTree(new ExpressionCompiler(expression)._compile());
    }

    public static Serializable optimizeTree(CompiledExpression compiled) {
        ASTIterator nodes = compiled.getTokens();
        if (MVEL.isOptimizationEnabled() && nodes.size() == 1) {
            ASTNode tk = nodes.firstNode();
            if (tk.isLiteral() && !tk.isThisVal()) {
                if ((tk.getFields() & 0x800000) != 0) {
                    return new ExecutableLiteral(tk.getIntRegister());
                }
                return new ExecutableLiteral(tk.getLiteralValue());
            }
            if (tk.isIdentifier()) {
                return new ExecutableAccessor(tk, false);
            }
        }
        return compiled;
    }
}

