/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Properties;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import org.jgroups.Event;
import org.jgroups.Header;
import org.jgroups.Message;
import org.jgroups.stack.Protocol;
import org.jgroups.util.Streamable;

public class COMPRESS
extends Protocol {
    Deflater[] deflater_pool = null;
    Inflater[] inflater_pool = null;
    int compression_level = 9;
    long min_size = 500L;
    int pool_size = 2;
    private int inflater_index = 0;
    private int deflater_index = 0;
    static final String name = "COMPRESS";

    public String getName() {
        return name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int getInflaterIndex() {
        COMPRESS cOMPRESS = this;
        synchronized (cOMPRESS) {
            int retval = this.inflater_index++;
            if (this.inflater_index >= this.pool_size) {
                this.inflater_index = 0;
            }
            return retval;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int getDeflaterIndex() {
        COMPRESS cOMPRESS = this;
        synchronized (cOMPRESS) {
            int retval = this.deflater_index++;
            if (this.deflater_index >= this.pool_size) {
                this.deflater_index = 0;
            }
            return retval;
        }
    }

    public void init() throws Exception {
        int i;
        this.deflater_pool = new Deflater[this.pool_size];
        for (i = 0; i < this.deflater_pool.length; ++i) {
            this.deflater_pool[i] = new Deflater(this.compression_level);
        }
        this.inflater_pool = new Inflater[this.pool_size];
        for (i = 0; i < this.inflater_pool.length; ++i) {
            this.inflater_pool[i] = new Inflater();
        }
    }

    public void destroy() {
        int i;
        for (i = 0; i < this.deflater_pool.length; ++i) {
            Deflater deflater = this.deflater_pool[i];
            deflater.end();
        }
        for (i = 0; i < this.inflater_pool.length; ++i) {
            Inflater inflater = this.inflater_pool[i];
            inflater.end();
        }
    }

    public boolean setProperties(Properties props) {
        super.setProperties(props);
        String str = props.getProperty("compression_level");
        if (str != null) {
            this.compression_level = Integer.parseInt(str);
            props.remove("compression_level");
        }
        if ((str = props.getProperty("min_size")) != null) {
            this.min_size = Long.parseLong(str);
            props.remove("min_size");
        }
        if ((str = props.getProperty("pool_size")) != null) {
            this.pool_size = Integer.parseInt(str);
            if (this.pool_size <= 0) {
                this.log.warn((Object)"pool_size must be > 0, setting it to 1");
                this.pool_size = 1;
            }
            props.remove("pool_size");
        }
        if (props.size() > 0) {
            this.log.error((Object)("the following properties are not recognized: " + props));
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void down(Event evt) {
        Message msg;
        int length;
        if (evt.getType() == 1 && (long)(length = (msg = (Message)evt.getArg()).getLength()) >= this.min_size) {
            int compressed_size;
            Deflater deflater;
            byte[] payload = msg.getRawBuffer();
            byte[] compressed_payload = new byte[length];
            int tmp_index = this.getDeflaterIndex();
            Deflater deflater2 = deflater = this.deflater_pool[tmp_index];
            synchronized (deflater2) {
                deflater.reset();
                deflater.setInput(payload, msg.getOffset(), length);
                deflater.finish();
                deflater.deflate(compressed_payload);
                compressed_size = deflater.getTotalOut();
            }
            byte[] new_payload = new byte[compressed_size];
            System.arraycopy(compressed_payload, 0, new_payload, 0, compressed_size);
            msg.setBuffer(new_payload);
            msg.putHeader(name, new CompressHeader(length));
            if (this.trace) {
                this.log.trace((Object)("compressed payload from " + length + " bytes to " + compressed_size + " bytes (inflater #" + tmp_index + ")"));
            }
        }
        this.passDown(evt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void up(Event evt) {
        byte[] compressed_payload;
        Message msg;
        CompressHeader hdr;
        if (evt.getType() == 1 && (hdr = (CompressHeader)(msg = (Message)evt.getArg()).removeHeader(name)) != null && (compressed_payload = msg.getRawBuffer()) != null && compressed_payload.length > 0) {
            Inflater inflater;
            int original_size = hdr.original_size;
            byte[] uncompressed_payload = new byte[original_size];
            int tmp_index = this.getInflaterIndex();
            Inflater inflater2 = inflater = this.inflater_pool[tmp_index];
            synchronized (inflater2) {
                block7: {
                    inflater.reset();
                    inflater.setInput(compressed_payload, msg.getOffset(), msg.getLength());
                    try {
                        inflater.inflate(uncompressed_payload);
                        if (this.trace) {
                            this.log.trace((Object)("uncompressed " + compressed_payload.length + " bytes to " + original_size + " bytes (deflater #" + tmp_index + ")"));
                        }
                        msg.setBuffer(uncompressed_payload);
                    }
                    catch (DataFormatException e) {
                        if (!this.log.isErrorEnabled()) break block7;
                        this.log.error((Object)"exception on uncompression", (Throwable)e);
                    }
                }
            }
        }
        this.passUp(evt);
    }

    public static class CompressHeader
    extends Header
    implements Streamable {
        int original_size = 0;

        public CompressHeader() {
        }

        public CompressHeader(int s) {
            this.original_size = s;
        }

        public long size() {
            return 4L;
        }

        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeInt(this.original_size);
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.original_size = in.readInt();
        }

        public void writeTo(DataOutputStream out) throws IOException {
            out.writeInt(this.original_size);
        }

        public void readFrom(DataInputStream in) throws IOException, IllegalAccessException, InstantiationException {
            this.original_size = in.readInt();
        }
    }
}

