/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.embedded.adapters;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.UserTransaction;
import org.jboss.ejb3.tx.TxUtil;
import org.jboss.logging.Logger;

public final class LocalOnlyUserTransaction
implements UserTransaction,
Externalizable {
    private static final long serialVersionUID = -5998336139321082314L;
    protected static Logger log = Logger.getLogger(LocalOnlyUserTransaction.class);
    private boolean trace = log.isTraceEnabled();
    private TransactionManager tm;

    public void start() {
        if (this.trace) {
            log.trace((Object)("new UserTx: " + this));
        }
        this.tm = TxUtil.getTransactionManager();
    }

    public void stop() {
        this.tm = null;
    }

    public void begin() throws NotSupportedException, SystemException {
        this.tm.begin();
        Transaction tx = this.tm.getTransaction();
        if (this.trace) {
            log.trace((Object)("UserTx begin: " + tx));
        }
    }

    public void commit() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, IllegalStateException, SystemException {
        Transaction tx = this.tm.getTransaction();
        if (this.trace) {
            log.trace((Object)("UserTx commit: " + tx));
        }
        this.tm.commit();
    }

    public void rollback() throws IllegalStateException, SecurityException, SystemException {
        Transaction tx = this.tm.getTransaction();
        if (this.trace) {
            log.trace((Object)("UserTx rollback: " + tx));
        }
        this.tm.rollback();
    }

    public void setRollbackOnly() throws IllegalStateException, SystemException {
        Transaction tx = this.tm.getTransaction();
        if (this.trace) {
            log.trace((Object)("UserTx setRollbackOnly: " + tx));
        }
        this.tm.setRollbackOnly();
    }

    public int getStatus() throws SystemException {
        return this.tm.getStatus();
    }

    public void setTransactionTimeout(int seconds) throws SystemException {
        this.tm.setTransactionTimeout(seconds);
    }

    public void writeExternal(ObjectOutput out) throws IOException {
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.tm = TxUtil.getTransactionManager();
    }
}

