/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.xb.builder;

import java.util.Collections;
import java.util.HashSet;
import org.jboss.config.plugins.property.PropertyConfiguration;
import org.jboss.config.spi.Configuration;
import org.jboss.reflect.spi.ClassInfo;
import org.jboss.reflect.spi.PackageInfo;
import org.jboss.reflect.spi.TypeInfo;
import org.jboss.xb.annotations.JBossXmlSchema;
import org.jboss.xb.binding.metadata.PackageMetaData;
import org.jboss.xb.binding.sunday.unmarshalling.SchemaBinding;
import org.jboss.xb.binding.sunday.unmarshalling.SchemaBindingInitializer;
import org.jboss.xb.builder.BuilderSchemaBindingInitializer;
import org.jboss.xb.builder.JBossXBNoSchemaBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JBossXBBuilder {
    static Configuration configuration = new PropertyConfiguration();
    static final ClassInfo STRING = configuration.getClassInfo(String.class);
    static final ClassInfo OBJECT = configuration.getClassInfo(Object.class);

    public static <T> SchemaBindingInitializer newInitializer(Class<T> root) {
        return new BuilderSchemaBindingInitializer<T>(root);
    }

    public static void build(SchemaBinding schemaBinding, Class<?> root) {
        if (schemaBinding == null) {
            throw new IllegalArgumentException("Null schemaBinding");
        }
        if (root == null) {
            throw new IllegalArgumentException("Null root");
        }
    }

    public static SchemaBinding build(Class<?> root) {
        ClassInfo classInfo = configuration.getClassInfo(root);
        SchemaBinding binding = classInfo.getAttachment(SchemaBinding.class);
        if (binding == null) {
            JBossXBNoSchemaBuilder builder = new JBossXBNoSchemaBuilder(classInfo);
            binding = builder.build();
            classInfo.setAttachment(SchemaBinding.class.getName(), binding);
        }
        return binding;
    }

    protected static void initSchema(SchemaBinding schemaBinding, ClassInfo classInfo) {
        JBossXmlSchema schema = classInfo.getUnderlyingAnnotation(JBossXmlSchema.class);
        PackageInfo packageInfo = classInfo.getPackage();
        if (schema == null && packageInfo != null) {
            schema = packageInfo.getUnderlyingAnnotation(JBossXmlSchema.class);
        }
        String packageName = null;
        if (packageInfo != null) {
            packageName = packageInfo.getName();
        }
        if (schema != null) {
            String schemaPackageName = schema.packageName();
            if (!"##default".equals(schemaPackageName)) {
                packageName = schemaPackageName;
            }
            if (schema.xmlns().length > 0) {
                for (int i = 0; i < schema.xmlns().length; ++i) {
                    schemaBinding.addPrefixMapping(schema.xmlns()[i].prefix(), schema.xmlns()[i].namespaceURI());
                }
            }
        }
        if (schemaBinding.getNamespaces().isEmpty()) {
            String schemaNamespace;
            String namespace = "";
            if (schema != null && !"##default".equals(schemaNamespace = schema.namespace())) {
                namespace = schemaNamespace;
            }
            schemaBinding.setNamespaces(new HashSet<String>(Collections.singleton(namespace)));
        }
        if (packageName != null) {
            PackageMetaData packageMetaData = new PackageMetaData();
            packageMetaData.setName(packageName);
            schemaBinding.setPackageMetaData(packageMetaData);
        }
        if (schema == null) {
            return;
        }
        schemaBinding.setIgnoreUnresolvedFieldOrClass(schema.ignoreUnresolvedFieldOrClass());
        schemaBinding.setIgnoreLowLine(schema.ignoreLowLine());
        schemaBinding.setReplacePropertyRefs(schema.replacePropertyRefs());
        schemaBinding.setStrictSchema(schema.strict());
    }

    public static String generateXMLNameFromClassName(TypeInfo typeInfo, boolean ignoreLowerLine) {
        return JBossXBBuilder.generateXMLNameFromJavaName(typeInfo.getSimpleName(), true, ignoreLowerLine);
    }

    public static String generateXMLNameFromJavaName(String string, boolean dash, boolean ignoreLowerLine) {
        boolean seenLower = false;
        boolean first = true;
        StringBuilder result = new StringBuilder(string.length());
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (first || !seenLower && Character.isUpperCase(c)) {
                result.append(Character.toLowerCase(c));
                first = false;
                continue;
            }
            if (seenLower && Character.isUpperCase(c) && dash) {
                result.append('-');
                result.append(Character.toLowerCase(c));
                seenLower = false;
                continue;
            }
            result.append(c);
            seenLower = true;
        }
        return result.toString();
    }
}

