/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.stack.jbws;

import java.io.IOException;
import javax.management.ObjectName;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.ws.WebServiceException;
import org.jboss.logging.Logger;
import org.jboss.ws.metadata.umdm.ServerEndpointMetaData;
import org.jboss.wsf.common.ObjectNameFactory;
import org.jboss.wsf.spi.SPIProvider;
import org.jboss.wsf.spi.SPIProviderResolver;
import org.jboss.wsf.spi.deployment.Deployment;
import org.jboss.wsf.spi.deployment.Endpoint;
import org.jboss.wsf.spi.invocation.EndpointAssociation;
import org.jboss.wsf.spi.invocation.RequestHandler;
import org.jboss.wsf.spi.management.EndpointRegistry;
import org.jboss.wsf.spi.management.EndpointRegistryFactory;
import org.jboss.wsf.stack.jbws.WebAppResolver;

public class EndpointServlet
extends HttpServlet {
    private static final Logger log = Logger.getLogger(EndpointServlet.class);
    protected Endpoint endpoint;
    protected EndpointRegistry epRegistry;

    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
        SPIProvider spiProvider = SPIProviderResolver.getInstance().getProvider();
        this.epRegistry = spiProvider.getSPI(EndpointRegistryFactory.class).getEndpointRegistry();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void service(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        if (this.endpoint == null) {
            String contextPath = req.getContextPath();
            this.initServiceEndpoint(contextPath);
        }
        try {
            EndpointAssociation.setEndpoint(this.endpoint);
            RequestHandler requestHandler = this.endpoint.getRequestHandler();
            requestHandler.handleHttpRequest(this.endpoint, req, res, this.getServletContext());
        }
        finally {
            EndpointAssociation.removeEndpoint();
        }
    }

    protected void initServiceEndpoint(String contextPath) {
        this.initEndpoint(contextPath, this.getServletName());
        this.initEndpointConfig();
        this.startEndpoint();
    }

    private void startEndpoint() {
        Deployment dep = this.endpoint.getService().getDeployment();
        if ((dep.getType() == Deployment.DeploymentType.JAXRPC_JSE || dep.getType() == Deployment.DeploymentType.JAXWS_JSE) && this.endpoint.getState() == Endpoint.EndpointState.CREATED) {
            this.endpoint.getLifecycleHandler().start(this.endpoint);
        }
    }

    private void initEndpointConfig() {
        ServletContext ctx = this.getServletContext();
        String configName = ctx.getInitParameter("jbossws-config-name");
        String configFile = ctx.getInitParameter("jbossws-config-file");
        if (configName != null || configFile != null) {
            ServerEndpointMetaData epMetaData = this.endpoint.getAttachment(ServerEndpointMetaData.class);
            if (epMetaData == null) {
                throw new IllegalStateException("Cannot obtain endpoint meta data");
            }
            log.debug("Updating service endpoint config\n  config-name: " + configName + "\n  config-file: " + configFile);
            epMetaData.setConfigName(configName, configFile);
        }
    }

    private void initEndpoint(String contextPath, String servletName) {
        WebAppResolver resolver = new WebAppResolver(contextPath, servletName);
        this.endpoint = this.epRegistry.resolve(resolver);
        if (this.endpoint == null) {
            ObjectName oname = ObjectNameFactory.create((String)("jboss.ws:context=" + contextPath + "," + "endpoint" + "=" + this.getServletName()));
            throw new WebServiceException("Cannot obtain endpoint for: " + oname);
        }
    }
}

