/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.extensions.xop.jaxrpc;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.activation.DataHandler;
import javax.xml.namespace.QName;
import javax.xml.soap.AttachmentPart;
import javax.xml.soap.SOAPException;
import org.jboss.logging.Logger;
import org.jboss.ws.WSException;
import org.jboss.ws.core.soap.attachment.ContentHandlerRegistry;
import org.jboss.ws.extensions.xop.XOPContext;
import org.jboss.xb.binding.sunday.xop.XOPObject;
import org.jboss.xb.binding.sunday.xop.XOPUnmarshaller;

public class XOPUnmarshallerImpl
implements XOPUnmarshaller {
    private static final Logger log = Logger.getLogger(XOPUnmarshallerImpl.class);
    private static final QName XOP_INCLUDE = new QName("http://www.w3.org/2004/08/xop/include", "Include");

    public boolean isXOPPackage() {
        return XOPContext.isXOPMessage();
    }

    public XOPObject getAttachmentAsDataHandler(String cid) {
        try {
            AttachmentPart part = XOPContext.getAttachmentByCID(cid);
            DataHandler dataHandler = part.getDataHandler();
            String contentType = dataHandler.getContentType();
            XOPObject xopObject = new XOPObject(dataHandler);
            xopObject.setContentType(contentType);
            return xopObject;
        }
        catch (SOAPException e) {
            throw new WSException("Failed to access attachment part", e);
        }
    }

    public byte[] getAttachmentAsByteArray(String cid) {
        try {
            AttachmentPart part = XOPContext.getAttachmentByCID(cid);
            DataHandler dh = part.getDataHandler();
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            dh.writeTo((OutputStream)bout);
            return bout.toByteArray();
        }
        catch (SOAPException ex) {
            throw new WSException(ex);
        }
        catch (IOException e) {
            throw new WSException(e);
        }
    }

    static {
        ContentHandlerRegistry.register();
    }
}

