/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.web.deployers;

import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.LinkRef;
import javax.naming.NamingException;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.deployers.structure.spi.main.MainDeployerStructure;
import org.jboss.deployers.vfs.spi.structure.VFSDeploymentUnit;
import org.jboss.ejb.EjbUtil50;
import org.jboss.logging.Logger;
import org.jboss.metadata.javaee.spec.EJBLocalReferenceMetaData;
import org.jboss.metadata.javaee.spec.EJBLocalReferencesMetaData;
import org.jboss.metadata.javaee.spec.EJBReferenceMetaData;
import org.jboss.metadata.javaee.spec.EJBReferencesMetaData;
import org.jboss.metadata.javaee.spec.EnvironmentEntriesMetaData;
import org.jboss.metadata.javaee.spec.EnvironmentEntryMetaData;
import org.jboss.metadata.javaee.spec.MessageDestinationMetaData;
import org.jboss.metadata.javaee.spec.MessageDestinationReferenceMetaData;
import org.jboss.metadata.javaee.spec.MessageDestinationReferencesMetaData;
import org.jboss.metadata.javaee.spec.ResourceEnvironmentReferenceMetaData;
import org.jboss.metadata.javaee.spec.ResourceEnvironmentReferencesMetaData;
import org.jboss.metadata.javaee.spec.ResourceReferenceMetaData;
import org.jboss.metadata.javaee.spec.ResourceReferencesMetaData;
import org.jboss.metadata.javaee.spec.ServiceReferenceMetaData;
import org.jboss.metadata.javaee.spec.ServiceReferencesMetaData;
import org.jboss.metadata.serviceref.ServiceReferenceHandler;
import org.jboss.metadata.serviceref.VirtualFileAdaptor;
import org.jboss.metadata.web.jboss.JBossWebMetaData;
import org.jboss.mx.loading.LoaderRepositoryFactory;
import org.jboss.naming.NonSerializableFactory;
import org.jboss.naming.Util;
import org.jboss.security.AuthorizationManager;
import org.jboss.security.SecurityUtil;
import org.jboss.security.authorization.PolicyRegistration;
import org.jboss.web.WebApplication;
import org.jboss.web.deployers.AbstractWarDeployer;
import org.omg.CORBA.ORB;

public abstract class AbstractWarDeployment {
    public static final String ERROR = "org.jboss.web.AbstractWebContainer.error";
    protected Logger log = Logger.getLogger(this.getClass());
    protected MBeanServer server;
    protected MainDeployerStructure mainDeployer;
    protected boolean java2ClassLoadingCompliance = false;
    protected boolean unpackWars = true;
    protected boolean lenientEjbLink = false;
    protected String defaultSecurityDomain;

    public static String shortWarUrlFromServerHome(String warUrl) {
        String serverHomeUrl = System.getProperty("jboss.server.home.url");
        if (warUrl == null || serverHomeUrl == null) {
            return warUrl;
        }
        if (warUrl.startsWith(serverHomeUrl)) {
            return ".../" + warUrl.substring(serverHomeUrl.length());
        }
        return warUrl;
    }

    public abstract void init(Object var1) throws Exception;

    public MBeanServer getServer() {
        return this.server;
    }

    public void setServer(MBeanServer server) {
        this.server = server;
    }

    public MainDeployerStructure getMainDeployer() {
        return this.mainDeployer;
    }

    public void setMainDeployer(MainDeployerStructure mainDeployer) {
        this.mainDeployer = mainDeployer;
    }

    public boolean getJava2ClassLoadingCompliance() {
        return this.java2ClassLoadingCompliance;
    }

    public void setJava2ClassLoadingCompliance(boolean flag) {
        this.java2ClassLoadingCompliance = flag;
    }

    public boolean getUnpackWars() {
        return this.unpackWars;
    }

    public void setUnpackWars(boolean flag) {
        this.unpackWars = flag;
    }

    public boolean getLenientEjbLink() {
        return this.lenientEjbLink;
    }

    public void setLenientEjbLink(boolean flag) {
        this.lenientEjbLink = flag;
    }

    public String getDefaultSecurityDomain() {
        if (this.defaultSecurityDomain == null) {
            throw new IllegalStateException("Default Security Domain is null");
        }
        return this.defaultSecurityDomain;
    }

    public void setDefaultSecurityDomain(String defaultSecurityDomain) {
        this.defaultSecurityDomain = defaultSecurityDomain;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized WebApplication start(VFSDeploymentUnit unit, JBossWebMetaData metaData) throws Exception {
        Thread thread = Thread.currentThread();
        ClassLoader appClassLoader = thread.getContextClassLoader();
        WebApplication webApp = null;
        try {
            String warURLString;
            URL[] empty = new URL[]{};
            URLClassLoader warLoader = URLClassLoader.newInstance(empty, unit.getClassLoader());
            thread.setContextClassLoader(warLoader);
            String webContext = metaData.getContextRoot();
            URL warURL = unit.getAttachment("org.jboss.web.expandedWarURL", URL.class);
            if (warURL == null) {
                warURL = unit.getAttachment("jbossws.expanded.war.url", URL.class);
            }
            if (warURL == null) {
                warURL = unit.getRoot().toURL();
            }
            if ((warURLString = warURL.toString()).startsWith("jar:")) {
                warURLString = warURLString.substring(4, warURLString.length() - 2);
            }
            this.log.debug("webContext: " + webContext);
            this.log.debug("warURL: " + warURLString);
            String contextID = metaData.getJaccContextID();
            if (contextID == null) {
                contextID = unit.getSimpleName();
            }
            metaData.setJaccContextID(contextID);
            webApp = new WebApplication(metaData);
            webApp.setClassLoader(warLoader);
            webApp.setDeploymentUnit(unit);
            this.performDeploy(webApp, warURLString);
        }
        finally {
            thread.setContextClassLoader(appClassLoader);
        }
        return webApp;
    }

    public synchronized void stop(DeploymentUnit di, WebApplication webApp) throws Exception {
        URL warURL = webApp.getURL();
        String warUrl = warURL.toString();
        this.performUndeploy(webApp, warUrl);
        JBossWebMetaData metaData = webApp.getMetaData();
        String contextID = metaData.getJaccContextID();
        String prefixedSecurityDomain = webApp.getMetaData().getSecurityDomain();
        if (prefixedSecurityDomain != null) {
            String unPrefixedDomain = SecurityUtil.unprefixSecurityDomain(prefixedSecurityDomain);
            InitialContext ic = new InitialContext();
            String amCtx = "java:/jaas/" + unPrefixedDomain + "/authorizationMgr";
            AuthorizationManager authzmgr = (AuthorizationManager)ic.lookup(amCtx);
            if (authzmgr instanceof PolicyRegistration) {
                PolicyRegistration xam = (PolicyRegistration)((Object)authzmgr);
                xam.deRegisterPolicy(contextID);
            }
        }
    }

    protected abstract void performDeploy(WebApplication var1, String var2) throws Exception;

    protected abstract void performUndeploy(WebApplication var1, String var2) throws Exception;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processEnc(ClassLoader loader, WebApplication webApp) throws Exception {
        if (loader == null) {
            throw new IllegalArgumentException("Classloader passed to process ENC refs is null");
        }
        this.log.debug("AbstractWebContainer.parseWebAppDescriptors, Begin");
        InitialContext iniCtx = new InitialContext();
        Context envCtx = null;
        Thread currentThread = Thread.currentThread();
        ClassLoader currentLoader = currentThread.getContextClassLoader();
        JBossWebMetaData metaData = webApp.getMetaData();
        try {
            this.log.debug("Creating ENC using ClassLoader: " + loader);
            for (ClassLoader parent = loader.getParent(); parent != null; parent = parent.getParent()) {
                this.log.debug(".." + parent);
            }
            currentThread.setContextClassLoader(loader);
            envCtx = (Context)iniCtx.lookup("java:comp");
            ORB orb = null;
            try {
                ObjectName ORB_NAME = new ObjectName("jboss:service=CorbaORB");
                orb = (ORB)this.server.getAttribute(ORB_NAME, "ORB");
                if (orb != null) {
                    NonSerializableFactory.rebind(envCtx, "ORB", orb);
                    this.log.debug("Bound java:comp/ORB");
                }
            }
            catch (Throwable t) {
                this.log.debug("Unable to retrieve orb" + t.toString());
            }
            envCtx.bind("UserTransaction", (Object)new LinkRef("UserTransaction"));
            this.log.debug("Linked java:comp/UserTransaction to JNDI name: UserTransaction");
            envCtx = envCtx.createSubcontext("env");
            this.processEncReferences(webApp, envCtx);
        }
        finally {
            currentThread.setContextClassLoader(currentLoader);
        }
        String securityDomain = metaData.getSecurityDomain();
        this.log.debug("linkSecurityDomain");
        this.linkSecurityDomain(securityDomain, envCtx);
        this.log.debug("AbstractWebContainer.parseWebAppDescriptors, End");
    }

    protected void processEncReferences(WebApplication webApp, Context envCtx) throws ClassNotFoundException, NamingException {
        VFSDeploymentUnit unit = webApp.getDeploymentUnit();
        JBossWebMetaData metaData = webApp.getMetaData();
        EnvironmentEntriesMetaData envEntries = metaData.getEnvironmentEntries();
        this.log.debug("addEnvEntries");
        this.addEnvEntries(envEntries, envCtx);
        ResourceEnvironmentReferencesMetaData resourceEnvRefs = metaData.getResourceEnvironmentReferences();
        this.log.debug("linkResourceEnvRefs");
        this.linkResourceEnvRefs(resourceEnvRefs, envCtx);
        ResourceReferencesMetaData resourceRefs = metaData.getResourceReferences();
        this.log.debug("linkResourceRefs");
        this.linkResourceRefs(resourceRefs, envCtx);
        this.log.debug("linkMessageDestinationRefs");
        MessageDestinationReferencesMetaData msgRefs = metaData.getMessageDestinationReferences();
        this.linkMessageDestinationRefs(unit, msgRefs, envCtx);
        EJBReferencesMetaData ejbRefs = metaData.getEjbReferences();
        this.log.debug("linkEjbRefs");
        this.linkEjbRefs(unit, ejbRefs, envCtx);
        EJBLocalReferencesMetaData ejbLocalRefs = metaData.getEjbLocalReferences();
        this.log.debug("linkEjbLocalRefs");
        this.linkEjbLocalRefs(unit, ejbLocalRefs, envCtx);
        this.log.debug("linkServiceRefs");
        ServiceReferencesMetaData serviceRefs = metaData.getServiceReferences();
        this.linkServiceRefs(unit, serviceRefs, envCtx);
    }

    private void linkServiceRefs(VFSDeploymentUnit unit, ServiceReferencesMetaData serviceRefs, Context envCtx) throws NamingException {
        ClassLoader loader = unit.getClassLoader();
        VirtualFileAdaptor vfsRoot = new VirtualFileAdaptor(unit.getRoot());
        for (ServiceReferenceMetaData sref : serviceRefs) {
            String refName = sref.getServiceRefName();
            new ServiceReferenceHandler().bindServiceRef(envCtx, refName, vfsRoot, loader, sref);
        }
    }

    protected void addEnvEntries(EnvironmentEntriesMetaData envEntries, Context envCtx) throws ClassNotFoundException, NamingException {
        for (EnvironmentEntryMetaData entry : envEntries) {
            this.log.debug("Binding env-entry: " + entry.getName() + " of type: " + entry.getType() + " to value:" + entry.getValue());
            AbstractWarDeployment.bindEnvEntry(envCtx, entry);
        }
    }

    protected void linkResourceEnvRefs(ResourceEnvironmentReferencesMetaData resourceEnvRefs, Context envCtx) throws NamingException {
        for (ResourceEnvironmentReferenceMetaData ref : resourceEnvRefs) {
            String resourceName = ref.getJndiName();
            String refName = ref.getResourceEnvRefName();
            if (ref.getType().equals("java.net.URL")) {
                try {
                    this.log.debug("Binding '" + refName + "' to URL: " + resourceName);
                    URL url = new URL(resourceName);
                    Util.bind(envCtx, refName, (Object)url);
                    continue;
                }
                catch (MalformedURLException e) {
                    throw new NamingException("Malformed URL:" + e.getMessage());
                }
            }
            if (resourceName != null) {
                this.log.debug("Linking '" + refName + "' to JNDI name: " + resourceName);
                Util.bind(envCtx, refName, (Object)new LinkRef(resourceName));
                continue;
            }
            throw new NamingException("resource-env-ref: " + refName + " has no valid JNDI binding. Check the jboss-web/resource-env-ref.");
        }
    }

    protected void linkResourceRefs(ResourceReferencesMetaData resourceRefs, Context envCtx) throws NamingException {
        for (ResourceReferenceMetaData ref : resourceRefs) {
            String jndiName = ref.getJndiName();
            String refName = ref.getResourceName();
            if (ref.getType().equals("java.net.URL")) {
                try {
                    String resURL = ref.getResUrl();
                    if (resURL != null) {
                        this.log.debug("Binding '" + refName + "' to URL: " + resURL);
                        URL url = new URL(resURL);
                        Util.bind(envCtx, refName, (Object)url);
                        continue;
                    }
                    this.log.debug("Linking '" + refName + "' to URL: " + resURL);
                    LinkRef urlLink = new LinkRef(jndiName);
                    Util.bind(envCtx, refName, (Object)urlLink);
                    continue;
                }
                catch (MalformedURLException e) {
                    throw new NamingException("Malformed URL:" + e.getMessage());
                }
            }
            if (jndiName != null) {
                this.log.debug("Linking '" + refName + "' to JNDI name: " + jndiName);
                Util.bind(envCtx, refName, (Object)new LinkRef(jndiName));
                continue;
            }
            throw new NamingException("resource-ref: " + refName + " has no valid JNDI binding. Check the jboss-web/resource-ref.");
        }
    }

    protected void linkMessageDestinationRefs(DeploymentUnit unit, MessageDestinationReferencesMetaData msgRefs, Context envCtx) throws NamingException {
        for (MessageDestinationReferenceMetaData ref : msgRefs) {
            String refName = ref.getName();
            String jndiName = ref.getJndiName();
            String link = ref.getLink();
            if (link != null) {
                if (jndiName == null) {
                    MessageDestinationMetaData messageDestination = EjbUtil50.findMessageDestination(this.mainDeployer, unit, link);
                    if (messageDestination == null) {
                        throw new NamingException("message-destination-ref '" + refName + "' message-destination-link '" + link + "' not found and no jndi-name in jboss-web.xml");
                    }
                    String linkJNDIName = messageDestination.getJndiName();
                    if (linkJNDIName == null) {
                        this.log.warn("message-destination '" + link + "' has no jndi-name in jboss-web.xml");
                    } else {
                        jndiName = linkJNDIName;
                    }
                } else {
                    this.log.warn("message-destination-ref '" + refName + "' ignoring message-destination-link '" + link + "' because it has a jndi-name in jboss-web.xml");
                }
            } else if (jndiName == null) {
                throw new NamingException("message-destination-ref '" + refName + "' has no message-destination-link in web.xml and no jndi-name in jboss-web.xml");
            }
            Util.bind(envCtx, refName, (Object)new LinkRef(jndiName));
        }
    }

    protected void linkEjbRefs(DeploymentUnit unit, EJBReferencesMetaData ejbRefs, Context envCtx) throws NamingException {
        for (EJBReferenceMetaData ejb : ejbRefs) {
            String name = ejb.getName();
            String linkName = ejb.getLink();
            String jndiName = null;
            if (linkName != null && (jndiName = EjbUtil50.findEjbLink(this.mainDeployer, unit, linkName)) == null && !this.getLenientEjbLink()) {
                throw new NamingException("ejb-ref: " + name + ", no ejb-link match");
            }
            if (jndiName == null && (jndiName = ejb.getJndiName()) == null) {
                throw new NamingException("ejb-ref: " + name + ", no ejb-link in web.xml and no jndi-name in jboss-web.xml");
            }
            this.log.debug("Linking ejb-ref: " + name + " to JNDI name: " + jndiName);
            Util.bind(envCtx, name, (Object)new LinkRef(jndiName));
        }
    }

    protected void linkEjbLocalRefs(DeploymentUnit unit, EJBLocalReferencesMetaData ejbLocalRefs, Context envCtx) throws NamingException {
        for (EJBLocalReferenceMetaData ejb : ejbLocalRefs) {
            String name = ejb.getName();
            String linkName = ejb.getLink();
            String jndiName = null;
            if (linkName != null && (jndiName = EjbUtil50.findLocalEjbLink(this.mainDeployer, unit, linkName)) == null && !this.getLenientEjbLink()) {
                throw new NamingException("ejb-ref: " + name + ", no ejb-link match");
            }
            if (jndiName == null && (jndiName = ejb.getJndiName()) == null) {
                String msg = null;
                msg = linkName == null ? "ejb-local-ref: '" + name + "', no ejb-link in web.xml and " + "no local-jndi-name in jboss-web.xml" : "ejb-local-ref: '" + name + "', with web.xml ejb-link: '" + linkName + "' failed to resolve to an ejb with a LocalHome";
                throw new NamingException(msg);
            }
            this.log.debug("Linking ejb-local-ref: " + name + " to JNDI name: " + jndiName);
            Util.bind(envCtx, name, (Object)new LinkRef(jndiName));
        }
    }

    protected void linkSecurityDomain(String securityDomain, Context envCtx) throws NamingException {
        if (securityDomain == null) {
            securityDomain = this.getDefaultSecurityDomain();
            this.log.debug("No security-domain given, using default: " + securityDomain);
        }
        this.log.debug("Linking security/securityMgr to JNDI name: " + securityDomain);
        Util.bind(envCtx, "security/securityMgr", (Object)new LinkRef(securityDomain));
        Util.bind(envCtx, "security/realmMapping", (Object)new LinkRef(securityDomain + "/realmMapping"));
        Util.bind(envCtx, "security/authorizationMgr", (Object)new LinkRef(securityDomain + "/authorizationMgr"));
        Util.bind(envCtx, "security/security-domain", (Object)new LinkRef(securityDomain));
        Util.bind(envCtx, "security/subject", (Object)new LinkRef(securityDomain + "/subject"));
    }

    public String[] getStandardCompileClasspath(ClassLoader loader) {
        String[] jspResources = new String[]{"javax/servlet/resources/web-app_2_3.dtd", "org/apache/jasper/resources/jsp12.dtd", "javax/ejb/EJBHome.class"};
        ArrayList<String> tmp = new ArrayList<String>();
        for (int j = 0; j < jspResources.length; ++j) {
            URL rsrcURL = loader.getResource(jspResources[j]);
            if (rsrcURL != null) {
                String url = rsrcURL.toExternalForm();
                if (rsrcURL.getProtocol().equals("jar")) {
                    url = url.substring(4);
                    int seperator = url.indexOf(33);
                    url = url.substring(0, seperator);
                }
                tmp.add(url);
                continue;
            }
            this.log.warn("Failed to fin jsp rsrc: " + jspResources[j]);
        }
        this.log.trace("JSP StandardCompileClasspath: " + tmp);
        String[] cp = new String[tmp.size()];
        tmp.toArray(cp);
        return cp;
    }

    public String[] getCompileClasspath(ClassLoader loader) {
        HashSet tmp = new HashSet();
        for (ClassLoader cl = loader; cl != null; cl = cl.getParent()) {
            URL[] urls = AbstractWarDeployer.getClassLoaderURLs(cl);
            this.addURLs(tmp, urls);
        }
        try {
            URL[] globalUrls = (URL[])this.server.getAttribute(LoaderRepositoryFactory.DEFAULT_LOADER_REPOSITORY, "URLs");
            this.addURLs(tmp, globalUrls);
        }
        catch (Exception e) {
            this.log.warn("Could not get global URL[] from default loader repository!", e);
        }
        this.log.trace("JSP CompileClasspath: " + tmp);
        String[] cp = new String[tmp.size()];
        tmp.toArray(cp);
        return cp;
    }

    private void addURLs(Set urlSet, URL[] urls) {
        for (int u = 0; u < urls.length; ++u) {
            URL url = urls[u];
            urlSet.add(url.toExternalForm());
        }
    }

    public static void bindEnvEntry(Context ctx, EnvironmentEntryMetaData entry) throws ClassNotFoundException, NamingException {
        ClassLoader loader = EnvironmentEntryMetaData.class.getClassLoader();
        Class<?> type = loader.loadClass(entry.getType());
        if (type == String.class) {
            Util.bind(ctx, entry.getName(), (Object)entry.getValue());
        } else if (type == Integer.class) {
            Util.bind(ctx, entry.getName(), (Object)new Integer(entry.getValue()));
        } else if (type == Long.class) {
            Util.bind(ctx, entry.getName(), (Object)new Long(entry.getValue()));
        } else if (type == Double.class) {
            Util.bind(ctx, entry.getName(), (Object)new Double(entry.getValue()));
        } else if (type == Float.class) {
            Util.bind(ctx, entry.getName(), (Object)new Float(entry.getValue()));
        } else if (type == Byte.class) {
            Util.bind(ctx, entry.getName(), (Object)new Byte(entry.getValue()));
        } else if (type == Character.class) {
            Character value = null;
            String input = entry.getValue();
            value = input == null || input.length() == 0 ? new Character('\u0000') : new Character(input.charAt(0));
            Util.bind(ctx, entry.getName(), (Object)value);
        } else if (type == Short.class) {
            Util.bind(ctx, entry.getName(), (Object)new Short(entry.getValue()));
        } else if (type == Boolean.class) {
            Util.bind(ctx, entry.getName(), (Object)new Boolean(entry.getValue()));
        } else {
            Util.bind(ctx, entry.getName(), (Object)entry.getValue());
        }
    }
}

