/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.system.server.profileservice.hotdeploy;

import java.util.Collection;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.jboss.deployers.client.spi.main.MainDeployer;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.deployers.structure.spi.main.MainDeployerStructure;
import org.jboss.deployers.vfs.spi.client.VFSDeployment;
import org.jboss.kernel.spi.dependency.KernelController;
import org.jboss.logging.Logger;
import org.jboss.managed.api.ManagedDeployment;
import org.jboss.profileservice.spi.ModificationInfo;
import org.jboss.profileservice.spi.Profile;
import org.jboss.profileservice.spi.ProfileService;

public class HDScanner
implements Runnable {
    private static final Logger log = Logger.getLogger(HDScanner.class);
    private MainDeployer mainDeployer;
    private KernelController controller;
    private ProfileService profileService;
    private ScheduledExecutorService scanExecutor;
    private ScheduledFuture activeScan;
    private String scanThreadName = "HDScanner";
    private long scanPeriod = 5000L;
    private int scanCount;

    public void setMainDeployer(MainDeployer deployer) {
        this.mainDeployer = deployer;
    }

    public KernelController getController() {
        return this.controller;
    }

    public void setController(KernelController controller) {
        this.controller = controller;
    }

    public ProfileService getProfileService() {
        return this.profileService;
    }

    public void setProfileService(ProfileService profileService) {
        this.profileService = profileService;
    }

    public ScheduledExecutorService getScanExecutor() {
        return this.scanExecutor;
    }

    public void setScanExecutor(ScheduledExecutorService scanExecutor) {
        this.scanExecutor = scanExecutor;
    }

    public String getScanThreadName() {
        return this.scanThreadName;
    }

    public void setScanThreadName(String scanThreadName) {
        this.scanThreadName = scanThreadName;
    }

    public long getScanPeriod() {
        return this.scanPeriod;
    }

    public void setScanPeriod(long period) {
        this.scanPeriod = period;
    }

    public boolean isScanEnabled() {
        return this.activeScan != null;
    }

    public synchronized int getScanCount() {
        return this.scanCount;
    }

    public synchronized void resetScanCount() {
        this.scanCount = 0;
    }

    public synchronized void setScanEnabled(boolean scanEnabled) {
        if (scanEnabled && this.activeScan == null) {
            this.activeScan = this.scanExecutor.scheduleWithFixedDelay(this, 0L, this.scanPeriod, TimeUnit.MILLISECONDS);
        } else if (!scanEnabled && this.activeScan != null) {
            this.activeScan.cancel(true);
            this.activeScan = null;
        }
    }

    public void start() throws Exception {
        if (this.scanExecutor == null) {
            this.scanExecutor = Executors.newSingleThreadScheduledExecutor(new ThreadFactory(){

                public Thread newThread(Runnable r) {
                    return new Thread(r, HDScanner.this.getScanThreadName());
                }
            });
        }
        this.activeScan = this.scanExecutor.scheduleWithFixedDelay(this, 0L, this.scanPeriod, TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            this.scan();
        }
        catch (Throwable e) {
            log.warn("Scan failed", e);
        }
        finally {
            this.incScanCount();
        }
    }

    public void stop() {
        if (this.activeScan != null) {
            this.activeScan.cancel(true);
            this.activeScan = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void scan() throws Exception {
        boolean trace;
        block16: {
            Profile activeProfile;
            trace = log.isTraceEnabled();
            if (trace) {
                log.trace("Begin deployment scan");
            }
            if ((activeProfile = this.profileService.getActiveProfile()) == null) {
                if (trace) {
                    log.trace("End deployment scan, no activeProfile");
                }
                return;
            }
            Collection<ModificationInfo> modified = activeProfile.getModifiedDeployments();
            for (ModificationInfo info : modified) {
                VFSDeployment ctx = info.getDeployment();
                switch (info.getStatus()) {
                    case ADDED: {
                        this.mainDeployer.addDeployment(ctx);
                        break;
                    }
                    case MODIFIED: {
                        this.mainDeployer.addDeployment(ctx);
                        break;
                    }
                    case REMOVED: {
                        this.mainDeployer.removeDeployment(ctx.getName());
                    }
                }
            }
            try {
                if (modified.size() <= 0) break block16;
                ClassLoader oldTCL = Thread.currentThread().getContextClassLoader();
                ClassLoader tcl = this.getTCL(activeProfile);
                try {
                    if (tcl != null) {
                        Thread.currentThread().setContextClassLoader(tcl);
                    }
                    this.mainDeployer.process();
                    this.mainDeployer.checkComplete();
                }
                finally {
                    Thread.currentThread().setContextClassLoader(oldTCL);
                }
            }
            catch (Exception e) {
                log.warn("Failed to process changes", e);
                return;
            }
        }
        if (trace) {
            log.trace("End deployment scan");
        }
    }

    protected synchronized void incScanCount() {
        ++this.scanCount;
        this.notifyAll();
    }

    private ClassLoader getTCL(Profile activeProfile) throws Exception {
        MainDeployerStructure structure = (MainDeployerStructure)((Object)this.mainDeployer);
        Collection<VFSDeployment> ctxs = activeProfile.getDeployments(ManagedDeployment.DeploymentPhase.BOOTSTRAP);
        if (ctxs != null && !ctxs.isEmpty()) {
            for (VFSDeployment deployment : ctxs) {
                DeploymentUnit unit = structure.getDeploymentUnit(deployment.getName());
                if (unit == null) continue;
                try {
                    ClassLoader cl = unit.getClassLoader();
                    if (cl == null) continue;
                    return cl;
                }
                catch (Exception ignored) {
                }
            }
        }
        log.warn("No bootstrap deployments? profile=" + activeProfile);
        return null;
    }
}

