/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.plugins;

import java.io.CharArrayWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import org.jboss.logging.Logger;

public class TmpFilePassword {
    private static Logger log = Logger.getLogger(TmpFilePassword.class);
    private File passwordFile;

    public TmpFilePassword(String file) {
        this.passwordFile = new File(file);
    }

    public char[] toCharArray() throws IOException {
        int b;
        while (!this.passwordFile.exists()) {
            log.info("Waiting for password file: " + this.passwordFile.getAbsolutePath());
            try {
                Thread.sleep(10000L);
            }
            catch (InterruptedException e) {
                log.info("Exiting wait on InterruptedException");
                break;
            }
        }
        FileInputStream fis = new FileInputStream(this.passwordFile);
        CharArrayWriter writer = new CharArrayWriter();
        while ((b = fis.read()) >= 0) {
            if (b == 13 || b == 10) continue;
            writer.write(b);
        }
        fis.close();
        char[] password = writer.toCharArray();
        writer.reset();
        for (int n = 0; n < password.length; ++n) {
            writer.write(0);
        }
        try {
            RandomAccessFile raf = new RandomAccessFile(this.passwordFile, "rws");
            for (int i = 0; i < 10; ++i) {
                raf.seek(0L);
                for (int j = 0; j < password.length; ++j) {
                    raf.write(j);
                }
            }
            raf.close();
            if (!this.passwordFile.delete()) {
                log.warn("Was not able to delete the password file");
            }
        }
        catch (Exception e) {
            log.warn("Failed to zero the password file", e);
        }
        return password;
    }
}

