/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resource.deployers.management;

import java.io.Serializable;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import org.jboss.managed.api.Fields;
import org.jboss.managed.plugins.DefaultFieldsImpl;
import org.jboss.managed.plugins.ManagedObjectImpl;
import org.jboss.managed.plugins.ManagedPropertyImpl;
import org.jboss.metatype.api.types.MetaType;
import org.jboss.metatype.api.types.MetaTypeFactory;
import org.jboss.metatype.api.types.SimpleMetaType;
import org.jboss.profileservice.management.plugins.BasicDeploymentTemplateInfo;
import org.jboss.resource.metadata.mcf.DBMSMetaData;
import org.jboss.resource.metadata.mcf.LocalDataSourceDeploymentMetaData;
import org.jboss.resource.metadata.mcf.NoTxConnectionFactoryDeploymentMetaData;
import org.jboss.resource.metadata.mcf.NoTxDataSourceDeploymentMetaData;
import org.jboss.resource.metadata.mcf.TxConnectionFactoryDeploymentMetaData;
import org.jboss.resource.metadata.mcf.XADataSourceDeploymentMetaData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DsDataSourceTemplateInfo
extends BasicDeploymentTemplateInfo {
    private static final long serialVersionUID = 1L;
    private static final MetaTypeFactory METATYPE_FACTORY = MetaTypeFactory.getInstance();
    private Map<String, String> propertyNameMappings;
    private String dsType = "local-tx-datasource";
    private transient Type mapType;
    private transient Type mapOfMapsType;

    public DsDataSourceTemplateInfo(String name, String description, String datasourceType) {
        super(name, description);
        this.dsType = datasourceType;
    }

    public Map<String, String> getPropertyNameMappings() {
        return this.propertyNameMappings;
    }

    public void setPropertyNameMappings(Map<String, String> propertyNameMappings) {
        this.propertyNameMappings = propertyNameMappings;
    }

    public String getConnectionFactoryType() {
        return this.dsType;
    }

    public void setConnectionFactoryType(String dsType) {
        this.dsType = dsType;
    }

    public void start() {
        if ("local-tx-datasource".equals(this.dsType)) {
            this.createLocalTxDsTemplate();
        } else if ("xa-datasource".equals(this.dsType)) {
            this.createXaDsTemplate();
        } else if ("tx-connection-factory".equals(this.dsType)) {
            this.createTxCfTemplate();
        } else if ("no-tx-datasource".equals(this.dsType)) {
            this.createNoTxDsTemplate();
        } else if ("no-tx-connection-factory".equals(this.dsType)) {
            this.createNoTxCfTemplate();
        } else {
            throw new IllegalStateException("Unsupported dsType: " + this.dsType);
        }
    }

    private void createXaDsTemplate() {
        ManagedObjectImpl mo = new ManagedObjectImpl(XADataSourceDeploymentMetaData.class.getName());
        this.addDsProperties(mo);
        this.addManagedProperty("xa-datasource-class", "The xa datasource class name", true, SimpleMetaType.STRING, mo);
        this.addManagedProperty("xa-datasource-properties", "The xa datasource properties", false, METATYPE_FACTORY.resolve(this.getMapType()), mo);
        this.addManagedProperty("url-property", "The URL property", true, SimpleMetaType.STRING, mo);
        this.addManagedProperty("xa-resource-timeout", "The XA resource timeout", true, SimpleMetaType.INTEGER, new Integer(0), mo);
    }

    private void createLocalTxDsTemplate() {
        ManagedObjectImpl mo = new ManagedObjectImpl(LocalDataSourceDeploymentMetaData.class.getName());
        this.addNonXADsProperties(mo);
    }

    private void createNoTxDsTemplate() {
        ManagedObjectImpl mo = new ManagedObjectImpl(NoTxDataSourceDeploymentMetaData.class.getName());
        this.addNonXADsProperties(mo);
    }

    private void createTxCfTemplate() {
        ManagedObjectImpl mo = new ManagedObjectImpl(TxConnectionFactoryDeploymentMetaData.class.getName());
        this.addCommonProperties(mo);
        this.addManagedProperty("xa-resource-timeout", "The XA resource timeout", true, SimpleMetaType.INTEGER, new Integer(0), mo);
        this.addManagedProperty("xa-transaction", "", true, SimpleMetaType.BOOLEAN, mo);
    }

    private void createNoTxCfTemplate() {
        ManagedObjectImpl mo = new ManagedObjectImpl(NoTxConnectionFactoryDeploymentMetaData.class.getName());
        this.addCommonProperties(mo);
    }

    private void addNonXADsProperties(ManagedObjectImpl mo) {
        this.addDsProperties(mo);
        this.addManagedProperty("driver-class", "The jdbc driver class name", true, SimpleMetaType.STRING, mo);
        this.addManagedProperty("connection-url", "The jdbc url of the DataSource", true, SimpleMetaType.STRING, mo);
        this.addManagedProperty("connection-properties", "The jdbc driver connection properties", false, METATYPE_FACTORY.resolve((Type)((Object)List.class)), mo);
    }

    private void addDsProperties(ManagedObjectImpl mo) {
        this.addCommonProperties(mo);
        this.addManagedProperty("transaction-isolation", "The transaction isolation level", false, SimpleMetaType.STRING, mo);
        this.addManagedProperty("user-name", "The username for the connection-url", false, SimpleMetaType.STRING, mo);
        this.addManagedProperty("password", "The password for the connection-url", false, SimpleMetaType.STRING, mo);
        this.addManagedProperty("new-connection-sql", "", false, SimpleMetaType.STRING, mo);
        this.addManagedProperty("check-valid-connection-sql", "", false, SimpleMetaType.STRING, mo);
        this.addManagedProperty("valid-connection-checker-class-name", "", false, SimpleMetaType.STRING, mo);
        this.addManagedProperty("exception-sorter-class-name", "", false, SimpleMetaType.STRING, mo);
        this.addManagedProperty("stale-connection-checker-class-name", "", false, SimpleMetaType.STRING, mo);
        this.addManagedProperty("track-statements", "", false, SimpleMetaType.STRING, mo);
        this.addManagedProperty("prepared-statement-cache-size", "", false, SimpleMetaType.INTEGER, new Integer(0), mo);
        this.addManagedProperty("share-prepared-statements", "", false, SimpleMetaType.BOOLEAN, Boolean.FALSE, mo);
        this.addManagedProperty("set-tx-query-timeout", "", false, SimpleMetaType.BOOLEAN, Boolean.FALSE, mo);
        this.addManagedProperty("query-timeout", "", false, SimpleMetaType.INTEGER, new Integer(0), mo);
        this.addManagedProperty("url-delimiter", "", false, SimpleMetaType.STRING, mo);
        this.addManagedProperty("url-selector-strategy-class-name", "", false, SimpleMetaType.STRING, mo);
    }

    private void addCommonProperties(ManagedObjectImpl mo) {
        this.addManagedProperty("jndi-name", "The jndi name to bind the DataSource under", true, SimpleMetaType.STRING, mo);
        this.addManagedProperty("rar-name", "The resource adapter archive name", true, SimpleMetaType.STRING, mo);
        this.addManagedProperty("use-java-context", "Whether to bind the connection factory under 'java:' context", true, SimpleMetaType.BOOLEAN, Boolean.TRUE, mo);
        this.addManagedProperty("connection-definition", "The connection factory class name", true, SimpleMetaType.STRING, mo);
        this.addManagedProperty("jmx-invoker-name", "The name of the JMX invoker", true, SimpleMetaType.STRING, mo);
        this.addManagedProperty("min-pool-size", "The min size of the pool", true, SimpleMetaType.INTEGER, new Integer(0), mo);
        this.addManagedProperty("max-pool-size", "The max size of the pool", true, SimpleMetaType.INTEGER, new Integer(10), mo);
        this.addManagedProperty("blocking-timeout-millis", "The time to wait for a connection to become available before giving up", true, SimpleMetaType.LONG, new Long(30000L), mo);
        this.addManagedProperty("idle-timeout-minutes", "The idle timeout in minutes", true, SimpleMetaType.INTEGER, new Integer(30), mo);
        this.addManagedProperty("prefill", "Whether to prefill the pool", true, SimpleMetaType.BOOLEAN, mo);
        this.addManagedProperty("background-validation", "Whether to use backgroup validation", true, SimpleMetaType.BOOLEAN, Boolean.FALSE, mo);
        this.addManagedProperty("background-validation-minutes", "", false, SimpleMetaType.INTEGER, new Integer(0), mo);
        this.addManagedProperty("validate-on-match", "", true, SimpleMetaType.BOOLEAN, Boolean.TRUE, mo);
        this.addManagedProperty("use-strict-min", "", true, SimpleMetaType.BOOLEAN, mo);
        this.addManagedProperty("noTxSeparatePools", "", true, SimpleMetaType.BOOLEAN, mo);
        this.addManagedProperty("statistics-formatter", "", true, SimpleMetaType.STRING, mo);
        this.addManagedProperty("isSameRM-override-value", "", true, SimpleMetaType.BOOLEAN, mo);
        this.addManagedProperty("track-connection-by-tx", "", true, SimpleMetaType.BOOLEAN, mo);
        this.addManagedProperty("config-property", "The connection factory config properties", false, METATYPE_FACTORY.resolve(this.getMapOfMapsType()), mo);
        this.addManagedProperty("security-domain", "The security-domain used to validate connections", false, SimpleMetaType.STRING, mo);
        this.addManagedProperty("depends", "", false, METATYPE_FACTORY.resolve((Type)((Object)List.class)), mo);
        this.addManagedProperty("metadata", "", false, METATYPE_FACTORY.resolve((Type)((Object)DBMSMetaData.class)), mo);
        this.addManagedProperty("type-mapping", "", true, SimpleMetaType.STRING, mo);
        this.addManagedProperty("local-transaction", "", true, SimpleMetaType.BOOLEAN, mo);
    }

    private void addManagedProperty(String fieldName, String fieldDescr, boolean mandatory, MetaType metaType, ManagedObjectImpl mo) {
        this.addManagedProperty(fieldName, fieldDescr, mandatory, metaType, null, mo);
    }

    private void addManagedProperty(String fieldName, String fieldDescr, boolean mandatory, MetaType metaType, Serializable value, ManagedObjectImpl mo) {
        DefaultFieldsImpl fields = new DefaultFieldsImpl();
        this.setFieldName(fieldName, fields);
        fields.setDescription(fieldDescr);
        fields.setMandatory(mandatory);
        fields.setMetaType(metaType);
        ManagedPropertyImpl mp = new ManagedPropertyImpl(mo, fields);
        super.addProperty(mp);
        if (value != null) {
            mp.setValue(value);
        }
    }

    protected void setFieldName(String name, Fields f) {
        String mappedName;
        f.setField("name", (Serializable)((Object)name));
        if (this.propertyNameMappings != null && (mappedName = this.propertyNameMappings.get(name)) != null) {
            f.setField("mappedName", (Serializable)((Object)mappedName));
        }
    }

    private Type getMapOfMapsType() {
        if (this.mapOfMapsType == null) {
            try {
                this.mapOfMapsType = this.getClass().getMethod("mapOfMaps", new Class[0]).getGenericReturnType();
            }
            catch (NoSuchMethodException e) {
                throw new IllegalStateException("Failed to find compoditeValueMap method.");
            }
        }
        return this.mapOfMapsType;
    }

    private Type getMapType() {
        if (this.mapType == null) {
            try {
                this.mapType = this.getClass().getMethod("compositeValueMap", new Class[0]).getGenericReturnType();
            }
            catch (NoSuchMethodException e) {
                throw new IllegalStateException("Failed to find compoditeValueMap method.");
            }
        }
        return this.mapType;
    }

    public Map<String, String> compositeValueMap() {
        return null;
    }

    public Map<String, Map<String, String>> mapOfMaps() {
        return null;
    }
}

