/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resource.connectionmanager;

import EDU.oswego.cs.dl.util.concurrent.FIFOSemaphore;
import EDU.oswego.cs.dl.util.concurrent.SynchronizedBoolean;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ManagedConnectionFactory;
import javax.resource.spi.ValidatingManagedConnectionFactory;
import javax.security.auth.Subject;
import org.jboss.logging.Logger;
import org.jboss.resource.JBossResourceException;
import org.jboss.resource.connectionmanager.ConnectionListener;
import org.jboss.resource.connectionmanager.ConnectionListenerFactory;
import org.jboss.resource.connectionmanager.ConnectionValidator;
import org.jboss.resource.connectionmanager.IdleConnectionRemovalSupport;
import org.jboss.resource.connectionmanager.IdleRemover;
import org.jboss.resource.connectionmanager.PoolFiller;
import org.jboss.util.UnreachableStatementException;

public class InternalManagedConnectionPool
implements IdleConnectionRemovalSupport {
    private final ManagedConnectionFactory mcf;
    private final ConnectionListenerFactory clf;
    private final Subject defaultSubject;
    private final ConnectionRequestInfo defaultCri;
    private final PoolParams poolParams;
    private int maxSize;
    private ArrayList cls;
    private final FIFOSemaphore permits;
    private final Logger log;
    private final boolean trace;
    private final Counter connectionCounter = new Counter();
    private final HashSet checkedOut = new HashSet();
    private boolean started = false;
    private SynchronizedBoolean shutdown = new SynchronizedBoolean(false);
    private volatile int maxUsedConnections = 0;

    protected InternalManagedConnectionPool(ManagedConnectionFactory mcf, ConnectionListenerFactory clf, Subject subject, ConnectionRequestInfo cri, PoolParams poolParams, Logger log) {
        this.mcf = mcf;
        this.clf = clf;
        this.defaultSubject = subject;
        this.defaultCri = cri;
        this.poolParams = poolParams;
        this.maxSize = poolParams.maxSize;
        this.log = log;
        this.trace = log.isTraceEnabled();
        this.cls = new ArrayList(this.maxSize);
        this.permits = new FIFOSemaphore((long)this.maxSize);
        if (poolParams.prefill) {
            PoolFiller.fillPool(this);
        }
    }

    protected void initialize() {
        if (this.poolParams.idleTimeout != 0L) {
            IdleRemover.registerPool(this, this.poolParams.idleTimeout);
        }
        if (this.poolParams.backgroundValidation) {
            this.log.debug("Registering for background validation at interval " + this.poolParams.backgroundInterval);
            ConnectionValidator.registerPool(this, this.poolParams.backgroundInterval);
        }
    }

    public long getAvailableConnections() {
        return this.permits.permits();
    }

    public int getMaxConnectionsInUseCount() {
        return this.maxUsedConnections;
    }

    public int getConnectionInUseCount() {
        return this.checkedOut.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConnectionListener getConnection(Subject subject, ConnectionRequestInfo cri) throws ResourceException {
        subject = subject == null ? this.defaultSubject : subject;
        cri = cri == null ? this.defaultCri : cri;
        long startWait = System.currentTimeMillis();
        try {
            this.connectionCounter.updateBlockTime(System.currentTimeMillis() - startWait);
            if (this.permits.attempt((long)this.poolParams.blockingTimeout)) {
                int size2;
                ConnectionListener cl = null;
                do {
                    ArrayList size2;
                    ArrayList arrayList = this.cls;
                    synchronized (arrayList) {
                        if (this.shutdown.get()) {
                            this.permits.release();
                            throw new ResourceException("The pool has been shutdown");
                        }
                        if (this.cls.size() > 0) {
                            cl = (ConnectionListener)this.cls.remove(this.cls.size() - 1);
                            this.checkedOut.add(cl);
                            size2 = (int)((long)this.maxSize - this.permits.permits());
                            if (size2 > this.maxUsedConnections) {
                                this.maxUsedConnections = size2;
                            }
                        }
                    }
                    if (cl == null) continue;
                    try {
                        ManagedConnection matchedMC = this.mcf.matchManagedConnections(Collections.singleton(cl.getManagedConnection()), subject, cri);
                        if (matchedMC != null) {
                            if (this.trace) {
                                this.log.trace("supplying ManagedConnection from pool: " + cl);
                            }
                            cl.grantPermit(true);
                            return cl;
                        }
                        this.log.warn("Destroying connection that could not be successfully matched: " + cl);
                        size2 = this.cls;
                        synchronized (size2) {
                            this.checkedOut.remove(cl);
                        }
                        this.doDestroy(cl);
                        cl = null;
                    }
                    catch (Throwable t) {
                        this.log.warn("Throwable while trying to match ManagedConnection, destroying connection: " + cl, t);
                        size2 = this.cls;
                        synchronized (size2) {
                            this.checkedOut.remove(cl);
                        }
                        this.doDestroy(cl);
                        cl = null;
                    }
                    if (!this.poolParams.useFastFail) continue;
                    this.log.trace("Fast failing for connection attempt. No more attempts will be made to acquire connection from pool and a new connection will be created immeadiately");
                    break;
                } while (this.cls.size() > 0);
                try {
                    cl = this.createConnectionEventListener(subject, cri);
                    ArrayList t = this.cls;
                    synchronized (t) {
                        this.checkedOut.add(cl);
                        size2 = (int)((long)this.maxSize - this.permits.permits());
                        if (size2 > this.maxUsedConnections) {
                            this.maxUsedConnections = size2;
                        }
                    }
                    if (!this.started) {
                        this.started = true;
                        if (this.poolParams.minSize > 0) {
                            PoolFiller.fillPool(this);
                        }
                    }
                    if (this.trace) {
                        this.log.trace("supplying new ManagedConnection: " + cl);
                    }
                    cl.grantPermit(true);
                    return cl;
                }
                catch (Throwable t) {
                    this.log.warn("Throwable while attempting to get a new connection: " + cl, t);
                    ArrayList arrayList = this.cls;
                    synchronized (arrayList) {
                        this.checkedOut.remove(cl);
                    }
                    this.permits.release();
                    JBossResourceException.rethrowAsResourceException("Unexpected throwable while trying to create a connection: " + cl, t);
                    throw new UnreachableStatementException();
                }
            }
            throw new ResourceException("No ManagedConnections available within configured blocking timeout ( " + this.poolParams.blockingTimeout + " [ms] )");
        }
        catch (InterruptedException ie) {
            long end = System.currentTimeMillis() - startWait;
            throw new ResourceException("Interrupted while requesting permit! Waited " + end + " ms");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void returnConnection(ConnectionListener cl, boolean kill) {
        ArrayList arrayList = this.cls;
        synchronized (arrayList) {
            if (cl.getState() == 2) {
                if (this.trace) {
                    this.log.trace("ManagedConnection is being returned after it was destroyed" + cl);
                }
                if (cl.hasPermit()) {
                    cl.grantPermit(false);
                    this.permits.release();
                }
                return;
            }
        }
        if (this.trace) {
            this.log.trace("putting ManagedConnection back into pool kill=" + kill + " cl=" + cl);
        }
        try {
            cl.getManagedConnection().cleanup();
        }
        catch (ResourceException re) {
            this.log.warn("ResourceException cleaning up ManagedConnection: " + cl, re);
            kill = true;
        }
        arrayList = this.cls;
        synchronized (arrayList) {
            if (cl.getState() == 1 || cl.getState() == 2) {
                kill = true;
            }
            this.checkedOut.remove(cl);
            if (!kill && this.cls.size() >= this.poolParams.maxSize) {
                this.log.warn("Destroying returned connection, maximum pool size exceeded " + cl);
                kill = true;
            }
            if (kill) {
                this.cls.remove(cl);
            } else {
                cl.used();
                if (!this.cls.contains(cl)) {
                    this.cls.add(cl);
                }
            }
            if (cl.hasPermit()) {
                cl.grantPermit(false);
                this.permits.release();
            }
        }
        if (kill) {
            if (this.trace) {
                this.log.trace("Destroying returned connection " + cl);
            }
            this.doDestroy(cl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() {
        ConnectionListener cl;
        ArrayList<ConnectionListener> destroy = null;
        ArrayList arrayList = this.cls;
        synchronized (arrayList) {
            if (this.trace) {
                this.log.trace("Flushing pool checkedOut=" + this.checkedOut + " inPool=" + this.cls);
            }
            for (ConnectionListener cl2 : this.checkedOut) {
                if (this.trace) {
                    this.log.trace("Flush marking checked out connection for destruction " + cl2);
                }
                cl2.setState(1);
            }
            while (this.cls.size() > 0) {
                cl = (ConnectionListener)this.cls.remove(0);
                if (destroy == null) {
                    destroy = new ArrayList<ConnectionListener>();
                }
                destroy.add(cl);
            }
        }
        if (destroy != null) {
            for (int i = 0; i < destroy.size(); ++i) {
                cl = (ConnectionListener)destroy.get(i);
                if (this.trace) {
                    this.log.trace("Destroying flushed connection " + cl);
                }
                this.doDestroy(cl);
            }
            if (!this.shutdown.get() && this.poolParams.minSize > 0) {
                PoolFiller.fillPool(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeIdleConnections() {
        ConnectionListener cl;
        ArrayList<ConnectionListener> destroy = null;
        long timeout = System.currentTimeMillis() - this.poolParams.idleTimeout;
        while (true) {
            ArrayList arrayList = this.cls;
            synchronized (arrayList) {
                if (this.cls.size() == 0) {
                    break;
                }
                cl = (ConnectionListener)this.cls.get(0);
                if (cl.isTimedOut(timeout) && this.shouldRemove()) {
                    this.connectionCounter.incTimedOut();
                    this.cls.remove(0);
                    if (destroy == null) {
                        destroy = new ArrayList<ConnectionListener>();
                    }
                } else {
                    break;
                }
                destroy.add(cl);
            }
        }
        if (destroy != null) {
            for (int i = 0; i < destroy.size(); ++i) {
                cl = (ConnectionListener)destroy.get(i);
                if (this.trace) {
                    this.log.trace("Destroying timedout connection " + cl);
                }
                this.doDestroy(cl);
            }
            if (!this.shutdown.get() && this.poolParams.minSize > 0) {
                PoolFiller.fillPool(this);
            }
        }
    }

    public void shutdownWithoutClear() {
        IdleRemover.unregisterPool(this);
        IdleRemover.waitForBackgroundThread();
        ConnectionValidator.unRegisterPool(this);
        ConnectionValidator.waitForBackgroundThread();
        this.fillToMin();
        this.shutdown.set(true);
    }

    public void shutdown() {
        this.shutdown.set(true);
        IdleRemover.unregisterPool(this);
        ConnectionValidator.unRegisterPool(this);
        this.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fillToMin() {
        while (true) {
            try {
                while (true) {
                    if (!this.permits.attempt((long)this.poolParams.blockingTimeout)) {
                        continue;
                    }
                    try {
                        if (this.shutdown.get()) {
                            return;
                        }
                        if (this.getMinSize() - this.connectionCounter.getGuaranteedCount() <= 0) {
                            return;
                        }
                        try {
                            ConnectionListener cl = this.createConnectionEventListener(this.defaultSubject, this.defaultCri);
                            ArrayList arrayList = this.cls;
                            synchronized (arrayList) {
                                if (this.trace) {
                                    this.log.trace("Filling pool cl=" + cl);
                                }
                                this.cls.add(cl);
                                continue;
                            }
                        }
                        catch (ResourceException re) {
                            this.log.warn("Unable to fill pool ", re);
                            this.permits.release();
                            return;
                        }
                    }
                    finally {
                        this.permits.release();
                        continue;
                    }
                    break;
                }
            }
            catch (InterruptedException ignored) {
                this.log.trace("Interrupted while requesting permit in fillToMin");
                continue;
            }
            break;
        }
    }

    public int getConnectionCount() {
        return this.connectionCounter.getCount();
    }

    public long getTotalBlockTime() {
        return this.connectionCounter.getTotalBlockTime();
    }

    public int getTimedOut() {
        return this.connectionCounter.getTimedOut();
    }

    public long getAverageBlockTime() {
        return this.connectionCounter.getTotalBlockTime() / (long)this.getConnectionCreatedCount();
    }

    public int getConnectionCreatedCount() {
        return this.connectionCounter.getCreatedCount();
    }

    public int getConnectionDestroyedCount() {
        return this.connectionCounter.getDestroyedCount();
    }

    private ConnectionListener createConnectionEventListener(Subject subject, ConnectionRequestInfo cri) throws ResourceException {
        ManagedConnection mc = this.mcf.createManagedConnection(subject, cri);
        this.connectionCounter.inc();
        try {
            return this.clf.createConnectionListener(mc, this);
        }
        catch (ResourceException re) {
            this.connectionCounter.dec();
            mc.destroy();
            throw re;
        }
    }

    private void doDestroy(ConnectionListener cl) {
        if (cl.getState() == 2) {
            this.log.trace("ManagedConnection is already destroyed " + cl);
            return;
        }
        this.connectionCounter.dec();
        cl.setState(2);
        try {
            cl.getManagedConnection().destroy();
        }
        catch (Throwable t) {
            this.log.warn("Exception destroying ManagedConnection " + cl, t);
        }
    }

    private boolean shouldRemove() {
        boolean remove = true;
        if (this.poolParams.stictMin) {
            remove = this.cls.size() > this.poolParams.minSize;
            this.log.trace("StrictMin is active. Current connection will be removed is " + remove);
        }
        return remove;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void validateConnections() throws Exception {
        if (this.trace) {
            this.log.trace("Attempting to  validate connections for pool " + this);
        }
        if (this.permits.attempt((long)this.poolParams.blockingTimeout) == false) return;
        destroyed = false;
        while (true) lbl-1000:
        // 6 sources

        {
            cl = null;
            var3_3 = this.cls;
            synchronized (var3_3) {
                if (this.cls.size() == 0) {
                    return;
                }
                cl = this.removeForFrequencyCheck();
                ** if (cl != null) goto lbl15
            }
lbl14:
            // 1 sources

            return;
lbl15:
            // 1 sources

            try {
                candidateSet = Collections.singleton(cl.getManagedConnection());
                if (this.mcf instanceof ValidatingManagedConnectionFactory) {
                    vcf = (ValidatingManagedConnectionFactory)this.mcf;
                    if ((candidateSet = vcf.getInvalidConnections(candidateSet)) == null || candidateSet.size() <= 0 || cl.getState() == 1) ** GOTO lbl-1000
                    this.doDestroy(cl);
                    destroyed = true;
                }
                this.log.warn("warning: background validation was specified with a non compliant ManagedConnectionFactory interface.");
            }
            finally {
                if (destroyed) ** GOTO lbl-1000
                var3_3 = this.cls;
                synchronized (var3_3) {
                    this.returnForFrequencyCheck(cl);
                }
                continue;
            }
            break;
        }
        ** GOTO lbl-1000
        finally {
            this.permits.release();
            if (destroyed && !this.shutdown.get() && this.poolParams.minSize > 0) {
                PoolFiller.fillPool(this);
            }
        }
    }

    private ConnectionListener removeForFrequencyCheck() {
        this.log.debug("Checking for connection within frequency");
        ConnectionListener cl2 = null;
        for (ConnectionListener cl2 : this.cls) {
            long lastCheck = cl2.getLastValidatedTime();
            if (System.currentTimeMillis() - lastCheck >= this.poolParams.backgroundInterval) {
                this.cls.remove(cl2);
                break;
            }
            cl2 = null;
        }
        return cl2;
    }

    private void returnForFrequencyCheck(ConnectionListener cl) {
        this.log.debug("Returning for connection within frequency");
        cl.setLastValidatedTime(System.currentTimeMillis());
        this.cls.add(cl);
    }

    private int getMinSize() {
        if (this.poolParams.minSize > this.maxSize) {
            return this.maxSize;
        }
        return this.poolParams.minSize;
    }

    private static class Counter {
        private int created = 0;
        private int destroyed = 0;
        private long totalBlockTime;
        private int timedOut;

        private Counter() {
        }

        synchronized int getGuaranteedCount() {
            return this.created - this.destroyed;
        }

        int getCount() {
            return this.created - this.destroyed;
        }

        int getCreatedCount() {
            return this.created;
        }

        int getDestroyedCount() {
            return this.destroyed;
        }

        synchronized void inc() {
            ++this.created;
        }

        synchronized void dec() {
            ++this.destroyed;
        }

        synchronized void updateBlockTime(long latest) {
            this.totalBlockTime += latest;
        }

        long getTotalBlockTime() {
            return this.totalBlockTime;
        }

        int getTimedOut() {
            return this.timedOut;
        }

        synchronized void incTimedOut() {
            ++this.timedOut;
        }
    }

    public static class PoolParams {
        public int minSize = 0;
        public int maxSize = 10;
        public int blockingTimeout = 30000;
        public long idleTimeout = 1800000L;
        public boolean backgroundValidation;
        public long backgroundInterval = 600000L;
        public boolean prefill;
        public boolean stictMin;
        public boolean useFastFail;
    }
}

