/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.profileservice.mock.ds;

import java.util.List;
import java.util.Properties;
import javax.naming.Context;
import javax.naming.InitialContext;
import org.jboss.logging.Logger;
import org.jboss.profileservice.mock.ds.DataSourceDeployment;
import org.jboss.profileservice.mock.ds.FakeDataSourceConnMBean;
import org.jboss.profileservice.mock.ds.MockDataSource;
import org.jboss.util.naming.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FakeDataSourceConn
implements FakeDataSourceConnMBean {
    private static Logger log = Logger.getLogger(FakeDataSourceConn.class);
    private DataSourceDeployment ds;
    private MockDataSource dsConn;

    public FakeDataSourceConn(DataSourceDeployment ds) {
        this.ds = ds;
    }

    @Override
    public List<String> getDepends() {
        return this.ds.getDepends();
    }

    @Override
    public String getDriverClass() {
        return this.ds.getDriverClass();
    }

    @Override
    public String getJdbcURL() {
        return this.ds.getJdbcURL();
    }

    @Override
    public String getJndiName() {
        return this.ds.getJndiName();
    }

    @Override
    public int getMaxPoolSize() {
        return Integer.parseInt(this.ds.getMaxPoolSize());
    }

    @Override
    public int getMinPoolSize() {
        return Integer.parseInt(this.ds.getMinPoolSize());
    }

    @Override
    public String getPassword() {
        return this.ds.getPassword();
    }

    @Override
    public String getSecurityDomain() {
        return this.ds.getSecurityDomain();
    }

    @Override
    public String getTypeMapping() {
        return this.ds.getTypeMapping();
    }

    @Override
    public String getUsername() {
        return this.ds.getUsername();
    }

    @Override
    public void setDriverClass(String driverClass) {
        log.info("setDriverClass, " + driverClass);
        this.ds.setDriverClass(driverClass);
    }

    @Override
    public void setJdbcURL(String jdbcURL) {
        log.info("setJdbcURL, " + jdbcURL);
        this.ds.setJdbcURL(jdbcURL);
    }

    @Override
    public void setJndiName(String jndiName) {
        log.info("setJndiName, " + jndiName);
        this.ds.setJndiName(jndiName);
    }

    @Override
    public void setMaxPoolSize(int maxPoolSize) {
        this.ds.setMaxPoolSize("" + maxPoolSize);
    }

    @Override
    public void setMinPoolSize(int minPoolSize) {
        this.ds.setMinPoolSize("" + minPoolSize);
    }

    @Override
    public void setPassword(String password) {
        this.ds.setPassword(password);
    }

    @Override
    public void setSecurityDomain(String securityDomain) {
        this.ds.setSecurityDomain(securityDomain);
    }

    @Override
    public void setTypeMapping(String typeMapping) {
        this.ds.setTypeMapping(typeMapping);
    }

    @Override
    public void setUsername(String username) {
        this.ds.setUsername(username);
    }

    @Override
    public Properties getConnectionProperties() {
        return this.ds.getConnectionProperties();
    }

    @Override
    public void setConnectionProperties(Properties props) {
        this.ds.setConnectionProperties(props);
    }

    @Override
    public void start() throws Exception {
        this.dsConn = new MockDataSource();
        InitialContext ctx = new InitialContext();
        Util.bind((Context)ctx, this.ds.getJndiName(), (Object)this.dsConn);
        log.info("Bound MockDataSource under: " + this.ds.getJndiName());
    }

    @Override
    public void stop() throws Exception {
        InitialContext ctx = new InitialContext();
        Util.unbind((Context)ctx, this.ds.getJndiName());
        log.info("Unbound MockDataSource under: " + this.ds.getJndiName());
    }
}

