/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.profileservice.management.templates;

import java.io.File;
import java.io.FileWriter;
import java.net.URI;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.jboss.deployers.spi.management.DeploymentTemplate;
import org.jboss.deployers.spi.management.DeploymentTemplateInfo;
import org.jboss.deployers.vfs.spi.client.VFSDeployment;
import org.jboss.logging.Logger;
import org.jboss.managed.api.ManagedProperty;
import org.jboss.metatype.api.types.CompositeMetaType;
import org.jboss.metatype.api.values.CompositeValue;
import org.jboss.metatype.api.values.SimpleValue;
import org.jboss.util.xml.DOMWriter;
import org.jboss.virtual.VirtualFile;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class DsXmlDataSourceTemplate
implements DeploymentTemplate {
    private static final Logger log = Logger.getLogger(DsXmlDataSourceTemplate.class);
    private DeploymentTemplateInfo info;

    public VirtualFile applyTemplate(VirtualFile root, String deploymentBaseName, DeploymentTemplateInfo values) throws Exception {
        String dsName = deploymentBaseName + "-ds.xml";
        URI dsXmlURI = new URI(root.toURI() + dsName);
        File dsXml = new File(dsXmlURI.getPath());
        this.writeTemplate(dsXml, values);
        VirtualFile dsXmlVF = root.findChild(dsName);
        return dsXmlVF;
    }

    public void updateTemplateDeployment(VFSDeployment ctx, DeploymentTemplateInfo values) throws Exception {
    }

    public DeploymentTemplateInfo getInfo() {
        return this.info;
    }

    public void setInfo(DeploymentTemplateInfo info) {
        this.info = info;
    }

    protected void writeTemplate(File dsXml, DeploymentTemplateInfo values) throws Exception {
        FileWriter fw = new FileWriter(dsXml);
        fw.write("<datasources>\n");
        Map<String, ManagedProperty> properties = values.getProperties();
        ManagedProperty dsType = properties.get("datasource-type");
        if (dsType == null || dsType.getValue() == null) {
            throw new IllegalStateException("Required datasource-type value not found");
        }
        fw.write(60);
        fw.write(dsType.getValue().toString());
        fw.write(">\n");
        for (ManagedProperty p : properties.values()) {
            String tagName = p.getName();
            if (tagName.equals("datasource-type")) continue;
            if (p.isMandatory() && p.getValue() == null) {
                throw new IllegalStateException("Required " + tagName + " value not found");
            }
            fw.write("  <");
            fw.write(tagName);
            fw.write(62);
            if (p.getMetaType() instanceof CompositeMetaType) {
                CompositeValue cvalue = (CompositeValue)p.getValue();
                for (String key : cvalue.getMetaType().keySet()) {
                    if (!cvalue.containsKey(key)) continue;
                    SimpleValue svalue = (SimpleValue)cvalue.get(key);
                    String string = svalue.toString();
                    fw.write("  <");
                    fw.write(key);
                    fw.write(62);
                    fw.write(string);
                    fw.write("</");
                    fw.write(tagName);
                    fw.write(">\n");
                }
                continue;
            }
            Object value = p.getValue();
            if (value == null) {
                value = "";
            }
            fw.write(value.toString());
            fw.write("</");
            fw.write(tagName);
            fw.write(">\n");
        }
        fw.write("</");
        fw.write(dsType.getValue().toString());
        fw.write(">\n");
        fw.write("</datasources>\n");
        fw.flush();
        fw.close();
    }

    protected Document buildDocument(DeploymentTemplateInfo values) throws Exception {
        Document document = null;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        DOMImplementation impl = builder.getDOMImplementation();
        document = impl.createDocument(null, null, null);
        Element ds = document.createElement("datasources");
        document.appendChild(ds);
        Map<String, ManagedProperty> properties = values.getProperties();
        ManagedProperty dsType = properties.get("datasource-type");
        if (dsType == null || dsType.getValue() == null) {
            throw new IllegalStateException("Required datasource-type value not found");
        }
        Element dsTypeElem = document.createElement(dsType.getValue().toString());
        ds.appendChild(dsTypeElem);
        for (ManagedProperty p : properties.values()) {
            String tagName = p.getName();
            if (tagName.equals("datasource-type")) continue;
            if (p.isMandatory() && p.getValue() == null) {
                throw new IllegalStateException("Required " + tagName + " value not found");
            }
            Element element = document.createElement(tagName);
            Text t = document.createTextNode(p.getValue().toString());
            element.appendChild(t);
            dsTypeElem.appendChild(element);
        }
        log.debug("Updated metadata to: " + DOMWriter.printNode(document, true));
        return document;
    }
}

