/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mx.mxbean;

import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import javax.management.Attribute;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.MBeanServerConnection;
import javax.management.NotificationBroadcaster;
import javax.management.NotificationEmitter;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.openmbean.OpenMBeanAttributeInfo;
import javax.management.openmbean.OpenMBeanInfo;
import javax.management.openmbean.OpenMBeanOperationInfo;
import javax.management.openmbean.OpenMBeanParameterInfo;
import javax.management.openmbean.OpenType;
import org.jboss.mx.mxbean.MXBeanUtils;
import org.jboss.mx.util.JMXExceptionDecoder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MXBeanInvocationHandler
implements InvocationHandler,
Serializable {
    private static final long serialVersionUID = -2872014223541692039L;
    private static final Class[] LISTENER = new Class[]{NotificationListener.class};
    private static final Class[] TRIPLET = new Class[]{NotificationListener.class, NotificationFilter.class, Object.class};
    private static final Method EQUALS;
    private static final Method HASH_CODE;
    private static final Method TO_STRING;
    private static final Method ADD_NOTIFICATION_LISTENER;
    private static final Method GET_NOTIFICATION_INFO;
    private static final Method REMOVE_NOTIFICATION_LISTENER;
    private static final Method REMOVE_NOTIFICATION_LISTENER_TRIPLET;
    private MBeanServerConnection mbeanServerConnection;
    private Class<?> mxbeanInterface;
    private ObjectName objectName;
    private transient Map<Method, Action> mappings;
    private transient OpenMBeanInfo mbeanInfo;

    public MXBeanInvocationHandler(MBeanServerConnection mbeanServerConnection, Class<?> mxbeanInterface, ObjectName objectName) {
        if (mbeanServerConnection == null) {
            throw new IllegalArgumentException("Null mbeanServerConnection");
        }
        if (mxbeanInterface == null) {
            throw new IllegalArgumentException("Null mxmbeanInterface");
        }
        if (objectName == null) {
            throw new IllegalArgumentException("Null objectName");
        }
        this.mbeanServerConnection = mbeanServerConnection;
        this.mxbeanInterface = mxbeanInterface;
        this.objectName = objectName;
    }

    public MBeanServerConnection getMBeanServerConnection() {
        return this.mbeanServerConnection;
    }

    public Class<?> getMXBeanInterface() {
        return this.mxbeanInterface;
    }

    public ObjectName getObjectName() {
        return this.objectName;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        try {
            return this.getAction(proxy, method).perform(args);
        }
        catch (Throwable t) {
            throw JMXExceptionDecoder.decode(t);
        }
    }

    private Action getAction(Object proxy, Method method) throws Throwable {
        Action result;
        if (this.mappings == null) {
            this.mappings = this.getMappings(proxy);
        }
        if ((result = this.mappings.get(method)) == null) {
            throw new UnsupportedOperationException("Unknown method: " + method);
        }
        return result;
    }

    private Map<Method, Action> getMappings(Object proxy) throws Throwable {
        this.mbeanInfo = (OpenMBeanInfo)((Object)this.mbeanServerConnection.getMBeanInfo(this.objectName));
        HashMap<String, OpenMBeanAttributeInfo> attributesMap = new HashMap<String, OpenMBeanAttributeInfo>();
        MBeanAttributeInfo[] attributes = this.mbeanInfo.getAttributes();
        for (int i = 0; i < attributes.length; ++i) {
            OpenMBeanAttributeInfo openAttribute = (OpenMBeanAttributeInfo)((Object)attributes[i]);
            attributesMap.put(openAttribute.getName(), openAttribute);
        }
        MBeanOperationInfo[] operations = this.mbeanInfo.getOperations();
        HashMap<Method, Action> result = new HashMap<Method, Action>();
        Class<?>[] interfaces = proxy.getClass().getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            Method[] methods;
            if (NotificationBroadcaster.class.isAssignableFrom(interfaces[i])) {
                result.put(ADD_NOTIFICATION_LISTENER, new AddNotificationListenerAction());
                result.put(GET_NOTIFICATION_INFO, new GetNotificationInfoAction());
                result.put(REMOVE_NOTIFICATION_LISTENER, new RemoveNotificationListenerAction());
                result.put(REMOVE_NOTIFICATION_LISTENER_TRIPLET, new RemoveNotificationListenerTripletAction());
                continue;
            }
            for (Method method : methods = interfaces[i].getMethods()) {
                OpenMBeanOperationInfo operation;
                Type type;
                OpenMBeanAttributeInfo attribute;
                String name;
                String methodName = method.getName();
                Class<?> returnType = method.getReturnType();
                Class<?>[] parameterTypes = method.getParameterTypes();
                if (methodName.startsWith("get") && methodName.length() > 3 && !Void.TYPE.equals(returnType) && parameterTypes.length == 0) {
                    name = methodName.substring(3);
                    attribute = (OpenMBeanAttributeInfo)attributesMap.get(name);
                    if (attribute != null) {
                        type = method.getGenericReturnType();
                        result.put(method, new GetAction(attribute, type));
                        continue;
                    }
                } else if (methodName.startsWith("is") && methodName.length() > 2 && Boolean.TYPE.equals(returnType) && parameterTypes.length == 0) {
                    name = methodName.substring(2);
                    attribute = (OpenMBeanAttributeInfo)attributesMap.get(name);
                    if (attribute != null) {
                        type = method.getGenericReturnType();
                        result.put(method, new GetAction(attribute, type));
                        continue;
                    }
                } else if (methodName.startsWith("set") && methodName.length() > 3 && Void.TYPE.equals(returnType) && parameterTypes.length == 1 && (attribute = (OpenMBeanAttributeInfo)attributesMap.get(name = methodName.substring(3))) != null) {
                    result.put(method, new SetAction(attribute));
                    continue;
                }
                if ((operation = MXBeanInvocationHandler.findOperation(methodName, method.getGenericParameterTypes(), operations)) != null) {
                    String[] signature = MXBeanInvocationHandler.getSignature(method);
                    type = method.getGenericReturnType();
                    result.put(method, new InvokeAction(operation, signature, type));
                    continue;
                }
                result.put(method, new InvalidAction(method));
            }
        }
        result.put(EQUALS, new EqualsAction());
        result.put(HASH_CODE, new HashCodeAction());
        result.put(TO_STRING, new ToStringAction());
        return result;
    }

    private static OpenMBeanOperationInfo findOperation(String name, Type[] parameterTypes, MBeanOperationInfo[] operations) {
        OpenType[] signature = MXBeanInvocationHandler.getSignature(parameterTypes);
        for (int i = 0; i < operations.length; ++i) {
            if (!operations[i].getName().equals(name)) continue;
            MBeanParameterInfo[] parameters = operations[i].getSignature();
            boolean match = true;
            for (int p = 0; p < parameters.length && match; ++p) {
                OpenMBeanParameterInfo openMBeanParameterInfo = (OpenMBeanParameterInfo)((Object)parameters[p]);
                if (signature[p].equals(openMBeanParameterInfo.getOpenType())) continue;
                match = false;
            }
            if (!match) continue;
            return (OpenMBeanOperationInfo)((Object)operations[i]);
        }
        return null;
    }

    private static String[] getSignature(Method method) {
        Class<?>[] parameterTypes = method.getParameterTypes();
        String[] signature = new String[parameterTypes.length];
        for (int p = 0; p < parameterTypes.length; ++p) {
            signature[p] = parameterTypes[p].getName();
        }
        return signature;
    }

    private static OpenType[] getSignature(Type[] parameterTypes) {
        OpenType[] signature = new OpenType[parameterTypes.length];
        for (int p = 0; p < parameterTypes.length; ++p) {
            signature[p] = MXBeanUtils.getOpenType(parameterTypes[p]);
        }
        return signature;
    }

    static {
        try {
            ADD_NOTIFICATION_LISTENER = NotificationBroadcaster.class.getDeclaredMethod("addNotificationListener", TRIPLET);
            GET_NOTIFICATION_INFO = NotificationBroadcaster.class.getDeclaredMethod("getNotificationInfo", new Class[0]);
            REMOVE_NOTIFICATION_LISTENER = NotificationBroadcaster.class.getDeclaredMethod("removeNotificationListener", LISTENER);
            REMOVE_NOTIFICATION_LISTENER_TRIPLET = NotificationEmitter.class.getDeclaredMethod("removeNotificationListener", TRIPLET);
            EQUALS = Object.class.getDeclaredMethod("equals", Object.class);
            HASH_CODE = Object.class.getDeclaredMethod("hashCode", new Class[0]);
            TO_STRING = Object.class.getDeclaredMethod("toString", new Class[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private class RemoveNotificationListenerTripletAction
    implements Action {
        private RemoveNotificationListenerTripletAction() {
        }

        public Object perform(Object[] args) throws Throwable {
            NotificationListener listener = (NotificationListener)args[0];
            NotificationFilter filter = (NotificationFilter)args[1];
            Object handback = args[2];
            MXBeanInvocationHandler.this.mbeanServerConnection.removeNotificationListener(MXBeanInvocationHandler.this.objectName, listener, filter, handback);
            return null;
        }
    }

    private class RemoveNotificationListenerAction
    implements Action {
        private RemoveNotificationListenerAction() {
        }

        public Object perform(Object[] args) throws Throwable {
            NotificationListener listener = (NotificationListener)args[0];
            MXBeanInvocationHandler.this.mbeanServerConnection.removeNotificationListener(MXBeanInvocationHandler.this.objectName, listener);
            return null;
        }
    }

    private class GetNotificationInfoAction
    implements Action {
        private GetNotificationInfoAction() {
        }

        public Object perform(Object[] args) throws Throwable {
            return MXBeanInvocationHandler.this.mbeanServerConnection.getMBeanInfo(MXBeanInvocationHandler.this.objectName).getNotifications();
        }
    }

    private class AddNotificationListenerAction
    implements Action {
        private AddNotificationListenerAction() {
        }

        public Object perform(Object[] args) throws Throwable {
            NotificationListener listener = (NotificationListener)args[0];
            NotificationFilter filter = (NotificationFilter)args[1];
            Object handback = args[2];
            MXBeanInvocationHandler.this.mbeanServerConnection.addNotificationListener(MXBeanInvocationHandler.this.objectName, listener, filter, handback);
            return null;
        }
    }

    private class ToStringAction
    implements Action {
        private ToStringAction() {
        }

        public Object perform(Object[] args) throws Throwable {
            return "MXBeanInvocationHandler(" + MXBeanInvocationHandler.this.objectName + ")";
        }
    }

    private class HashCodeAction
    implements Action {
        private HashCodeAction() {
        }

        public Object perform(Object[] args) throws Throwable {
            return MXBeanInvocationHandler.this.objectName.hashCode();
        }
    }

    private class EqualsAction
    implements Action {
        private EqualsAction() {
        }

        public Object perform(Object[] args) throws Throwable {
            Object object = args[0];
            if (object == null || !(object instanceof Proxy)) {
                return false;
            }
            InvocationHandler handler = Proxy.getInvocationHandler(object);
            if (!(handler instanceof MXBeanInvocationHandler)) {
                return false;
            }
            MXBeanInvocationHandler other = (MXBeanInvocationHandler)handler;
            return MXBeanInvocationHandler.this.mbeanServerConnection.equals(other.mbeanServerConnection) && MXBeanInvocationHandler.this.objectName.equals(other.objectName);
        }
    }

    private class InvalidAction
    implements Action {
        private Method method;

        public InvalidAction(Method method) {
            this.method = method;
        }

        public Object perform(Object[] args) throws Throwable {
            throw new UnsupportedOperationException(this.method + " is not mapped to the MBeanInfo operations for " + MXBeanInvocationHandler.this.objectName);
        }
    }

    private class InvokeAction
    implements Action {
        private OpenMBeanOperationInfo operation;
        private String[] signature;
        private Type type;

        public InvokeAction(OpenMBeanOperationInfo operation, String[] signature, Type type) {
            this.operation = operation;
            this.signature = signature;
            this.type = type;
        }

        public Object perform(Object[] args) throws Throwable {
            MBeanParameterInfo[] parameters = this.operation.getSignature();
            Object[] arguments = new Object[args.length];
            for (int i = 0; i < parameters.length; ++i) {
                OpenMBeanParameterInfo parameter = (OpenMBeanParameterInfo)((Object)parameters[i]);
                arguments[i] = MXBeanUtils.construct(parameter.getOpenType(), args[i], (Object)this.operation.getName());
            }
            Object result = MXBeanInvocationHandler.this.mbeanServerConnection.invoke(MXBeanInvocationHandler.this.objectName, this.operation.getName(), arguments, this.signature);
            return MXBeanUtils.reconstruct(this.operation.getReturnOpenType(), this.type, result, this.operation.getName());
        }
    }

    private class SetAction
    implements Action {
        private OpenMBeanAttributeInfo attribute;

        public SetAction(OpenMBeanAttributeInfo attribute) {
            this.attribute = attribute;
        }

        public Object perform(Object[] args) throws Throwable {
            Object value = MXBeanUtils.construct(this.attribute.getOpenType(), args[0], (Object)("Set attribute: " + this.attribute.getName()));
            Attribute attr = new Attribute(this.attribute.getName(), value);
            MXBeanInvocationHandler.this.mbeanServerConnection.setAttribute(MXBeanInvocationHandler.this.objectName, attr);
            return null;
        }
    }

    private class GetAction
    implements Action {
        private OpenMBeanAttributeInfo attribute;
        private Type type;

        public GetAction(OpenMBeanAttributeInfo attribute, Type type) {
            this.attribute = attribute;
            this.type = type;
        }

        public Object perform(Object[] args) throws Throwable {
            Object result = MXBeanInvocationHandler.this.mbeanServerConnection.getAttribute(MXBeanInvocationHandler.this.objectName, this.attribute.getName());
            return MXBeanUtils.reconstruct(this.attribute.getOpenType(), this.type, result, "Get attribute: " + this.attribute.getName());
        }
    }

    private static interface Action {
        public Object perform(Object[] var1) throws Throwable;
    }
}

