/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mq.server.jmx;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import javax.management.Attribute;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.transaction.xa.Xid;
import org.jboss.mq.MessageStatistics;
import org.jboss.mq.pm.PersistenceManager;
import org.jboss.mq.pm.TxManager;
import org.jboss.mq.server.BasicQueueParameters;
import org.jboss.mq.server.JMSDestinationManager;
import org.jboss.mq.server.JMSServerInterceptor;
import org.jboss.mq.server.MessageCache;
import org.jboss.mq.server.MessageCounter;
import org.jboss.mq.server.Receivers;
import org.jboss.mq.server.jmx.DestinationManagerMBean;
import org.jboss.mq.server.jmx.InterceptorMBeanSupport;
import org.jboss.mq.sm.StateManager;
import org.jboss.mx.util.MBeanProxyExt;
import org.jboss.system.ServiceControllerMBean;
import org.jboss.util.JBossStringBuilder;
import org.jboss.util.threadpool.BasicThreadPool;
import org.jboss.util.threadpool.ThreadPool;

public class DestinationManager
extends InterceptorMBeanSupport
implements DestinationManagerMBean {
    public String jndiBindLocation = "java:/JBossMQServer";
    private ServiceControllerMBean serviceController;
    private ObjectName mqService;
    protected JMSDestinationManager jmsServer;
    private ObjectName persistenceManager;
    private ObjectName stateManager;
    private ObjectName messageCache;
    protected BasicQueueParameters tempParameters = new BasicQueueParameters();
    private ObjectName threadPool;
    private ObjectName expiryDestination;
    private boolean lazyRedeliveryUpdate = false;

    public int getClientCount() {
        if (this.jmsServer == null) {
            return 0;
        }
        return this.jmsServer.getClientCount();
    }

    public Map getClients() {
        if (this.jmsServer == null) {
            return null;
        }
        return this.jmsServer.getClients();
    }

    public ObjectName getPersistenceManager() {
        return this.persistenceManager;
    }

    public void setPersistenceManager(ObjectName objectName) {
        this.persistenceManager = objectName;
    }

    public ObjectName getStateManager() {
        return this.stateManager;
    }

    public void setStateManager(ObjectName objectName) {
        this.stateManager = objectName;
    }

    public ObjectName getMessageCache() {
        return this.messageCache;
    }

    public void setMessageCache(ObjectName objectName) {
        this.messageCache = objectName;
    }

    public int getTemporaryMaxDepth() {
        return this.tempParameters.maxDepth;
    }

    public void setTemporaryMaxDepth(int depth) {
        this.tempParameters.maxDepth = depth;
    }

    public boolean getTemporaryInMemory() {
        return this.tempParameters.inMemory;
    }

    public void setTemporaryInMemory(boolean mode) {
        this.tempParameters.inMemory = mode;
    }

    public Class getReceiversImpl() {
        return this.tempParameters.receiversImpl;
    }

    public void setReceiversImpl(Class clazz) {
        if (clazz != null && !Receivers.class.isAssignableFrom(clazz)) {
            throw new IllegalArgumentException("Class " + clazz.getName() + " is not a Receivers implementation");
        }
        this.tempParameters.receiversImpl = clazz;
    }

    public int getRecoveryRetries() {
        return this.tempParameters.recoveryRetries;
    }

    public void setRecoveryRetries(int retries) {
        this.tempParameters.recoveryRetries = retries;
    }

    public ObjectName getThreadPool() {
        return this.threadPool;
    }

    public void setThreadPool(ObjectName threadPool) {
        this.threadPool = threadPool;
    }

    public ObjectName getExpiryDestination() {
        return this.expiryDestination;
    }

    public void setExpiryDestination(ObjectName expiryDestination) {
        this.expiryDestination = expiryDestination;
    }

    public boolean isLazyRedeliveryUpdate() {
        return this.lazyRedeliveryUpdate;
    }

    public void setLazyRedeliveryUpdate(boolean lazyRedeliveryUpdate) {
        this.lazyRedeliveryUpdate = lazyRedeliveryUpdate;
    }

    public void createQueue(String name) throws Exception {
        this.createDestination("org.jboss.mq.server.jmx.Queue", this.getQueueObjectName(name), null);
    }

    public void createTopic(String name) throws Exception {
        this.createDestination("org.jboss.mq.server.jmx.Topic", this.getTopicObjectName(name), null);
    }

    public void createQueue(String name, String jndiLocation) throws Exception {
        this.createDestination("org.jboss.mq.server.jmx.Queue", this.getQueueObjectName(name), jndiLocation);
    }

    public void createTopic(String name, String jndiLocation) throws Exception {
        this.createDestination("org.jboss.mq.server.jmx.Topic", this.getTopicObjectName(name), jndiLocation);
    }

    protected void createDestination(String type, ObjectName name, String jndiLocation) throws Exception {
        this.log.debug("Attempting to create destination: " + name + "; type=" + type);
        this.server.createMBean(type, name);
        this.server.setAttribute(name, new Attribute("DestinationManager", this.mqService));
        if (jndiLocation != null) {
            this.server.setAttribute(name, new Attribute("JNDIName", jndiLocation));
        }
        ArrayList<ObjectName> depends = new ArrayList<ObjectName>();
        depends.add(this.serviceName);
        this.serviceController.create(name, depends);
        this.serviceController.start(name);
    }

    public void destroyQueue(String name) throws Exception {
        this.destroyDestination(this.getQueueObjectName(name));
    }

    public void destroyTopic(String name) throws Exception {
        this.destroyDestination(this.getTopicObjectName(name));
    }

    protected void destroyDestination(ObjectName name) throws Exception {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Attempting to destroy destination: " + name);
        }
        this.serviceController.stop(name);
        this.server.invoke(name, "removeAllMessages", new Object[0], new String[0]);
        this.serviceController.destroy(name);
        this.serviceController.remove(name);
    }

    protected ObjectName getObjectName(MBeanServer server, ObjectName name) throws MalformedObjectNameException {
        this.mqService = name;
        return this.mqService;
    }

    protected ObjectName getTopicObjectName(String name) throws MalformedObjectNameException {
        return new ObjectName(this.mqService.getDomain() + ".destination:service=Topic,name=" + name);
    }

    protected ObjectName getQueueObjectName(String name) throws MalformedObjectNameException {
        return new ObjectName(this.mqService.getDomain() + ".destination:service=Queue,name=" + name);
    }

    protected ServiceControllerMBean getServiceController() {
        return this.serviceController;
    }

    public JMSServerInterceptor getInterceptor() {
        return this.jmsServer;
    }

    protected void createService() throws Exception {
        super.createService();
        this.jmsServer = new JMSDestinationManager(this.tempParameters);
        this.jmsServer.setLazyRedeliveryUpdate(this.lazyRedeliveryUpdate);
    }

    protected void startService() throws Exception {
        ThreadPool tp;
        ThreadGroup tg;
        this.serviceController = (ServiceControllerMBean)MBeanProxyExt.create(ServiceControllerMBean.class, ServiceControllerMBean.OBJECT_NAME, this.server);
        PersistenceManager pm = (PersistenceManager)this.server.getAttribute(this.persistenceManager, "Instance");
        this.jmsServer.setPersistenceManager(pm);
        StateManager sm = (StateManager)this.server.getAttribute(this.stateManager, "Instance");
        this.jmsServer.setStateManager(sm);
        MessageCache mc = this.messageCache != null ? (MessageCache)this.server.getAttribute(this.messageCache, "Instance") : pm.getMessageCacheInstance();
        this.jmsServer.setMessageCache(mc);
        if (this.threadPool == null) {
            tg = new ThreadGroup("JBossMQ Server Threads");
            tp = new BasicThreadPool("JMSThread", tg);
        } else {
            tp = (ThreadPool)this.server.getAttribute(this.threadPool, "Instance");
            tg = tp instanceof BasicThreadPool ? ((BasicThreadPool)tp).getThreadGroup() : new ThreadGroup("JBossMQ Server Threads");
        }
        this.jmsServer.setThreadPool(tp);
        this.jmsServer.setThreadGroup(tg);
        this.jmsServer.startServer();
        super.startService();
    }

    protected void stopService() {
        this.jmsServer.stopServer();
    }

    protected void destroyService() throws Exception {
        super.destroyService();
        this.jmsServer = null;
    }

    public void setMessageCounterHistoryDayLimit(int days) {
        if (days < -1) {
            days = -1;
        }
        this.tempParameters.messageCounterHistoryDayLimit = days;
    }

    public int getMessageCounterHistoryDayLimit() {
        return this.tempParameters.messageCounterHistoryDayLimit;
    }

    public MessageCounter[] getMessageCounter() throws Exception {
        if (this.jmsServer == null) {
            return null;
        }
        return this.jmsServer.getMessageCounter();
    }

    public MessageStatistics[] getMessageStatistics() throws Exception {
        if (this.jmsServer == null) {
            return null;
        }
        return MessageCounter.getMessageStatistics(this.jmsServer.getMessageCounter());
    }

    public String listMessageCounter() throws Exception {
        if (this.jmsServer == null) {
            return null;
        }
        MessageCounter[] counter = this.jmsServer.getMessageCounter();
        String ret = "<table width=\"100%\" border=\"1\" cellpadding=\"1\" cellspacing=\"1\"><tr><th>Type</th><th>Name</th><th>Subscription</th><th>Durable</th><th>Count</th><th>CountDelta</th><th>Depth</th><th>DepthDelta</th><th>Last Add</th></tr>";
        String strNameLast = null;
        String strTypeLast = null;
        String strDestLast = null;
        String destData = "";
        int destCount = 0;
        int countTotal = 0;
        int countDeltaTotal = 0;
        int depthTotal = 0;
        int depthDeltaTotal = 0;
        int i = 0;
        for (i = 0; i < counter.length; ++i) {
            StringTokenizer tokens = new StringTokenizer(counter[i].getCounterAsString(), ",");
            String strType = tokens.nextToken();
            String strName = tokens.nextToken();
            String strSub = tokens.nextToken();
            String strDurable = tokens.nextToken();
            String strDest = strType + "-" + strName;
            String strCount = tokens.nextToken();
            String strCountDelta = tokens.nextToken();
            String strDepth = tokens.nextToken();
            String strDepthDelta = tokens.nextToken();
            String strDate = tokens.nextToken();
            countTotal += Integer.parseInt(strCount);
            depthTotal += Integer.parseInt(strDepth);
            countDeltaTotal += Integer.parseInt(strCountDelta);
            depthDeltaTotal += Integer.parseInt(strDepthDelta);
            if (strCountDelta.equalsIgnoreCase("0")) {
                strCountDelta = "-";
            }
            if (strDepthDelta.equalsIgnoreCase("0")) {
                strDepthDelta = "-";
            }
            if (strDestLast != null && strDestLast.equals(strDest)) {
                destData = destData + "<tr bgcolor=\"#" + (i % 2 == 0 ? "FFFFFF" : "F0F0F0") + "\">";
                ++destCount;
            } else {
                if (strDestLast != null) {
                    ret = ret + "<tr bgcolor=\"#" + (i % 2 == 0 ? "FFFFFF" : "F0F0F0") + "\"><td rowspan=\"" + destCount + "\">" + strTypeLast + "</td><td rowspan=\"" + destCount + "\">" + strNameLast + "</td>" + destData;
                    destData = "";
                }
                destCount = 1;
            }
            destData = destData + "<td>" + strSub + "</td>" + "<td>" + strDurable + "</td>" + "<td>" + strCount + "</td>" + "<td>" + strCountDelta + "</td>" + "<td>" + strDepth + "</td>" + "<td>" + strDepthDelta + "</td>" + "<td>" + strDate + "</td>";
            strTypeLast = strType;
            strNameLast = strName;
            strDestLast = strDest;
        }
        if (strDestLast != null) {
            ret = ret + "<tr bgcolor=\"#" + (i % 2 == 0 ? "FFFFFF" : "F0F0F0") + "\"><td rowspan=\"" + destCount + "\">" + strTypeLast + "</td><td rowspan=\"" + destCount + "\">" + strNameLast + "</td>" + destData;
        }
        ret = ret + "<tr><td><![CDATA[ ]]></td><td><![CDATA[ ]]></td><td><![CDATA[ ]]></td><td><![CDATA[ ]]></td><td>" + countTotal + "</td><td>" + (countDeltaTotal == 0 ? "-" : Integer.toString(countDeltaTotal)) + "</td><td>" + depthTotal + "</td><td>" + (depthDeltaTotal == 0 ? "-" : Integer.toString(depthDeltaTotal)) + "</td><td>Total</td></tr></table>";
        return ret;
    }

    public void resetMessageCounter() {
        if (this.jmsServer == null) {
            return;
        }
        this.jmsServer.resetMessageCounter();
    }

    public Map retrievePreparedTransactions() {
        if (this.jmsServer == null) {
            return null;
        }
        Map map = this.jmsServer.getPersistenceManager().getTxManager().getPreparedTransactions();
        HashMap<Xid, Boolean> result = new HashMap<Xid, Boolean>();
        Iterator i = map.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            Xid xid = (Xid)entry.getKey();
            TxManager.PreparedInfo info = (TxManager.PreparedInfo)entry.getValue();
            if (xid == null || info == null) continue;
            result.put(xid, info.isInDoubt());
        }
        return result;
    }

    public String showPreparedTransactions() {
        if (this.jmsServer == null) {
            return null;
        }
        Map map = this.jmsServer.getPersistenceManager().getTxManager().getPreparedTransactions();
        JBossStringBuilder buffer = new JBossStringBuilder();
        buffer.append("<table width=\"100%\" border=\"1\" cellpadding=\"1\" cellspacing=\"1\">");
        buffer.append("<tr><th>Xid</th><th>In Doubt</th><th>Local TXIDs</th></tr>");
        Iterator i = map.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            Xid xid = (Xid)entry.getKey();
            TxManager.PreparedInfo info = (TxManager.PreparedInfo)entry.getValue();
            if (xid == null || info == null) continue;
            buffer.append("<tr><td>");
            buffer.append(xid);
            buffer.append("</td><td>");
            buffer.append(info.isInDoubt());
            buffer.append("</td><td>");
            buffer.append(info.getTxids());
            buffer.append("</td></tr>");
        }
        buffer.append("</table>");
        return buffer.toString();
    }
}

