/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.metatype.api.values;

import java.io.Serializable;
import org.jboss.metatype.api.types.SimpleMetaType;
import org.jboss.metatype.api.values.AbstractMetaValue;
import org.jboss.metatype.api.values.SimpleValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleValueSupport<T extends Serializable>
extends AbstractMetaValue
implements SimpleValue<T> {
    private static final long serialVersionUID = 8473043036261557127L;
    private SimpleMetaType<T> metaType;
    private T value;

    public static <T extends Serializable> SimpleValue<T> wrap(T object) {
        if (object == null) {
            return null;
        }
        String className = object.getClass().getName();
        SimpleMetaType metaType = SimpleMetaType.resolve(className);
        return new SimpleValueSupport<T>(metaType, object);
    }

    public SimpleValueSupport(SimpleMetaType<T> metaType, T value) {
        if (metaType == null) {
            throw new IllegalArgumentException("Null simple meta type");
        }
        this.metaType = metaType;
        this.setValue(value);
    }

    @Override
    public SimpleMetaType<T> getMetaType() {
        return this.metaType;
    }

    @Override
    public T getValue() {
        return this.value;
    }

    public void setValue(T value) {
        this.value = value;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof SimpleValue)) {
            return false;
        }
        SimpleValue other = (SimpleValue)obj;
        if (!this.metaType.equals(other.getMetaType())) {
            return false;
        }
        Object otherValue = other.getValue();
        if (this.value == null && otherValue == null) {
            return true;
        }
        if (this.value == null && otherValue != null) {
            return false;
        }
        return this.value.equals(otherValue);
    }

    public int hashCode() {
        if (this.value == null) {
            return 0;
        }
        return this.value.hashCode();
    }

    public String toString() {
        return this.metaType + ":" + this.value;
    }
}

