/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.messaging.core.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.logging.Logger;
import org.jboss.messaging.core.contract.Message;
import org.jboss.messaging.core.contract.MessageReference;
import org.jboss.messaging.core.contract.MessageStore;
import org.jboss.messaging.core.contract.PersistenceManager;
import org.jboss.messaging.core.impl.ChannelSupport;

public abstract class PagingChannelSupport
extends ChannelSupport {
    private static final Logger log = Logger.getLogger(PagingChannelSupport.class);
    private boolean trace = log.isTraceEnabled();
    protected List downCache;
    protected int fullSize = 200000;
    protected int pageSize = 2000;
    protected int downCacheSize = 2000;
    protected boolean paging;
    protected long firstPagingOrder;
    protected long nextPagingOrder;
    protected MessageStore ms;

    public PagingChannelSupport(long channelID, MessageStore ms, PersistenceManager pm, boolean recoverable, int maxSize) {
        super(channelID, pm, recoverable, maxSize);
        this.downCache = new ArrayList(this.downCacheSize);
        this.ms = ms;
    }

    public PagingChannelSupport(long channelID, MessageStore ms, PersistenceManager pm, boolean recoverable, int maxSize, int fullSize, int pageSize, int downCacheSize) {
        super(channelID, pm, recoverable, maxSize);
        if (pageSize >= fullSize) {
            throw new IllegalArgumentException("pageSize must be less than full size " + pageSize + ", " + fullSize);
        }
        if (downCacheSize > pageSize) {
            throw new IllegalArgumentException("pageSize cannot be smaller than downCacheSize");
        }
        if (pageSize <= 0) {
            throw new IllegalArgumentException("pageSize must be greater than zero");
        }
        if (downCacheSize <= 0) {
            throw new IllegalArgumentException("downCacheSize must be greater than zero");
        }
        this.downCache = new ArrayList(downCacheSize);
        this.fullSize = fullSize;
        this.pageSize = pageSize;
        this.downCacheSize = downCacheSize;
        this.ms = ms;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getMessageCount() {
        int count = super.getMessageCount();
        Object object = this.lock;
        synchronized (object) {
            count = (int)((long)count + (this.nextPagingOrder - this.firstPagingOrder));
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int downCacheCount() {
        Object object = this.lock;
        synchronized (object) {
            return this.downCache.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isPaging() {
        Object object = this.lock;
        synchronized (object) {
            return this.paging;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPagingParams(int fullSize, int pageSize, int downCacheSize) {
        Object object = this.lock;
        synchronized (object) {
            if (this.active) {
                throw new IllegalStateException("Cannot set paging params when active");
            }
            this.fullSize = fullSize;
            this.pageSize = pageSize;
            this.downCacheSize = downCacheSize;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load() throws Exception {
        Object object = this.lock;
        synchronized (object) {
            if (this.active) {
                throw new IllegalStateException("Cannot load channel when active");
            }
            if (this.trace) {
                log.trace(this + " loading channel state");
            }
            this.unload();
            PersistenceManager.InitialLoadInfo ili = this.pm.loadFromStart(this.channelID, this.fullSize);
            this.doLoad(ili);
            while (this.checkLoad()) {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unload() throws Exception {
        Object object = this.lock;
        synchronized (object) {
            if (this.active) {
                throw new IllegalStateException("Cannot unload channel when active");
            }
            this.messageRefs.clear();
            this.downCache.clear();
            this.paging = false;
            this.nextPagingOrder = 0L;
            this.firstPagingOrder = 0L;
            this.clearAllScheduledDeliveries();
        }
    }

    protected void loadPagedReferences(int number) throws Exception {
        if (this.trace) {
            log.trace(this + " Loading " + number + " paged references from storage");
        }
        this.flushDownCache();
        List refInfos = this.pm.getPagedReferenceInfos(this.channelID, this.firstPagingOrder, number);
        Map refMap = this.processReferences(refInfos);
        boolean loadedReliable = false;
        ArrayList<MessageReference> toRemove = new ArrayList<MessageReference>();
        int unreliableNumber = 0;
        for (PersistenceManager.ReferenceInfo info : refInfos) {
            MessageReference ref = this.addFromRefInfo(info, refMap);
            if (this.recoverable && ref.getMessage().isReliable()) {
                loadedReliable = true;
                continue;
            }
            toRemove.add(ref);
            ++unreliableNumber;
        }
        if (!toRemove.isEmpty()) {
            if (this.trace) {
                log.trace(this + " removing depaged refs " + toRemove.size());
            }
            this.pm.removeDepagedReferences(this.channelID, toRemove);
        }
        if (loadedReliable) {
            if (this.trace) {
                log.trace("Updating refs not paged");
            }
            this.pm.updateReferencesNotPagedInRange(this.channelID, this.firstPagingOrder, this.firstPagingOrder + (long)number - 1L, number - unreliableNumber);
        }
        this.firstPagingOrder += (long)number;
        if (this.trace) {
            log.trace(this + " set firstPagingOrder to " + this.firstPagingOrder);
        }
        if (this.firstPagingOrder == this.nextPagingOrder) {
            this.nextPagingOrder = 0L;
            this.firstPagingOrder = 0L;
            if (this.messageRefs.size() != this.fullSize) {
                this.paging = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cancelInternal(MessageReference ref) throws Exception {
        Object object = this.lock;
        synchronized (object) {
            super.cancelInternal(ref);
            if (this.paging && this.messageRefs.size() == this.fullSize + 1) {
                MessageReference refCancel = (MessageReference)this.messageRefs.removeLast();
                this.addToDownCache(refCancel, true);
            }
            if (this.trace) {
                log.trace(this + " added " + ref + " back into state");
            }
        }
    }

    protected MessageReference removeFirstInMemory() throws Exception {
        MessageReference result = super.removeFirstInMemory();
        this.checkLoad();
        return result;
    }

    private boolean checkLoad() throws Exception {
        long refNum = this.nextPagingOrder - this.firstPagingOrder;
        if (refNum > 0L) {
            int numberLoadable = (int)Math.min(refNum, (long)this.pageSize);
            if (this.messageRefs.size() <= this.fullSize - numberLoadable) {
                this.loadPagedReferences(numberLoadable);
                return true;
            }
            return false;
        }
        this.paging = false;
        return false;
    }

    protected void addReferenceInMemory(MessageReference ref) throws Exception {
        if (this.paging) {
            this.addToDownCache(ref, false);
        } else {
            super.addReferenceInMemory(ref);
            if (this.messageRefs.size() == this.fullSize) {
                if (this.trace) {
                    log.trace(this + " going into paging mode");
                }
                this.paging = true;
            }
        }
    }

    protected void addToDownCache(MessageReference ref, boolean cancelling) throws Exception {
        if (cancelling) {
            ref.setPagingOrder(this.firstPagingOrder - 1L);
            --this.firstPagingOrder;
        } else {
            ref.setPagingOrder(this.nextPagingOrder);
            ++this.nextPagingOrder;
        }
        this.downCache.add(ref);
        if (this.trace) {
            log.trace(ref + " sent to downcache");
        }
        if (this.downCache.size() == this.downCacheSize) {
            if (this.trace) {
                log.trace(this + "'s downcache is full (" + this.downCache.size() + " messages)");
            }
            this.flushDownCache();
        }
    }

    protected void flushDownCache() throws Exception {
        if (this.trace) {
            log.trace(this + " flushing " + this.downCache.size() + " refs from downcache");
        }
        ArrayList<MessageReference> toUpdate = new ArrayList<MessageReference>();
        ArrayList<MessageReference> toAdd = new ArrayList<MessageReference>();
        for (MessageReference ref : this.downCache) {
            if (ref.getMessage().isReliable() && this.recoverable) {
                toUpdate.add(ref);
                continue;
            }
            toAdd.add(ref);
        }
        if (!toAdd.isEmpty()) {
            this.pm.pageReferences(this.channelID, toAdd, true);
        }
        if (!toUpdate.isEmpty()) {
            this.pm.updatePageOrder(this.channelID, toUpdate);
        }
        this.downCache.clear();
        if (this.trace) {
            log.trace(this + " cleared downcache");
        }
    }

    protected void doLoad(PersistenceManager.InitialLoadInfo ili) throws Exception {
        if (ili.getMaxPageOrdering() != null) {
            this.firstPagingOrder = ili.getMinPageOrdering();
            this.nextPagingOrder = ili.getMaxPageOrdering() + 1L;
            this.paging = true;
        } else {
            this.nextPagingOrder = 0L;
            this.firstPagingOrder = 0L;
            this.paging = false;
        }
        Map refMap = this.processReferences(ili.getRefInfos());
        for (PersistenceManager.ReferenceInfo info : ili.getRefInfos()) {
            this.addFromRefInfo(info, refMap);
        }
    }

    protected MessageReference addFromRefInfo(PersistenceManager.ReferenceInfo info, Map refMap) {
        long msgId = info.getMessageId();
        MessageReference ref = (MessageReference)refMap.get(new Long(msgId));
        ref.setDeliveryCount(info.getDeliveryCount());
        ref.setPagingOrder(-1L);
        ref.setScheduledDeliveryTime(info.getScheduledDelivery());
        if (!this.checkAndSchedule(ref)) {
            this.messageRefs.addLast(ref, ref.getMessage().getPriority());
        }
        return ref;
    }

    protected Map processReferences(List refInfos) throws Exception {
        HashMap<Long, MessageReference> refMap = new HashMap<Long, MessageReference>(refInfos.size());
        ArrayList<Long> msgIdsToLoad = new ArrayList<Long>(refInfos.size());
        for (PersistenceManager.ReferenceInfo info : refInfos) {
            long msgId = info.getMessageId();
            MessageReference ref = this.ms.reference(msgId);
            if (ref != null) {
                refMap.put(msgId, ref);
                continue;
            }
            msgIdsToLoad.add(msgId);
        }
        List messages = null;
        if (!msgIdsToLoad.isEmpty()) {
            messages = this.pm.getMessages(msgIdsToLoad);
            if (messages.size() != msgIdsToLoad.size()) {
                throw new IllegalStateException("Did not load correct number of messages, wanted:" + msgIdsToLoad.size() + " but got:" + messages.size());
            }
            for (Message m : messages) {
                MessageReference ref = this.ms.reference(m);
                refMap.put(new Long(m.getMessageID()), ref);
            }
        }
        return refMap;
    }
}

