/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.kernel.plugins.deployment.props;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jboss.logging.Logger;
import org.jboss.util.graph.Edge;
import org.jboss.util.graph.Vertex;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TreeVertex<T extends Vertex<String>>
extends Vertex<String> {
    protected Logger log = Logger.getLogger(this.getClass());
    private String lastToken;

    protected TreeVertex(String name) {
        super(name);
    }

    @Override
    public void visit() {
        Vertex<String> parent = TreeVertex.getParent(this);
        Set<Vertex<String>> children = TreeVertex.getChildren(this);
        if (this.log.isTraceEnabled()) {
            this.log.trace("Structure visit, parent: " + parent + ", children: " + children);
        }
        this.visit(parent, children);
    }

    protected String getLastToken() {
        if (this.lastToken == null) {
            String fullName = this.getName();
            int p = fullName.lastIndexOf(46) + 1;
            this.lastToken = fullName.substring(p);
        }
        return this.lastToken;
    }

    protected static Vertex<String> getParent(Vertex<String> vertex) {
        List edges = vertex.getIncomingEdges();
        Vertex<String> parent = null;
        if (!edges.isEmpty()) {
            HashSet previous = new HashSet();
            for (Edge edge : edges) {
                previous.add(edge.getFrom());
            }
            if (previous.size() > 1) {
                throw new IllegalArgumentException("Multiple parents: " + vertex);
            }
            return (Vertex)previous.iterator().next();
        }
        return parent;
    }

    protected static Set<Vertex<String>> getChildren(Vertex<String> vertex) {
        HashSet<Vertex<String>> children = new HashSet<Vertex<String>>();
        for (int i = 0; i < vertex.getOutgoingEdgeCount(); ++i) {
            Edge<String> edge = vertex.getOutgoingEdge(i);
            children.add(edge.getTo());
        }
        return children;
    }

    protected static Vertex<String> getPrevious(Vertex<String> vertex) {
        return TreeVertex.getParent(vertex);
    }

    protected static Vertex<String> getNext(Vertex<String> vertex) {
        Set<Vertex<String>> children = TreeVertex.getChildren(vertex);
        if (children.isEmpty()) {
            return null;
        }
        if (children.size() > 1) {
            throw new IllegalArgumentException("Multiple children: " + vertex);
        }
        return children.iterator().next();
    }

    public abstract void visit(T var1, Set<Vertex<String>> var2);
}

