/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.kernel.plugins.deployment.props;

import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import org.jboss.kernel.plugins.deployment.props.DeploymentVertex;
import org.jboss.kernel.plugins.deployment.props.TreeVertex;
import org.jboss.kernel.plugins.deployment.props.VertexFactory;
import org.jboss.kernel.plugins.deployment.props.vertex.DefaultVertexFactory;
import org.jboss.kernel.spi.deployment.KernelDeployment;
import org.jboss.util.graph.Graph;
import org.jboss.util.graph.Vertex;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertiesGraphFactory {
    private Graph<String> graph;
    private DeploymentVertex root;
    private VertexFactory vertexFactory = new DefaultVertexFactory();

    public PropertiesGraphFactory(Properties properties) {
        if (properties == null) {
            throw new IllegalArgumentException("Null properties.");
        }
        this.buildGraph(PropertiesGraphFactory.toMap(properties));
    }

    public PropertiesGraphFactory(Map<String, String> properties) {
        if (properties == null) {
            throw new IllegalArgumentException("Null properties.");
        }
        this.buildGraph(properties);
    }

    public KernelDeployment build() {
        this.graph.depthFirstSearch((Vertex<String>)this.root, this.vertexFactory.visitor());
        return this.root.get();
    }

    protected static Map<String, String> toMap(Properties properties) {
        TreeMap<String, String> map = new TreeMap<String, String>();
        for (Object key : properties.keySet()) {
            String ks = key.toString();
            map.put(ks, properties.getProperty(ks));
        }
        return map;
    }

    protected void buildGraph(Map<String, String> properties) {
        this.graph = new Graph();
        this.root = this.vertexFactory.rootVertex();
        this.graph.setRootVertex(this.root);
        for (String key : properties.keySet()) {
            String value = properties.get(key);
            this.buildVertices(this.root, 0, key, value, 0);
        }
    }

    protected void buildVertices(Vertex<String> previous, int index, String key, String value, int level) {
        int p = key.indexOf(46, index + 1);
        int end = p > 0 ? p : key.length();
        String name = key.substring(0, end);
        TreeVertex current = this.graph.findVertexByName(name);
        if (current == null) {
            current = this.vertexFactory.createVertex(level, name);
            this.graph.addVertex(current);
        }
        this.graph.addEdge(previous, current, level);
        if (p < 0) {
            TreeVertex valueVertex = this.vertexFactory.valueVertex(value);
            this.graph.addVertex(valueVertex);
            this.graph.addEdge(current, valueVertex, -1);
        } else {
            this.buildVertices(current, p, key, value, level + 1);
        }
    }

    public void setVertexFactory(VertexFactory vertexFactory) {
        this.vertexFactory = vertexFactory;
    }

    public String toString() {
        return this.graph.toString();
    }
}

