/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jms.server.endpoint;

import java.io.Serializable;
import javax.jms.IllegalStateException;
import javax.jms.InvalidSelectorException;
import javax.jms.JMSException;
import org.jboss.jms.delegate.ConsumerEndpoint;
import org.jboss.jms.destination.JBossDestination;
import org.jboss.jms.message.JBossMessage;
import org.jboss.jms.server.ServerPeer;
import org.jboss.jms.server.destination.ManagedDestination;
import org.jboss.jms.server.endpoint.ServerSessionEndpoint;
import org.jboss.jms.server.messagecounter.MessageCounter;
import org.jboss.jms.server.selector.Selector;
import org.jboss.jms.wireformat.Dispatcher;
import org.jboss.logging.Logger;
import org.jboss.messaging.core.contract.Delivery;
import org.jboss.messaging.core.contract.DeliveryObserver;
import org.jboss.messaging.core.contract.Message;
import org.jboss.messaging.core.contract.MessageReference;
import org.jboss.messaging.core.contract.PostOffice;
import org.jboss.messaging.core.contract.Queue;
import org.jboss.messaging.core.contract.Receiver;
import org.jboss.messaging.core.contract.Replicator;
import org.jboss.messaging.core.impl.SimpleDelivery;
import org.jboss.messaging.core.impl.tx.Transaction;
import org.jboss.messaging.util.ExceptionUtil;

public class ServerConsumerEndpoint
implements Receiver,
ConsumerEndpoint {
    private static final Logger log = Logger.getLogger(ServerConsumerEndpoint.class);
    private boolean trace = log.isTraceEnabled();
    private String id;
    private Queue messageQueue;
    private String queueName;
    private ServerSessionEndpoint sessionEndpoint;
    private boolean noLocal;
    private Selector messageSelector;
    private JBossDestination destination;
    private Queue dlq;
    private Queue expiryQueue;
    private long redeliveryDelay;
    private int maxDeliveryAttempts;
    private boolean started;
    private Object startStopLock;
    private volatile boolean clientAccepting;
    private boolean retainDeliveries;
    private long lastDeliveryID = -1L;
    private boolean remote;
    private boolean preserveOrdering;
    private boolean replicating;
    private boolean slow;
    private volatile boolean dead;

    ServerConsumerEndpoint(String id, Queue messageQueue, String queueName, ServerSessionEndpoint sessionEndpoint, String selector, boolean noLocal, JBossDestination dest, Queue dlq, Queue expiryQueue, long redeliveryDelay, int maxDeliveryAttempts, boolean remote, boolean replicating) throws InvalidSelectorException {
        if (this.trace) {
            log.trace("constructing consumer endpoint " + id);
        }
        this.id = id;
        this.messageQueue = messageQueue;
        this.queueName = queueName;
        this.sessionEndpoint = sessionEndpoint;
        this.noLocal = noLocal;
        this.destination = dest;
        this.dlq = dlq;
        this.redeliveryDelay = redeliveryDelay;
        this.expiryQueue = expiryQueue;
        this.maxDeliveryAttempts = maxDeliveryAttempts;
        this.clientAccepting = false;
        this.remote = remote;
        this.startStopLock = new Object();
        this.preserveOrdering = sessionEndpoint.getConnectionEndpoint().getServerPeer().isDefaultPreserveOrdering();
        this.replicating = replicating;
        this.slow = sessionEndpoint.getConnectionEndpoint().getConnectionFactoryEndpoint().isSlowConsumers();
        this.retainDeliveries = !dest.isTopic() || messageQueue.isRecoverable();
        if (selector != null) {
            if (this.trace) {
                log.trace("creating selector:" + selector);
            }
            this.messageSelector = new Selector(selector);
            if (this.trace) {
                log.trace("created selector");
            }
        }
        this.started = this.sessionEndpoint.getConnectionEndpoint().isStarted();
        if (remote) {
            this.messageQueue.getRemoteDistributor().add(this);
        } else {
            this.messageQueue.getLocalDistributor().add(this);
        }
        log.trace(this + " constructed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Delivery handle(DeliveryObserver observer, MessageReference ref, Transaction tx) {
        if (this.trace) {
            log.trace(this + " receives " + ref + " for delivery");
        }
        if (!this.clientAccepting) {
            if (this.trace) {
                log.trace(this + "'s client is NOT accepting messages!");
            }
            return null;
        }
        if (ref.getMessage().isExpired()) {
            SimpleDelivery delivery = new SimpleDelivery(observer, ref, true, false);
            try {
                this.sessionEndpoint.expireDelivery(delivery, this.expiryQueue);
            }
            catch (Throwable t) {
                log.error("Failed to expire delivery: " + delivery, t);
            }
            return delivery;
        }
        if (this.preserveOrdering && this.remote && ref.getMessage().getHeader("CLUSTER_SUCKED") != null) {
            if (this.trace) {
                log.trace("Message has already been sucked once - not sucking again");
            }
            return null;
        }
        Object object = this.startStopLock;
        synchronized (object) {
            Message message;
            if (!this.started) {
                if (this.trace) {
                    log.trace(this + " NOT started!");
                }
                return null;
            }
            if (this.trace) {
                log.trace(this + " has startStopLock lock, preparing the message for delivery");
            }
            boolean selectorRejected = !this.accept(message = ref.getMessage());
            SimpleDelivery delivery = new SimpleDelivery(observer, ref, !selectorRejected, false);
            if (selectorRejected) {
                return delivery;
            }
            if (this.noLocal) {
                String conId = ((JBossMessage)message).getConnectionID();
                if (this.trace) {
                    log.trace("message connection id: " + conId + " current connection connection id: " + this.sessionEndpoint.getConnectionEndpoint().getConnectionID());
                }
                if (this.sessionEndpoint.getConnectionEndpoint().getConnectionID().equals(conId)) {
                    if (this.trace) {
                        log.trace("Message from local connection so rejecting");
                    }
                    try {
                        delivery.acknowledge(null);
                    }
                    catch (Throwable t) {
                        log.error("Failed to acknowledge delivery", t);
                        return null;
                    }
                    return delivery;
                }
            }
            if (this.slow) {
                this.clientAccepting = false;
            }
            try {
                this.sessionEndpoint.handleDelivery(delivery, this);
            }
            catch (Exception e) {
                log.error("Failed to handle delivery", e);
                this.started = false;
            }
            return delivery;
        }
    }

    public boolean accept(Message msg) {
        boolean accept = true;
        if (this.destination.isQueue() && this.messageSelector != null) {
            accept = this.messageSelector.accept(msg);
            if (this.trace) {
                log.trace("message selector " + (accept ? "accepts " : "DOES NOT accept ") + "the message");
            }
        }
        return accept;
    }

    public long closing(long sequence) throws JMSException {
        try {
            if (this.trace) {
                log.trace(this + " closing");
            }
            this.stop();
            return this.lastDeliveryID;
        }
        catch (Throwable t) {
            throw ExceptionUtil.handleJMSInvocation(t, this + " closing");
        }
    }

    public void close() throws JMSException {
        try {
            if (this.trace) {
                log.trace(this + " close");
            }
            this.localClose();
            this.sessionEndpoint.removeConsumer(this.id);
        }
        catch (Throwable t) {
            throw ExceptionUtil.handleJMSInvocation(t, this + " close");
        }
    }

    public void changeRate(float newRate) throws JMSException {
        if (this.trace) {
            log.trace(this + " changing rate to " + newRate);
        }
        try {
            this.clientAccepting = newRate > 0.0f;
            if (this.clientAccepting) {
                this.promptDelivery();
            }
        }
        catch (Throwable t) {
            throw ExceptionUtil.handleJMSInvocation(t, this + " changeRate");
        }
    }

    public String toString() {
        return "ConsumerEndpoint[" + this.id + "]";
    }

    public JBossDestination getDestination() {
        return this.destination;
    }

    public ServerSessionEndpoint getSessionEndpoint() {
        return this.sessionEndpoint;
    }

    boolean isReplicating() {
        return this.replicating;
    }

    String getID() {
        return this.id;
    }

    boolean isRetainDeliveries() {
        return this.retainDeliveries;
    }

    void setLastDeliveryID(long id) {
        this.lastDeliveryID = id;
    }

    void setStarted(boolean started) {
        this.started = started;
    }

    void setDead() {
        this.dead = true;
    }

    boolean isDead() {
        return this.dead;
    }

    Queue getDLQ() {
        return this.dlq;
    }

    Queue getExpiryQueue() {
        return this.expiryQueue;
    }

    long getRedliveryDelay() {
        return this.redeliveryDelay;
    }

    int getMaxDeliveryAttempts() {
        return this.maxDeliveryAttempts;
    }

    String getQueueName() {
        return this.queueName;
    }

    void localClose() throws Throwable {
        if (this.trace) {
            log.trace(this + " grabbed the main lock in close() " + this);
        }
        if (this.remote) {
            this.messageQueue.getRemoteDistributor().remove(this);
        } else {
            this.messageQueue.getLocalDistributor().remove(this);
        }
        Dispatcher.instance.unregisterTarget(this.id, this);
        if (this.destination.isTopic()) {
            PostOffice postOffice = this.sessionEndpoint.getConnectionEndpoint().getServerPeer().getPostOfficeInstance();
            ServerPeer sp = this.sessionEndpoint.getConnectionEndpoint().getServerPeer();
            Queue queue = postOffice.getBindingForQueueName((String)this.queueName).queue;
            ManagedDestination mDest = sp.getDestinationManager().getDestination(this.destination.getName(), false);
            if (!queue.isRecoverable()) {
                postOffice.removeBinding(this.queueName, false);
                if (!mDest.isTemporary()) {
                    String counterName = "Subscription." + this.queueName;
                    MessageCounter counter = sp.getMessageCounterManager().unregisterMessageCounter(counterName);
                    if (counter == null) {
                        throw new IllegalStateException("Cannot find counter to remove " + counterName);
                    }
                }
            } else if (queue.isClustered() && postOffice.isClustered()) {
                Replicator rep = (Replicator)((Object)postOffice);
                rep.remove((Serializable)((Object)queue.getName()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void start() {
        Object object = this.startStopLock;
        synchronized (object) {
            if (this.started) {
                return;
            }
            this.started = true;
        }
        this.promptDelivery();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void stop() throws Throwable {
        Object object = this.startStopLock;
        synchronized (object) {
            if (!this.started) {
                return;
            }
            this.started = false;
        }
        if (this.replicating) {
            this.sessionEndpoint.waitForDeliveriesFromConsumer(this.id);
        }
    }

    private void promptDelivery() {
        this.sessionEndpoint.promptDelivery(this.messageQueue);
    }
}

