/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jms.client.state;

import EDU.oswego.cs.dl.util.concurrent.ReadWriteLock;
import EDU.oswego.cs.dl.util.concurrent.SyncSet;
import EDU.oswego.cs.dl.util.concurrent.WriterPreferenceReadWriteLock;
import java.util.HashSet;
import org.jboss.jms.client.FailoverCommandCenter;
import org.jboss.jms.client.delegate.ClientConnectionDelegate;
import org.jboss.jms.client.delegate.ClientSessionDelegate;
import org.jboss.jms.client.delegate.DelegateSupport;
import org.jboss.jms.client.remoting.JMSRemotingConnection;
import org.jboss.jms.client.state.HierarchicalState;
import org.jboss.jms.client.state.HierarchicalStateSupport;
import org.jboss.jms.client.state.SessionState;
import org.jboss.jms.delegate.ConnectionDelegate;
import org.jboss.jms.delegate.ConnectionFactoryDelegate;
import org.jboss.jms.message.MessageIdGenerator;
import org.jboss.jms.tx.ResourceManager;
import org.jboss.jms.tx.ResourceManagerFactory;
import org.jboss.logging.Logger;
import org.jboss.messaging.util.Version;

public class ConnectionState
extends HierarchicalStateSupport {
    private static final Logger log = Logger.getLogger(ConnectionState.class);
    private int serverID;
    private Version versionToUse;
    private ConnectionDelegate delegate;
    protected boolean started;
    private boolean justCreated = true;
    private String clientID;
    private JMSRemotingConnection remotingConnection;
    private ResourceManager resourceManager;
    private MessageIdGenerator idGenerator;
    private transient String username;
    private transient String password;
    private ConnectionFactoryDelegate clusteredConnectionFactoryDelegate;
    private FailoverCommandCenter fcc;

    public ConnectionState(int serverID, ConnectionDelegate delegate, JMSRemotingConnection remotingConnection, Version versionToUse, MessageIdGenerator gen) throws Exception {
        super(null, (DelegateSupport)((Object)delegate));
        if (log.isTraceEnabled()) {
            log.trace(this + " constructing connection state");
        }
        this.children = new SyncSet(new HashSet(), (ReadWriteLock)new WriterPreferenceReadWriteLock());
        this.remotingConnection = remotingConnection;
        this.versionToUse = versionToUse;
        this.resourceManager = ResourceManagerFactory.instance.checkOutResourceManager(serverID);
        this.idGenerator = gen;
        this.serverID = serverID;
    }

    public DelegateSupport getDelegate() {
        return (DelegateSupport)((Object)this.delegate);
    }

    public void setDelegate(DelegateSupport delegate) {
        this.delegate = (ConnectionDelegate)((Object)delegate);
    }

    public HierarchicalState getParent() {
        return null;
    }

    public void setParent(HierarchicalState parent) {
    }

    public Version getVersionToUse() {
        return this.versionToUse;
    }

    public void synchronizeWith(HierarchicalState ns) throws Exception {
        ConnectionState newState = (ConnectionState)ns;
        this.remotingConnection = newState.remotingConnection;
        this.idGenerator = newState.idGenerator;
        this.serverID = newState.serverID;
        this.versionToUse = newState.versionToUse;
        this.remotingConnection.getConnectionListener().setConnectionState(this);
        ConnectionDelegate newDelegate = (ConnectionDelegate)((Object)newState.getDelegate());
        for (SessionState sessionState : this.getChildren()) {
            ClientSessionDelegate sessionDelegate = (ClientSessionDelegate)sessionState.getDelegate();
            ClientSessionDelegate newSessionDelegate = (ClientSessionDelegate)newDelegate.createSessionDelegate(sessionState.isTransacted(), sessionState.getAcknowledgeMode(), sessionState.isXA());
            sessionDelegate.synchronizeWith(newSessionDelegate);
        }
        this.fcc = newState.fcc;
        this.fcc.setState(this);
    }

    public ResourceManager getResourceManager() {
        return this.resourceManager;
    }

    public MessageIdGenerator getIdGenerator() {
        return this.idGenerator;
    }

    public JMSRemotingConnection getRemotingConnection() {
        return this.remotingConnection;
    }

    public int getServerID() {
        return this.serverID;
    }

    public boolean isStarted() {
        return this.started;
    }

    public void setStarted(boolean started) {
        this.started = started;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getClientID() {
        return this.clientID;
    }

    public void setClientID(String clientID) {
        this.clientID = clientID;
    }

    public boolean isJustCreated() {
        return this.justCreated;
    }

    public void setJustCreated(boolean justCreated) {
        this.justCreated = justCreated;
    }

    public void setClusteredConnectionFactoryDeleage(ConnectionFactoryDelegate d) {
        this.clusteredConnectionFactoryDelegate = d;
    }

    public ConnectionFactoryDelegate getClusteredConnectionFactoryDelegate() {
        return this.clusteredConnectionFactoryDelegate;
    }

    public FailoverCommandCenter getFailoverCommandCenter() {
        return this.fcc;
    }

    public void initializeFailoverCommandCenter() {
        this.fcc = new FailoverCommandCenter(this);
    }

    public String toString() {
        return "ConnectionState[" + ((ClientConnectionDelegate)this.delegate).getID() + "]";
    }
}

