/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.clientmodule;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.jboss.logging.Logger;
import org.jboss.metadata.javaee.spec.EJBReferenceMetaData;
import org.jboss.metadata.javaee.spec.EJBReferencesMetaData;
import org.jboss.metadata.javaee.spec.Environment;
import org.jboss.metadata.javaee.spec.EnvironmentEntriesMetaData;
import org.jboss.metadata.javaee.spec.EnvironmentEntryMetaData;
import org.jboss.metadata.javaee.spec.MessageDestinationReferenceMetaData;
import org.jboss.metadata.javaee.spec.MessageDestinationReferencesMetaData;
import org.jboss.metadata.javaee.spec.MessageDestinationUsageType;
import org.jboss.metadata.javaee.spec.ResourceAuthorityType;
import org.jboss.metadata.javaee.spec.ResourceEnvironmentReferenceMetaData;
import org.jboss.metadata.javaee.spec.ResourceEnvironmentReferencesMetaData;
import org.jboss.metadata.javaee.spec.ResourceInjectionTargetMetaData;
import org.jboss.metadata.javaee.spec.ResourceReferenceMetaData;
import org.jboss.metadata.javaee.spec.ResourceReferencesMetaData;
import org.jboss.metamodel.descriptor.EjbLocalRef;
import org.jboss.metamodel.descriptor.EjbRef;
import org.jboss.metamodel.descriptor.EnvEntry;
import org.jboss.metamodel.descriptor.EnvironmentRefGroup;
import org.jboss.metamodel.descriptor.InjectionTarget;
import org.jboss.metamodel.descriptor.JndiRef;
import org.jboss.metamodel.descriptor.MessageDestinationRef;
import org.jboss.metamodel.descriptor.PersistenceContextRef;
import org.jboss.metamodel.descriptor.PersistenceUnitRef;
import org.jboss.metamodel.descriptor.ResourceEnvRef;
import org.jboss.metamodel.descriptor.ResourceRef;
import org.jboss.wsf.spi.serviceref.ServiceRefMetaData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnvironmentRefGroupConveter
extends EnvironmentRefGroup {
    private static final Logger log = Logger.getLogger(EnvironmentRefGroupConveter.class);
    private Environment refs;
    private boolean convertedEjbLocalRefs;
    private boolean convertedEjbRefs = false;
    private boolean convertedEnvEntries = false;
    private boolean convertedMessageDestinationRefs = false;
    private boolean convertedResourceEnvRefs = false;
    private boolean convertedResourceRefs = false;
    private boolean convertedServiceRefs = false;

    public EnvironmentRefGroupConveter(Environment refs) {
        this.refs = refs;
    }

    @Override
    public Collection<EjbLocalRef> getEjbLocalRefs() {
        if (!this.convertedEjbLocalRefs) {
            this.convertedEjbLocalRefs = true;
        }
        return super.getEjbLocalRefs();
    }

    @Override
    public Collection<EjbRef> getEjbRefs() {
        if (!this.convertedEjbRefs) {
            EJBReferencesMetaData erefs = this.refs.getEjbReferences();
            if (erefs != null) {
                for (EJBReferenceMetaData ref : erefs) {
                    EjbRef eref = new EjbRef();
                    eref.setEjbLink(ref.getLink());
                    eref.setEjbRefName(ref.getEjbRefName());
                    eref.setEjbRefType(ref.getType());
                    eref.setHome(ref.getHome());
                    eref.setRemote(ref.getRemote());
                    eref.setIgnoreDependency(ref.isDependencyIgnored());
                    eref.setMappedName(ref.getMappedName());
                    eref.setInjectionTarget(this.getInjectionTarget(ref.getInjectionTargets()));
                    this.ejbRefs.put(ref.getEjbRefName(), eref);
                }
            }
            log.info("Converted " + this.ejbRefs.size() + " refs: " + this.ejbRefs.keySet());
            this.convertedEjbRefs = true;
        }
        return super.getEjbRefs();
    }

    @Override
    public Collection<EnvEntry> getEnvEntries() {
        if (!this.convertedEnvEntries) {
            EnvironmentEntriesMetaData env = this.refs.getEnvironmentEntries();
            if (env != null) {
                for (EnvironmentEntryMetaData entry : env) {
                    EnvEntry ee = new EnvEntry();
                    ee.setEnvEntryName(entry.getEnvEntryName());
                    ee.setEnvEntryType(entry.getType());
                    ee.setEnvEntryValue(entry.getValue());
                    Set<ResourceInjectionTargetMetaData> rits = entry.getInjectionTargets();
                    if (rits != null && !rits.isEmpty()) {
                        ResourceInjectionTargetMetaData rit = rits.iterator().next();
                        InjectionTarget it = new InjectionTarget();
                        it.setTargetClass(rit.getInjectionTargetClass());
                        it.setTargetName(rit.getInjectionTargetName());
                        ee.setInjectionTarget(it);
                    }
                    ee.setIgnoreDependency(entry.isDependencyIgnored());
                    this.envEntries.put(ee.getEnvEntryName(), ee);
                }
                log.info("Converted " + this.envEntries.size() + " envs: " + this.envEntries.keySet());
            }
            this.convertedEnvEntries = true;
        }
        return super.getEnvEntries();
    }

    @Override
    public Collection<JndiRef> getJndiRefs() {
        return super.getJndiRefs();
    }

    @Override
    public MessageDestinationRef getMessageDestinationRefForLink(String link) {
        if (!this.convertedMessageDestinationRefs) {
            this.getMessageDestinationRefs();
        }
        return super.getMessageDestinationRefForLink(link);
    }

    @Override
    public Collection<MessageDestinationRef> getMessageDestinationRefs() {
        if (!this.convertedMessageDestinationRefs) {
            MessageDestinationReferencesMetaData mrefs = this.refs.getMessageDestinationReferences();
            if (mrefs != null) {
                for (MessageDestinationReferenceMetaData mref : mrefs) {
                    MessageDestinationRef ref = new MessageDestinationRef();
                    ref.setIgnoreDependency(mref.isDependencyIgnored());
                    ref.setMappedName(mref.getMappedName());
                    ref.setJndiName(mref.getMappedName());
                    ref.setMessageDestinationLink(mref.getLink());
                    ref.setMessageDestinationRefName(mref.getMessageDestinationRefName());
                    ref.setMessageDestinationType(mref.getType());
                    MessageDestinationUsageType usage = mref.getMessageDestinationUsage();
                    if (usage != null) {
                        ref.setMessageDestinationUsage(usage.name());
                    }
                    this.messageDestinationRefs.put(ref.getMessageDestinationRefName(), ref);
                }
            }
            log.info("Converted " + this.messageDestinationRefs.size() + " msgRefs: " + this.messageDestinationRefs.keySet());
            this.convertedMessageDestinationRefs = true;
        }
        return super.getMessageDestinationRefs();
    }

    @Override
    public List<PersistenceContextRef> getPersistenceContextRefs() {
        return super.getPersistenceContextRefs();
    }

    @Override
    public List<PersistenceUnitRef> getPersistenceUnitRefs() {
        return super.getPersistenceUnitRefs();
    }

    @Override
    public Collection<ResourceEnvRef> getResourceEnvRefs() {
        if (!this.convertedResourceEnvRefs) {
            ResourceEnvironmentReferencesMetaData rrefs = this.refs.getResourceEnvironmentReferences();
            if (rrefs != null) {
                for (ResourceEnvironmentReferenceMetaData rref : rrefs) {
                    ResourceEnvRef ref = new ResourceEnvRef();
                    ref.setResRefName(rref.getResourceEnvRefName());
                    ref.setIgnoreDependency(ref.isIgnoreDependency());
                    ref.setResType(rref.getType());
                    ref.setJndiName(rref.getJndiName());
                    ref.setMappedName(rref.getMappedName());
                    ref.setResAuth("Container");
                    ref.setInjectionTarget(this.getInjectionTarget(rref.getInjectionTargets()));
                    this.resourceEnvRefs.put(ref.getResRefName(), ref);
                }
            }
            log.info("Converted " + this.resourceEnvRefs.size() + " envRefs: " + this.resourceEnvRefs.keySet());
            this.convertedResourceEnvRefs = true;
        }
        return super.getResourceEnvRefs();
    }

    @Override
    public Collection<ResourceRef> getResourceRefs() {
        if (!this.convertedResourceRefs) {
            ResourceReferencesMetaData rrefs = this.refs.getResourceReferences();
            if (rrefs != null) {
                for (ResourceReferenceMetaData rref : rrefs) {
                    ResourceRef ref = new ResourceRef();
                    ref.setResRefName(rref.getResourceRefName());
                    ref.setIgnoreDependency(ref.isIgnoreDependency());
                    ref.setResType(rref.getType());
                    ref.setJndiName(rref.getJndiName());
                    ref.setMappedName(rref.getMappedName());
                    ref.setResUrl(rref.getResUrl());
                    ResourceAuthorityType authType = rref.getResAuth();
                    if (authType != null) {
                        ref.setResAuth(authType.name());
                    }
                    ref.setInjectionTarget(this.getInjectionTarget(rref.getInjectionTargets()));
                    this.resourceRefs.put(ref.getResRefName(), ref);
                }
            }
            log.info("Converted " + this.resourceRefs.size() + " resRefs: " + this.resourceRefs.keySet());
            this.convertedResourceRefs = true;
        }
        return super.getResourceRefs();
    }

    @Override
    public ServiceRefMetaData getServiceRef(String name) {
        if (!this.convertedServiceRefs) {
            this.getServiceRefs();
        }
        return super.getServiceRef(name);
    }

    @Override
    public Collection<ServiceRefMetaData> getServiceRefs() {
        if (!this.convertedServiceRefs) {
            this.convertedServiceRefs = true;
        }
        return super.getServiceRefs();
    }

    private InjectionTarget getInjectionTarget(Set<ResourceInjectionTargetMetaData> rits) {
        InjectionTarget it = null;
        if (rits != null && !rits.isEmpty()) {
            ResourceInjectionTargetMetaData rit = rits.iterator().next();
            it = new InjectionTarget();
            it.setTargetClass(rit.getInjectionTargetClass());
            it.setTargetName(rit.getInjectionTargetName());
        }
        return it;
    }
}

