/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.plugins.cmp.jdbc;

import javax.ejb.EJBException;
import org.jboss.ejb.Container;
import org.jboss.ejb.EntityContainer;
import org.jboss.ejb.EntityEnterpriseContext;
import org.jboss.ejb.plugins.AbstractInterceptor;
import org.jboss.ejb.plugins.cmp.jdbc.bridge.CMRInvocation;
import org.jboss.ejb.plugins.cmp.jdbc.bridge.CMRMessage;
import org.jboss.ejb.plugins.cmp.jdbc.bridge.JDBCCMRFieldBridge;
import org.jboss.ejb.plugins.cmp.jdbc.bridge.JDBCEntityBridge;
import org.jboss.invocation.Invocation;
import org.jboss.logging.Logger;

public final class JDBCRelationInterceptor
extends AbstractInterceptor {
    private EntityContainer container;
    private Logger log;

    public void setContainer(Container container) {
        this.container = (EntityContainer)container;
        if (container != null) {
            this.log = Logger.getLogger(this.getClass().getName() + "." + container.getBeanMetaData().getEjbName());
        }
    }

    public Container getContainer() {
        return this.container;
    }

    public Object invoke(Invocation mi) throws Exception {
        if (!(mi instanceof CMRInvocation)) {
            return this.getNext().invoke(mi);
        }
        CMRMessage relationshipMessage = ((CMRInvocation)mi).getCmrMessage();
        if (relationshipMessage == null) {
            return this.getNext().invoke(mi);
        }
        EntityEnterpriseContext ctx = (EntityEnterpriseContext)mi.getEnterpriseContext();
        JDBCCMRFieldBridge cmrField = (JDBCCMRFieldBridge)mi.getArguments()[0];
        if (CMRMessage.GET_RELATED_ID == relationshipMessage) {
            if (this.log.isTraceEnabled()) {
                this.log.trace("Getting related id: field=" + cmrField.getFieldName() + " id=" + ctx.getId());
            }
            return cmrField.getRelatedId(ctx);
        }
        if (CMRMessage.ADD_RELATION == relationshipMessage) {
            Object relatedId = mi.getArguments()[1];
            if (this.log.isTraceEnabled()) {
                this.log.trace("Add relation: field=" + cmrField.getFieldName() + " id=" + ctx.getId() + " relatedId=" + relatedId);
            }
            cmrField.addRelation(ctx, relatedId);
            return null;
        }
        if (CMRMessage.REMOVE_RELATION == relationshipMessage) {
            Object relatedId = mi.getArguments()[1];
            if (this.log.isTraceEnabled()) {
                this.log.trace("Remove relation: field=" + cmrField.getFieldName() + " id=" + ctx.getId() + " relatedId=" + relatedId);
            }
            cmrField.removeRelation(ctx, relatedId);
            return null;
        }
        if (CMRMessage.SCHEDULE_FOR_CASCADE_DELETE == relationshipMessage) {
            JDBCEntityBridge entity = (JDBCEntityBridge)cmrField.getEntity();
            entity.scheduleForCascadeDelete(ctx);
            return null;
        }
        if (CMRMessage.SCHEDULE_FOR_BATCH_CASCADE_DELETE == relationshipMessage) {
            JDBCEntityBridge entity = (JDBCEntityBridge)cmrField.getEntity();
            entity.scheduleForBatchCascadeDelete(ctx);
            return null;
        }
        throw new EJBException("Unknown cmp2.0-relationship-message=" + relationshipMessage);
    }
}

