/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.deployers;

import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.spi.deployer.DeploymentStages;
import org.jboss.deployers.spi.deployer.helpers.AbstractDeployer;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.deployment.AnnotationMetaDataDeployer;
import org.jboss.metadata.ejb.jboss.JBossMetaData;
import org.jboss.metadata.ejb.spec.AnnotationMergedView;
import org.jboss.metadata.ejb.spec.EjbJar30MetaData;
import org.jboss.metadata.ejb.spec.EjbJar3xMetaData;
import org.jboss.metadata.ejb.spec.EjbJarMetaData;

public class MergedJBossMetaDataDeployer
extends AbstractDeployer {
    public static final String EJB_MERGED_ATTACHMENT_NAME = "merged." + JBossMetaData.class.getName();

    public MergedJBossMetaDataDeployer() {
        this.setStage(DeploymentStages.POST_CLASSLOADER);
        this.addInput(EjbJarMetaData.class);
        this.addInput(JBossMetaData.class);
        this.addInput(AnnotationMetaDataDeployer.EJB_ANNOTATED_ATTACHMENT_NAME);
        this.setOutput(JBossMetaData.class);
        this.addOutput(EJB_MERGED_ATTACHMENT_NAME);
    }

    public void deploy(DeploymentUnit unit) throws DeploymentException {
        EjbJarMetaData specMetaData = unit.getAttachment(EjbJarMetaData.class);
        JBossMetaData metaData = unit.getAttachment(JBossMetaData.class);
        if (specMetaData == null && metaData == null) {
            return;
        }
        String key = AnnotationMetaDataDeployer.EJB_ANNOTATED_ATTACHMENT_NAME;
        EjbJar3xMetaData annotatedMetaData = unit.getAttachment(key, EjbJar3xMetaData.class);
        if (annotatedMetaData != null) {
            if (specMetaData != null) {
                EjbJar30MetaData specMerged = new EjbJar30MetaData();
                AnnotationMergedView.merge(specMerged, (EjbJar3xMetaData)specMetaData, annotatedMetaData);
                specMetaData = specMerged;
            } else {
                specMetaData = annotatedMetaData;
            }
        }
        JBossMetaData mergedMetaData = new JBossMetaData();
        mergedMetaData.merge(metaData, specMetaData);
        unit.getTransientManagedObjects().addAttachment(JBossMetaData.class, mergedMetaData);
    }
}

