/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployment.security;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.management.ObjectName;
import org.jboss.dependency.spi.ControllerState;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.deployers.vfs.spi.deployer.AbstractVFSRealDeployer;
import org.jboss.deployers.vfs.spi.structure.VFSDeploymentUnit;
import org.jboss.deployment.security.JaccPolicy;
import org.jboss.deployment.security.JaccPolicyUtil;
import org.jboss.deployment.security.PolicyConfigurationFacade;
import org.jboss.metadata.ejb.jboss.JBossEnterpriseBeanMetaData;
import org.jboss.metadata.ejb.jboss.JBossMetaData;
import org.jboss.metadata.web.jboss.JBossWebMetaData;
import org.jboss.system.metadata.ServiceAttributeMetaData;
import org.jboss.system.metadata.ServiceConstructorMetaData;
import org.jboss.system.metadata.ServiceDependencyMetaData;
import org.jboss.system.metadata.ServiceDeployment;
import org.jboss.system.metadata.ServiceInjectionValueMetaData;
import org.jboss.system.metadata.ServiceMetaData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SecurityDeployer
extends AbstractVFSRealDeployer {
    private HashSet<String> ignoreSuffixes = null;
    String BASE_OBJECT_NAME = "jboss:service=jacc,id=";

    public SecurityDeployer() {
        this.setTopLevelOnly(true);
        this.setInputs(JBossWebMetaData.class.getName(), JBossMetaData.class.getName(), JBossEnterpriseBeanMetaData.class.getName(), JaccPolicyUtil.IGNORE_ME_NAME);
        this.setOutputs("jboss.jacc");
    }

    public void setIgnoreSuffixes(HashSet<String> suffixSet) {
        this.ignoreSuffixes = suffixSet;
    }

    @Override
    public void deploy(VFSDeploymentUnit unit) throws DeploymentException {
        String contextId = unit.getSimpleName();
        for (String suffix : this.ignoreSuffixes) {
            String dotSuffix = "." + suffix;
            if (!contextId.endsWith(dotSuffix)) continue;
            this.log.debug("Ignoring: " + contextId);
            return;
        }
        List<String> jaccDeployments = JaccPolicyUtil.getJaccDeployments(unit, this.ignoreSuffixes);
        if (jaccDeployments.size() == 0) {
            boolean ejbJar;
            boolean bl = ejbJar = contextId.endsWith("jar") && JaccPolicyUtil.isEJBDeployment(unit);
            if (contextId.endsWith("war") || ejbJar) {
                this.createTopLevelServiceBeanWithMetaData(contextId, unit);
                return;
            }
            return;
        }
        if (this.getMetaData(unit) != null) {
            this.createTopLevelServiceBeanWithMetaData(contextId, unit);
        } else {
            this.createTopLevelServiceBean(contextId, unit);
        }
        for (String str : jaccDeployments) {
            DeploymentUnit childDU = this.getChildDeployment(unit, str);
            Object metadata = this.getMetaData(childDU);
            if (metadata == null) {
                this.log.debug("meta data is null for child deployment:" + childDU.getSimpleName() + "; No Jacc policy created.");
                continue;
            }
            ServiceMetaData subjaccPolicy = new ServiceMetaData();
            subjaccPolicy.setCode(PolicyConfigurationFacade.class.getName());
            try {
                subjaccPolicy.setObjectName(new ObjectName(this.BASE_OBJECT_NAME + str));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            ServiceConstructorMetaData constructor = new ServiceConstructorMetaData();
            constructor.setSignature(new String[]{String.class.getName(), Object.class.getName()});
            constructor.setParameters(new Object[]{str, this.getMetaData(childDU)});
            subjaccPolicy.setConstructor(constructor);
            ArrayList<ServiceMetaData> services = new ArrayList<ServiceMetaData>();
            services.add(subjaccPolicy);
            childDU.addAttachment("jboss.jacc", subjaccPolicy, ServiceMetaData.class);
            ServiceMetaData parentJacc = (ServiceMetaData)childDU.getParent().getAttachment("jboss.jacc");
            if (parentJacc == null) {
                throw new IllegalStateException("Parent JACC Policy is null");
            }
            ArrayList<ServiceDependencyMetaData> dependencies = new ArrayList<ServiceDependencyMetaData>();
            ServiceDependencyMetaData sdmd = new ServiceDependencyMetaData();
            sdmd.setIDependOnObjectName(subjaccPolicy.getObjectName());
            dependencies.add(sdmd);
            parentJacc.setDependencies(dependencies);
            ArrayList<ServiceAttributeMetaData> attributes = new ArrayList<ServiceAttributeMetaData>();
            ServiceAttributeMetaData attribute = new ServiceAttributeMetaData();
            attribute.setName("JaccPolicyMBean");
            String parentObjectName = parentJacc.getObjectName().getCanonicalName();
            ServiceInjectionValueMetaData sivmd = new ServiceInjectionValueMetaData(parentObjectName);
            sivmd.setDependentState(ControllerState.CONFIGURED);
            attribute.setValue(sivmd);
            attributes.add(attribute);
            attributes.addAll(subjaccPolicy.getAttributes());
            subjaccPolicy.setAttributes(attributes);
        }
    }

    @Override
    public void undeploy(VFSDeploymentUnit unit) {
        unit.removeAttachment("jboss.jaccpolicy", ServiceDeployment.class);
        List<String> jaccDeployments = JaccPolicyUtil.getJaccDeployments(unit, this.ignoreSuffixes);
        for (String deployment : jaccDeployments) {
            DeploymentUnit childDU = this.getChildDeployment(unit, deployment);
            if (childDU == null) continue;
            childDU.removeAttachment("jboss.jaccpolicy", ServiceDeployment.class);
        }
    }

    private DeploymentUnit getChildDeployment(DeploymentUnit parent, String id) {
        List<DeploymentUnit> children = parent.getChildren();
        for (DeploymentUnit child : children) {
            if (!id.equals(child.getSimpleName())) continue;
            return child;
        }
        return null;
    }

    private void createTopLevelServiceBeanWithMetaData(String contextId, DeploymentUnit unit) {
        ServiceConstructorMetaData constructor = new ServiceConstructorMetaData();
        constructor.setSignature(new String[]{String.class.getName(), Object.class.getName(), Boolean.class.getName()});
        constructor.setParameters(new Object[]{contextId, this.getMetaData(unit), Boolean.TRUE});
        this.createJaccPolicyBean(constructor, unit);
    }

    private void createTopLevelServiceBean(String contextId, DeploymentUnit unit) {
        ServiceConstructorMetaData constructor = new ServiceConstructorMetaData();
        constructor.setSignature(new String[]{String.class.getName()});
        constructor.setParameters(new Object[]{contextId});
        this.createJaccPolicyBean(constructor, unit);
    }

    private void createJaccPolicyBean(ServiceConstructorMetaData constructor, DeploymentUnit unit) {
        ServiceMetaData jaccPolicy = new ServiceMetaData();
        jaccPolicy.setCode(JaccPolicy.class.getName());
        try {
            jaccPolicy.setObjectName(new ObjectName(this.BASE_OBJECT_NAME + unit.getSimpleName()));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        jaccPolicy.setConstructor(constructor);
        ArrayList<ServiceMetaData> services = new ArrayList<ServiceMetaData>();
        services.add(jaccPolicy);
        unit.addAttachment("jboss.jacc", jaccPolicy, ServiceMetaData.class);
    }

    private Object getMetaData(DeploymentUnit du) {
        Object md = null;
        md = du.getAttachment(JBossWebMetaData.class.getName());
        if (md == null) {
            md = du.getAttachment(JBossMetaData.class.getName());
        }
        if (md == null) {
            md = du.getAttachment(JBossEnterpriseBeanMetaData.class.getName());
        }
        return md;
    }
}

