/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployers.vfs.plugins.structure.war;

import java.io.IOException;
import java.util.List;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.spi.structure.ContextInfo;
import org.jboss.deployers.spi.structure.StructureMetaData;
import org.jboss.deployers.vfs.spi.structure.VFSStructuralDeployers;
import org.jboss.deployers.vfs.spi.structure.helpers.AbstractStructureDeployer;
import org.jboss.virtual.VirtualFile;
import org.jboss.virtual.VirtualFileFilter;
import org.jboss.virtual.VisitorAttributes;
import org.jboss.virtual.plugins.vfs.helpers.SuffixMatchFilter;

public class WARStructure
extends AbstractStructureDeployer {
    public static final VirtualFileFilter DEFAULT_WEB_INF_LIB_FILTER = new SuffixMatchFilter(".jar", VisitorAttributes.DEFAULT);
    private VirtualFileFilter webInfLibFilter = DEFAULT_WEB_INF_LIB_FILTER;

    public WARStructure() {
        this.setRelativeOrder(1000);
    }

    public VirtualFileFilter getWebInfLibFilter() {
        return this.webInfLibFilter;
    }

    public void setWebInfLibFilter(VirtualFileFilter webInfLibFilter) {
        if (webInfLibFilter == null) {
            throw new IllegalArgumentException("Null filter");
        }
        this.webInfLibFilter = webInfLibFilter;
    }

    public boolean determineStructure(VirtualFile root, VirtualFile parent, VirtualFile file, StructureMetaData metaData, VFSStructuralDeployers deployers) throws DeploymentException {
        ContextInfo context = null;
        try {
            if (!this.isLeaf(file)) {
                if (!file.getName().endsWith(".war")) {
                    try {
                        file.findChild("WEB-INF");
                        this.log.trace("... ok - directory has a WEB-INF subdirectory");
                    }
                    catch (IOException e) {
                        this.log.trace("... no - doesn't look like a war and no WEB-INF subdirectory.");
                        return false;
                    }
                } else {
                    this.log.trace("... ok - name ends in .war.");
                }
                context = this.createContext(file, "WEB-INF", metaData);
                this.addClassPath(root, file, false, true, context);
                try {
                    VirtualFile classes = file.findChild("WEB-INF/classes");
                    this.addClassPath(root, classes, true, false, context);
                }
                catch (IOException e) {
                    this.log.trace("No WEB-INF/classes for: " + file.getPathName());
                }
                try {
                    VirtualFile webinfLib = file.findChild("WEB-INF/lib");
                    List<VirtualFile> archives = webinfLib.getChildren(this.webInfLibFilter);
                    for (VirtualFile jar : archives) {
                        this.addClassPath(root, jar, true, true, context);
                    }
                }
                catch (IOException ignored) {
                    this.log.trace("No WEB-INF/lib for: " + file.getPathName());
                }
                return true;
            }
            this.log.trace("... no - not a directory or an archive.");
            return false;
        }
        catch (Exception e) {
            if (context != null) {
                metaData.removeContext(context);
            }
            throw DeploymentException.rethrowAsDeploymentException("Error determining structure: " + file.getName(), e);
        }
    }
}

