/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployers.spi.deployer.helpers;

import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.spi.deployer.DeploymentStages;
import org.jboss.deployers.spi.deployer.helpers.AbstractDeployer;
import org.jboss.deployers.structure.spi.DeploymentUnit;

public abstract class AbstractRealDeployer
extends AbstractDeployer {
    private boolean useUnitName;

    public AbstractRealDeployer() {
        this.setStage(DeploymentStages.REAL);
    }

    public final void deploy(DeploymentUnit unit) throws DeploymentException {
        this.internalDeploy(unit);
        if (this.isControllerContextNameCandidate(unit)) {
            this.addControllerContextName(unit);
        }
    }

    protected boolean isControllerContextNameCandidate(DeploymentUnit unit) {
        return this.useUnitName && unit.isComponent();
    }

    protected abstract void internalDeploy(DeploymentUnit var1) throws DeploymentException;

    protected void addControllerContextName(DeploymentUnit unit) {
        unit.addControllerContextName(unit.getName());
    }

    protected void removeControllerContextName(DeploymentUnit unit) {
        unit.removeControllerContextName(unit.getName());
    }

    public final void undeploy(DeploymentUnit unit) {
        block3: {
            try {
                if (this.isControllerContextNameCandidate(unit)) {
                    this.removeControllerContextName(unit);
                }
            }
            catch (Throwable t) {
                if (!this.log.isTraceEnabled()) break block3;
                this.log.trace("Exception while removing unit name: " + t);
            }
        }
        this.internalUndeploy(unit);
    }

    protected void internalUndeploy(DeploymentUnit unit) {
    }

    public boolean isUseUnitName() {
        return this.useUnitName;
    }

    public void setUseUnitName(boolean useUnitName) {
        this.useUnitName = useUnitName;
    }
}

