/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployers.plugins.deployers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.jboss.dependency.plugins.AbstractController;
import org.jboss.dependency.spi.ControllerContext;
import org.jboss.dependency.spi.ControllerContextActions;
import org.jboss.dependency.spi.ControllerState;
import org.jboss.dependency.spi.DependencyInfo;
import org.jboss.dependency.spi.DependencyItem;
import org.jboss.deployers.client.spi.Deployment;
import org.jboss.deployers.client.spi.IncompleteDeploymentException;
import org.jboss.deployers.client.spi.IncompleteDeployments;
import org.jboss.deployers.client.spi.MissingDependency;
import org.jboss.deployers.plugins.deployers.DeployerWrapper;
import org.jboss.deployers.plugins.deployers.DeploymentControllerContext;
import org.jboss.deployers.plugins.sort.DeployerSorter;
import org.jboss.deployers.plugins.sort.DeployerSorterFactory;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.spi.DeploymentState;
import org.jboss.deployers.spi.deployer.Deployer;
import org.jboss.deployers.spi.deployer.Deployers;
import org.jboss.deployers.spi.deployer.DeploymentStage;
import org.jboss.deployers.spi.deployer.DeploymentStages;
import org.jboss.deployers.spi.deployer.managed.ManagedObjectCreator;
import org.jboss.deployers.structure.spi.DeploymentContext;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.deployers.structure.spi.scope.ScopeBuilder;
import org.jboss.kernel.spi.dependency.KernelController;
import org.jboss.logging.Logger;
import org.jboss.managed.api.ManagedObject;
import org.jboss.metadata.spi.repository.MutableMetaDataRepository;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeployersImpl
implements Deployers,
ControllerContextActions {
    private static final Logger log = Logger.getLogger(DeployersImpl.class);
    private AbstractController controller;
    private MutableMetaDataRepository repository;
    private Map<String, DeploymentStage> stages = new ConcurrentHashMap<String, DeploymentStage>();
    private Set<DeployerWrapper> deployers = new HashSet<DeployerWrapper>();
    private Map<String, List<Deployer>> deployersByStage = new HashMap<String, List<Deployer>>();
    private ScopeBuilder scopeBuilder;

    public DeployersImpl(AbstractController controller) {
        this(controller, null);
    }

    public DeployersImpl(AbstractController controller, Set<Deployer> deployers) {
        if (controller == null) {
            throw new IllegalArgumentException("Null controller");
        }
        this.controller = controller;
        this.addDeploymentStage(DeploymentStages.NOT_INSTALLED);
        this.addDeploymentStage(DeploymentStages.PARSE);
        this.addDeploymentStage(DeploymentStages.DESCRIBE);
        this.addDeploymentStage(DeploymentStages.CLASSLOADER);
        this.addDeploymentStage(DeploymentStages.POST_CLASSLOADER);
        this.addDeploymentStage(DeploymentStages.REAL);
        this.addDeploymentStage(DeploymentStages.INSTALLED);
        if (deployers != null) {
            this.setDeployers(deployers);
        }
    }

    public Set<DeployerWrapper> getDeployerWrappers() {
        return this.deployers;
    }

    public void setDeployers(Set<Deployer> deployers) {
        if (deployers == null) {
            throw new IllegalArgumentException("Null deployers");
        }
        HashSet<DeployerWrapper> oldDeployers = new HashSet<DeployerWrapper>(this.deployers);
        oldDeployers.removeAll(deployers);
        for (Deployer deployer : oldDeployers) {
            this.removeDeployer(deployer);
        }
        HashSet<Deployer> newDeployers = new HashSet<Deployer>(deployers);
        newDeployers.removeAll(this.deployers);
        for (Deployer deployer : newDeployers) {
            this.addDeployer(deployer);
        }
    }

    public synchronized void addDeployer(Deployer deployer) {
        if (deployer == null) {
            throw new IllegalArgumentException("Null deployer");
        }
        DeploymentStage stage = deployer.getStage();
        if (stage == null) {
            throw new IllegalArgumentException("Deployer has no stage: " + deployer);
        }
        this.addDeploymentStage(stage);
        DeployerWrapper wrapper = new DeployerWrapper(deployer);
        if (this.deployers.contains(wrapper)) {
            return;
        }
        String stageName = stage.getName();
        List<Deployer> deployers = this.deployersByStage.get(stageName);
        if (deployers == null) {
            deployers = Collections.emptyList();
        }
        deployers = this.insert(deployers, wrapper);
        this.deployersByStage.put(stageName, deployers);
        this.deployers.add(wrapper);
        StringBuilder builder = new StringBuilder();
        builder.append("Added deployer ").append(deployer).append(" for stage ").append(stageName).append('\n');
        for (Deployer temp : this.getDeployersList(stageName)) {
            builder.append(temp);
            builder.append("{inputs=").append(temp.getInputs());
            builder.append(" outputs=").append(temp.getOutputs());
            builder.append("}\n");
        }
        log.debug(builder);
    }

    public synchronized void removeDeployer(Deployer deployer) {
        if (deployer == null) {
            throw new IllegalArgumentException("Null deployer");
        }
        this.deployers.remove(new DeployerWrapper(deployer));
        DeploymentStage stage = deployer.getStage();
        if (stage == null) {
            log.warn("Deployer has no stage: " + deployer);
            return;
        }
        String stageName = stage.getName();
        List<Deployer> deployers = this.deployersByStage.get(stageName);
        if (deployers == null) {
            return;
        }
        deployers.remove(deployer);
        if (deployers.isEmpty()) {
            this.deployersByStage.remove(stageName);
        }
        log.debug("Removed deployer " + deployer + " from stage " + stageName);
    }

    protected synchronized void addDeploymentStage(DeploymentStage stage) {
        if (stage == null) {
            throw new IllegalArgumentException("Null stage");
        }
        String stageName = stage.getName();
        if (this.stages.containsKey(stageName)) {
            return;
        }
        ControllerState preceeds = null;
        String before = stage.getBefore();
        String after = stage.getAfter();
        if (before != null || after != null) {
            List<ControllerState> states = this.controller.getStates();
            for (int i = 0; i < states.size(); ++i) {
                ControllerState state = states.get(i);
                String stateName = state.getStateString();
                if (before != null && before.equals(stateName)) {
                    preceeds = state;
                    break;
                }
                if (after == null || !after.equals(stateName) || i >= states.size() - 1) continue;
                preceeds = states.get(i + 1);
                break;
            }
        }
        this.controller.addState(new ControllerState(stageName), preceeds);
        this.stages.put(stageName, stage);
        log.debug("Added stage " + stageName + " before " + preceeds);
    }

    public ScopeBuilder getScopeBuilder() {
        return this.scopeBuilder;
    }

    public void setScopeBuilder(ScopeBuilder scopeBuilder) {
        this.scopeBuilder = scopeBuilder;
    }

    public MutableMetaDataRepository getRepository() {
        return this.repository;
    }

    public void setRepository(MutableMetaDataRepository repository) {
        this.repository = repository;
    }

    public void start() {
        if (this.repository == null && this.controller instanceof KernelController) {
            KernelController kernelController = (KernelController)((Object)this.controller);
            this.repository = kernelController.getKernel().getMetaDataRepository().getMetaDataRepository();
        }
    }

    @Override
    public Map<String, ManagedObject> getManagedObjects(DeploymentContext context) throws DeploymentException {
        if (context == null) {
            throw new IllegalArgumentException("Null context");
        }
        HashMap<String, ManagedObject> managedObjects = new HashMap<String, ManagedObject>();
        for (DeployerWrapper deployer : this.deployers) {
            deployer.build(context.getDeploymentUnit(), managedObjects);
        }
        return managedObjects;
    }

    public ManagedObjectCreator getDeployerManagedObjectBuilder(Deployer deployer) {
        if (deployer == null) {
            throw new IllegalArgumentException("Null deployer");
        }
        ManagedObjectCreator result = null;
        for (DeployerWrapper wrapper : this.deployers) {
            if (!wrapper.equals(deployer)) continue;
            result = wrapper.getManagedObjectCreator();
        }
        return result;
    }

    public void setDeployerManagedObjectBuilder(Deployer deployer, ManagedObjectCreator managedObjectCreator) {
        if (deployer == null) {
            throw new IllegalArgumentException("Null deployer");
        }
        for (DeployerWrapper wrapper : this.deployers) {
            if (!wrapper.equals(deployer)) continue;
            wrapper.setManagedObjectCreator(managedObjectCreator);
        }
    }

    @Override
    public void process(List<DeploymentContext> deploy, List<DeploymentContext> undeploy) {
        if (undeploy != null && !undeploy.isEmpty()) {
            ArrayList<DeploymentControllerContext> toUndeploy = new ArrayList<DeploymentControllerContext>();
            for (int i = undeploy.size() - 1; i >= 0; --i) {
                DeploymentContext context = undeploy.get(i);
                if (!DeploymentState.ERROR.equals((Object)context.getState())) {
                    context.setState(DeploymentState.UNDEPLOYING);
                }
                log.debug("Undeploying " + context.getName());
                DeploymentControllerContext deploymentControllerContext = context.getTransientAttachments().getAttachment(ControllerContext.class.getName(), DeploymentControllerContext.class);
                if (deploymentControllerContext == null) {
                    log.debug("DeploymentContext has no DeploymentControllerContext during undeploy request, ignoring: " + context);
                    continue;
                }
                toUndeploy.add(deploymentControllerContext);
            }
            List<ControllerState> states = this.controller.getStates();
            for (int i = states.size() - 1; i >= 0; --i) {
                ControllerState state = states.get(i);
                for (DeploymentControllerContext deploymentControllerContext : toUndeploy) {
                    DeploymentContext context = deploymentControllerContext.getDeploymentContext();
                    if (ControllerState.ERROR.equals((Object)context.getState())) continue;
                    try {
                        this.controller.change(deploymentControllerContext, state);
                    }
                    catch (Throwable t) {
                        log.warn("Error during undeploy", t);
                        context.setState(DeploymentState.ERROR);
                        context.setProblem(t);
                    }
                }
            }
            for (DeploymentControllerContext deploymentControllerContext : toUndeploy) {
                DeploymentContext context = deploymentControllerContext.getDeploymentContext();
                context.getTransientAttachments().removeAttachment(ControllerContext.class);
                try {
                    this.controller.uninstall(deploymentControllerContext.getName());
                    DeployersImpl.setState(context, DeploymentState.UNDEPLOYED, null);
                    DeployersImpl.removeClassLoader(context);
                    DeployersImpl.cleanup(context);
                    log.debug("Fully Undeployed " + context.getName());
                }
                catch (Throwable t) {
                    log.warn("Error during uninstall", t);
                    context.setState(DeploymentState.ERROR);
                    context.setProblem(t);
                }
            }
        }
        if (deploy != null && !deploy.isEmpty()) {
            for (DeploymentContext context : deploy) {
                DeploymentControllerContext deploymentControllerContext = new DeploymentControllerContext(context, this);
                try {
                    this.controller.install(deploymentControllerContext);
                    context.setState(DeploymentState.DEPLOYING);
                    log.debug("Deploying " + context.getName());
                    context.getTransientAttachments().addAttachment(ControllerContext.class, deploymentControllerContext);
                    if (this.scopeBuilder != null) {
                        context.getTransientAttachments().addAttachment(ScopeBuilder.class, this.scopeBuilder);
                    }
                    if (this.repository == null) continue;
                    context.getTransientAttachments().addAttachment(MutableMetaDataRepository.class, this.repository);
                }
                catch (Throwable t) {
                    context.setState(DeploymentState.ERROR);
                    context.setProblem(t);
                    DeployersImpl.setState(context, DeploymentState.UNDEPLOYED, DeploymentState.DEPLOYING);
                }
            }
            List<ControllerState> states = this.controller.getStates();
            for (ControllerState state : states) {
                for (DeploymentContext context : deploy) {
                    DeploymentControllerContext deploymentControllerContext;
                    if (DeploymentState.ERROR.equals((Object)context.getState())) continue;
                    deploymentControllerContext = context.getTransientAttachments().getAttachment(ControllerContext.class.getName(), DeploymentControllerContext.class);
                    try {
                        this.controller.change(deploymentControllerContext, state);
                    }
                    catch (Throwable t) {
                        context.setState(DeploymentState.ERROR);
                        context.setProblem(t);
                    }
                }
            }
        }
    }

    private static Throwable getRootCause(Throwable original) {
        if (original == null) {
            return null;
        }
        Throwable result = original;
        for (Throwable cause = result.getCause(); cause != null; cause = cause.getCause()) {
            result = cause;
        }
        return result;
    }

    @Override
    public void checkComplete(Collection<DeploymentContext> errors, Collection<Deployment> missingDeployer) throws DeploymentException {
        IncompleteDeployments incomplete;
        HashMap<String, Throwable> deploymentsInError = null;
        HashSet<String> deploymentsMissingDeployer = null;
        HashMap<String, Throwable> contextsInError = null;
        HashMap<String, Set<MissingDependency>> contextsMissingDependencies = null;
        if (errors != null && !errors.isEmpty()) {
            deploymentsInError = new HashMap<String, Throwable>();
            for (DeploymentContext deploymentContext : errors) {
                deploymentsInError.put(deploymentContext.getName(), DeployersImpl.getRootCause(deploymentContext.getProblem()));
            }
        }
        if (missingDeployer != null && !missingDeployer.isEmpty()) {
            deploymentsMissingDeployer = new HashSet<String>();
            for (Deployment deployment : missingDeployer) {
                deploymentsMissingDeployer.add(deployment.getName());
            }
        }
        List<ControllerState> states = this.controller.getStates();
        Set<ControllerContext> set = this.controller.getNotInstalled();
        if (!set.isEmpty()) {
            Iterator<ControllerContext> i = set.iterator();
            while (i.hasNext()) {
                ControllerContext context = i.next();
                if (!context.getState().equals(context.getRequiredState())) continue;
                i.remove();
            }
            if (!set.isEmpty()) {
                contextsInError = new HashMap<String, Throwable>();
                contextsMissingDependencies = new HashMap<String, Set<MissingDependency>>();
                for (ControllerContext context : set) {
                    this.checkControllerContext(context, contextsInError, contextsMissingDependencies, states);
                }
            }
        }
        if ((incomplete = new IncompleteDeployments(deploymentsInError, deploymentsMissingDeployer, contextsInError, contextsMissingDependencies)).isIncomplete()) {
            throw new IncompleteDeploymentException(incomplete);
        }
    }

    protected final void checkControllerContext(ControllerContext context, Map<String, Throwable> contextsInError, Map<String, Set<MissingDependency>> contextsMissingDependencies, List<ControllerState> states) {
        if (context.getState().equals(ControllerState.ERROR)) {
            contextsInError.put(context.getName().toString(), DeployersImpl.getRootCause(context.getError()));
        } else {
            String name = context.getName().toString();
            HashSet<MissingDependency> dependencies = new HashSet<MissingDependency>();
            DependencyInfo dependsInfo = context.getDependencyInfo();
            for (DependencyItem item : dependsInfo.getIDependOn(null)) {
                int actual;
                String actualStateString;
                String dependency;
                if (item.isResolved()) continue;
                ControllerState actualState = null;
                Object iDependOn = item.getIDependOn();
                if (iDependOn == null) {
                    dependency = "<UNKNOWN>";
                    actualStateString = "** UNRESOLVED " + item.toHumanReadableString() + " **";
                } else {
                    dependency = iDependOn.toString();
                    ControllerContext other = this.controller.getContext(item.getIDependOn(), null);
                    if (other == null) {
                        actualStateString = "** NOT FOUND **";
                    } else {
                        actualState = other.getState();
                        actualStateString = actualState.getStateString();
                    }
                }
                ControllerState requiredState = item.getWhenRequired();
                String requiredStateString = requiredState.getStateString();
                int required = states.indexOf(requiredState);
                if (required <= (actual = actualState == null ? -1 : states.indexOf(actualState))) continue;
                MissingDependency missing = new MissingDependency(name, dependency, requiredStateString, actualStateString);
                dependencies.add(missing);
            }
            contextsMissingDependencies.put(name, dependencies);
        }
    }

    @Override
    public void checkComplete(DeploymentContext ... contexts) throws DeploymentException {
        this.checkComplete(true, contexts);
    }

    @Override
    public void checkStructureComplete(DeploymentContext ... contexts) throws DeploymentException {
        this.checkComplete(false, contexts);
    }

    protected void checkComplete(boolean checkContexts, DeploymentContext ... contexts) throws DeploymentException {
        IncompleteDeployments incomplete;
        if (contexts == null) {
            throw new IllegalArgumentException("Null contexts");
        }
        HashMap<String, Throwable> deploymentsInError = new HashMap<String, Throwable>();
        HashSet<String> deploymentsMissingDeployer = new HashSet<String>();
        HashMap<String, Throwable> contextsInError = new HashMap<String, Throwable>();
        HashMap<String, Set<MissingDependency>> contextsMissingDependencies = new HashMap<String, Set<MissingDependency>>();
        for (DeploymentContext context : contexts) {
            Throwable problem = context.getProblem();
            if (problem != null) {
                deploymentsInError.put(context.getName(), problem);
            }
            if (!this.isDeployed(context)) {
                deploymentsMissingDeployer.add(context.getName());
            }
            if (!checkContexts) continue;
            Set<ControllerContext> notInstalled = this.controller.getNotInstalled();
            List<ControllerState> states = this.controller.getStates();
            this.checkComplete(context, contextsInError, contextsMissingDependencies, notInstalled, states);
        }
        if (deploymentsInError.isEmpty()) {
            deploymentsInError = null;
        }
        if (deploymentsMissingDeployer.isEmpty()) {
            deploymentsMissingDeployer = null;
        }
        if (contextsInError.isEmpty()) {
            contextsInError = null;
        }
        if (contextsMissingDependencies.isEmpty()) {
            contextsMissingDependencies = null;
        }
        if ((incomplete = new IncompleteDeployments(deploymentsInError, deploymentsMissingDeployer, contextsInError, contextsMissingDependencies)).isIncomplete()) {
            throw new IncompleteDeploymentException(incomplete);
        }
    }

    protected boolean isDeployed(DeploymentContext context) {
        return context.isDeployed() || DeploymentState.DEPLOYED.equals((Object)context.getState());
    }

    protected final void checkComplete(DeploymentContext context, Map<String, Throwable> contextsInError, Map<String, Set<MissingDependency>> contextsMissingDependencies, Set<ControllerContext> notInstalled, List<ControllerState> states) {
        List<DeploymentContext> children;
        DeploymentControllerContext dcc = context.getTransientAttachments().getAttachment(ControllerContext.class.getName(), DeploymentControllerContext.class);
        this.checkControllerContext(dcc, contextsInError, contextsMissingDependencies, notInstalled, states);
        Set<Object> names = context.getControllerContextNames();
        if (names != null && !names.isEmpty()) {
            for (Object name : names) {
                ControllerContext cc = this.controller.getContext(name, null);
                this.checkControllerContext(cc, contextsInError, contextsMissingDependencies, notInstalled, states);
            }
        }
        if ((children = context.getChildren()) != null && !children.isEmpty()) {
            for (DeploymentContext child : children) {
                this.checkComplete(child, contextsInError, contextsMissingDependencies, notInstalled, states);
            }
        }
    }

    protected void checkControllerContext(ControllerContext context, Map<String, Throwable> contextsInError, Map<String, Set<MissingDependency>> contextsMissingDependencies, Set<ControllerContext> notInstalled, List<ControllerState> states) {
        if (context != null && !context.getState().equals(context.getRequiredState()) && notInstalled.contains(context)) {
            this.checkControllerContext(context, contextsInError, contextsMissingDependencies, states);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void install(ControllerContext context, ControllerState fromState, ControllerState toState) throws Throwable {
        block11: {
            DeploymentControllerContext deploymentControllerContext = (DeploymentControllerContext)context;
            String stageName = toState.getStateString();
            DeploymentContext deploymentContext = deploymentControllerContext.getDeploymentContext();
            try {
                List<Deployer> theDeployers = this.getDeployersList(stageName);
                if (log.isTraceEnabled()) {
                    log.trace("Deployers for " + stageName + " " + theDeployers);
                }
                if (theDeployers.isEmpty()) break block11;
                try {
                    for (int i = 0; i < theDeployers.size(); ++i) {
                        Deployer deployer = theDeployers.get(i);
                        if (deployer.isParentFirst()) {
                            this.doInstallParentFirst(deployer, deploymentContext);
                            continue;
                        }
                        this.doInstallParentLast(deployer, deploymentContext);
                    }
                }
                catch (Throwable t) {
                    deploymentContext.setState(DeploymentState.ERROR);
                    deploymentContext.setProblem(t);
                    for (int j = i - 1; j >= 0; --j) {
                        Deployer deployer = theDeployers.get(j);
                        if (deployer.isParentFirst()) {
                            this.doUninstallParentLast(deployer, deploymentContext, true, true);
                            continue;
                        }
                        this.doUninstallParentFirst(deployer, deploymentContext, true, true);
                    }
                    DeployersImpl.setState(deploymentContext, DeploymentState.UNDEPLOYED, DeploymentState.DEPLOYING);
                    throw t;
                }
            }
            finally {
                if (ControllerState.INSTALLED.equals(toState) && DeploymentState.DEPLOYING.equals((Object)deploymentContext.getState())) {
                    log.debug("Fully Deployed " + context.getName());
                    DeployersImpl.setState(deploymentContext, DeploymentState.DEPLOYED, null);
                }
            }
        }
    }

    protected void doInstallParentFirst(Deployer deployer, DeploymentContext context) throws Throwable {
        List<DeploymentContext> children;
        DeploymentUnit unit;
        List<DeploymentContext> currentComponents = context.getComponents();
        ArrayList<DeploymentContext> components = null;
        if (currentComponents != null && !currentComponents.isEmpty()) {
            components = new ArrayList<DeploymentContext>(currentComponents);
        }
        if (this.isRelevant(deployer, unit = context.getDeploymentUnit(), context.isTopLevel(), context.isComponent())) {
            try {
                deployer.deploy(unit);
            }
            catch (DeploymentException e) {
                context.setState(DeploymentState.ERROR);
                context.setProblem(e);
                throw e;
            }
        } else if (log.isTraceEnabled()) {
            log.trace("Deployer " + deployer + " not relevant for " + context.getName());
        }
        if (components != null) {
            try {
                for (int i = 0; i < components.size(); ++i) {
                    DeploymentContext component = (DeploymentContext)components.get(i);
                    try {
                        this.doInstallParentFirst(deployer, component);
                        continue;
                    }
                    catch (DeploymentException e) {
                        for (int j = i - 1; j >= 0; --j) {
                            component = (DeploymentContext)components.get(j);
                            this.doUninstallParentLast(deployer, component, false, true);
                        }
                        throw e;
                    }
                }
            }
            catch (DeploymentException e) {
                this.doUninstallParentLast(deployer, context, false, false);
                throw e;
            }
        }
        if ((children = context.getChildren()) != null) {
            try {
                for (int i = 0; i < children.size(); ++i) {
                    DeploymentContext child = children.get(i);
                    try {
                        this.doInstallParentFirst(deployer, child);
                        continue;
                    }
                    catch (DeploymentException e) {
                        for (int j = i - 1; j >= 0; --j) {
                            child = children.get(j);
                            this.doUninstallParentLast(deployer, child, true, true);
                        }
                        throw e;
                    }
                }
            }
            catch (DeploymentException e) {
                this.doUninstallParentLast(deployer, context, false, true);
                throw e;
            }
        }
    }

    protected void doInstallParentLast(Deployer deployer, DeploymentContext context) throws Throwable {
        DeploymentUnit unit;
        List<DeploymentContext> children = context.getChildren();
        for (int i = 0; i < children.size(); ++i) {
            DeploymentContext child = children.get(i);
            try {
                this.doInstallParentLast(deployer, child);
                continue;
            }
            catch (DeploymentException e) {
                for (int j = i - 1; j >= 0; --j) {
                    child = children.get(j);
                    this.doUninstallParentFirst(deployer, child, true, true);
                }
                throw e;
            }
        }
        List<DeploymentContext> components = context.getComponents();
        if (components != null) {
            try {
                for (int i = 0; i < components.size(); ++i) {
                    DeploymentContext component = components.get(i);
                    try {
                        this.doInstallParentLast(deployer, component);
                        continue;
                    }
                    catch (DeploymentException e) {
                        for (int j = i - 1; j >= 0; --j) {
                            component = components.get(j);
                            this.doUninstallParentFirst(deployer, component, true, true);
                        }
                        throw e;
                    }
                }
            }
            catch (DeploymentException e) {
                this.doUninstallParentFirst(deployer, context, false, false);
                throw e;
            }
        }
        if (this.isRelevant(deployer, unit = context.getDeploymentUnit(), context.isTopLevel(), context.isComponent())) {
            try {
                deployer.deploy(unit);
            }
            catch (DeploymentException e) {
                this.doUninstallParentFirst(deployer, context, false, true);
                context.setState(DeploymentState.ERROR);
                context.setProblem(e);
                throw e;
            }
        } else if (log.isTraceEnabled()) {
            log.trace("Deployer " + deployer + " not relevant for " + context.getName());
        }
    }

    @Override
    public void uninstall(ControllerContext context, ControllerState fromState, ControllerState toState) {
        DeploymentControllerContext deploymentControllerContext = (DeploymentControllerContext)context;
        String stageName = fromState.getStateString();
        DeploymentContext deploymentContext = deploymentControllerContext.getDeploymentContext();
        List<Deployer> theDeployers = this.getDeployersList(stageName);
        if (log.isTraceEnabled()) {
            log.trace("Deployers for " + stageName + " " + theDeployers);
        }
        if (!theDeployers.isEmpty()) {
            for (int i = theDeployers.size() - 1; i >= 0; --i) {
                Deployer deployer = theDeployers.get(i);
                if (deployer.isParentFirst()) {
                    this.doUninstallParentLast(deployer, deploymentContext, true, true);
                    continue;
                }
                this.doUninstallParentFirst(deployer, deploymentContext, true, true);
            }
        }
    }

    protected void doUninstallParentLast(Deployer deployer, DeploymentContext context, boolean doChildren, boolean doComponents) {
        DeploymentUnit unit;
        List<DeploymentContext> components;
        int i;
        List<DeploymentContext> children;
        if (doChildren && (children = context.getChildren()) != null && !children.isEmpty()) {
            for (i = children.size() - 1; i >= 0; --i) {
                DeploymentContext child = children.get(i);
                this.doUninstallParentLast(deployer, child, true, true);
            }
        }
        if (doComponents && (components = context.getComponents()) != null && !components.isEmpty()) {
            for (i = components.size() - 1; i >= 0; --i) {
                DeploymentContext component = components.get(i);
                this.doUninstallParentLast(deployer, component, false, true);
            }
        }
        if (this.isRelevant(deployer, unit = context.getDeploymentUnit(), context.isTopLevel(), context.isComponent())) {
            deployer.undeploy(unit);
        } else if (log.isTraceEnabled()) {
            log.trace("Deployer " + deployer + " not relevant for " + context.getName());
        }
    }

    protected void doUninstallParentFirst(Deployer deployer, DeploymentContext context, boolean doContext, boolean doComponents) {
        List<DeploymentContext> children;
        int i;
        List<DeploymentContext> components;
        if (doContext) {
            DeploymentUnit unit = context.getDeploymentUnit();
            if (this.isRelevant(deployer, unit, context.isTopLevel(), context.isComponent())) {
                deployer.undeploy(unit);
            } else if (log.isTraceEnabled()) {
                log.trace("Deployer " + deployer + " not relevant for " + context.getName());
            }
        }
        if (doComponents && (components = context.getComponents()) != null && !components.isEmpty()) {
            for (i = components.size() - 1; i >= 0; --i) {
                DeploymentContext component = components.get(i);
                this.doUninstallParentFirst(deployer, component, true, true);
            }
        }
        if ((children = context.getChildren()) != null && !children.isEmpty()) {
            for (i = children.size() - 1; i >= 0; --i) {
                DeploymentContext child = children.get(i);
                this.doUninstallParentFirst(deployer, child, true, true);
            }
        }
    }

    protected synchronized List<Deployer> getDeployersList(String stageName) {
        List<Deployer> deployers = this.deployersByStage.get(stageName);
        if (deployers == null || deployers.isEmpty()) {
            return Collections.emptyList();
        }
        return deployers;
    }

    protected boolean isRelevant(Deployer deployer, DeploymentUnit unit, boolean isTopLevel, boolean isComponent) {
        Class<?> input;
        if (deployer.isTopLevelOnly() && !isTopLevel) {
            return false;
        }
        if (deployer.isComponentsOnly() && !isComponent) {
            return false;
        }
        if (!deployer.isWantComponents() && isComponent) {
            return false;
        }
        return deployer.isAllInputs() || (input = deployer.getInput()) == null || unit.getAttachment(input) != null;
    }

    protected List<Deployer> insert(List<Deployer> original, Deployer newDeployer) {
        DeployerSorter sorter = DeployerSorterFactory.newSorter();
        return sorter.sortDeployers(original, newDeployer);
    }

    private static void setState(DeploymentContext context, DeploymentState state, DeploymentState ifState) {
        List<DeploymentContext> children;
        if (ifState == null || ifState.equals((Object)context.getState())) {
            context.setState(state);
        }
        if ((children = context.getChildren()) != null && !children.isEmpty()) {
            for (DeploymentContext child : children) {
                DeployersImpl.setState(child, state, ifState);
            }
        }
    }

    private static void removeClassLoader(DeploymentContext context) {
        context.removeClassLoader();
        List<DeploymentContext> children = context.getChildren();
        if (children != null && !children.isEmpty()) {
            for (DeploymentContext child : children) {
                DeployersImpl.removeClassLoader(child);
            }
        }
    }

    private static void cleanup(DeploymentContext context) {
        List<DeploymentContext> components;
        context.cleanup();
        List<DeploymentContext> children = context.getChildren();
        if (children != null && !children.isEmpty()) {
            for (DeploymentContext child : children) {
                DeployersImpl.cleanup(child);
            }
        }
        if ((components = context.getComponents()) != null && !components.isEmpty()) {
            for (DeploymentContext component : components) {
                DeployersImpl.cleanup(component);
            }
        }
    }
}

