/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.classloader.plugins.filter;

import org.jboss.classloader.spi.filter.ClassFilter;

public class CombiningClassFilter
implements ClassFilter {
    private ClassFilter[] filters;

    public static CombiningClassFilter create(ClassFilter ... filters) {
        return new CombiningClassFilter(filters);
    }

    public CombiningClassFilter(ClassFilter[] filters) {
        if (filters == null) {
            throw new IllegalArgumentException("Null filters");
        }
        this.filters = filters;
    }

    public boolean matchesClassName(String className) {
        for (ClassFilter filter : this.filters) {
            if (!filter.matchesClassName(className)) continue;
            return true;
        }
        return false;
    }

    public boolean matchesResourcePath(String resourcePath) {
        for (ClassFilter filter : this.filters) {
            if (!filter.matchesResourcePath(resourcePath)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < this.filters.length; ++i) {
            builder.append(this.filters[i]);
            if (i >= this.filters.length - 1) continue;
            builder.append(", ");
        }
        return builder.toString();
    }
}

