/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aspects.versioned;

import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.jboss.aop.advice.Interceptor;
import org.jboss.aop.joinpoint.FieldReadInvocation;
import org.jboss.aop.joinpoint.FieldWriteInvocation;
import org.jboss.aop.joinpoint.Invocation;
import org.jboss.aop.joinpoint.MethodInvocation;
import org.jboss.aspects.versioned.VersionedObject;
import org.jboss.logging.Logger;

public class VersionedObjectInterceptor
implements Interceptor {
    protected Logger log = Logger.getLogger(this.getClass());
    private TransactionManager tm;

    public VersionedObjectInterceptor(TransactionManager tm) {
        this.tm = tm;
    }

    public String getName() {
        return "VersionedObjectInterceptor";
    }

    public Object invoke(Invocation invocation) throws Throwable {
        Transaction tx = this.tm.getTransaction();
        VersionedObject manager = (VersionedObject)invocation.getMetaData("VERSIONED", "VERSIONED_OBJECT");
        Object version = manager.getVersion(tx);
        if (version != null) {
            invocation.setTargetObject(version);
            return invocation.invokeNext();
        }
        boolean isReadonly = false;
        if (invocation instanceof MethodInvocation) {
            String readonly = (String)invocation.getMetaData("VERSIONED", "read-only");
            if (readonly != null) {
                isReadonly = Boolean.getBoolean(readonly.toLowerCase());
            }
        } else if (invocation instanceof FieldReadInvocation) {
            isReadonly = true;
        } else if (invocation instanceof FieldWriteInvocation) {
            isReadonly = false;
        }
        if (isReadonly) {
            return invocation.invokeNext();
        }
        version = manager.createVersion(tx);
        invocation.setTargetObject(version);
        return invocation.invokeNext();
    }
}

