/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aspects.security;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.security.Principal;
import org.jboss.aop.advice.Interceptor;
import org.jboss.aop.joinpoint.Invocation;
import org.jboss.aspects.security.SecurityActions;
import org.jboss.security.SecurityContext;

public final class SecurityClientInterceptor
implements Interceptor,
Serializable {
    private static final long serialVersionUID = -6366165968174741107L;
    public static final SecurityClientInterceptor singleton = new SecurityClientInterceptor();

    public String getName() {
        return "SecurityClientInterceptor";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(Invocation invocation) throws Throwable {
        SecurityContext sc;
        Object credential;
        Principal principal = SecurityActions.getPrincipal();
        if (principal != null) {
            invocation.getMetaData().addMetaData("security", "principal", principal);
        }
        if ((credential = SecurityActions.getCredential()) != null) {
            invocation.getMetaData().addMetaData("security", "credential", credential);
        }
        if ((sc = SecurityActions.getSecurityContext()) == null) {
            sc = SecurityActions.createSecurityContext();
            SecurityActions.setSecurityContext(sc);
        }
        invocation.getMetaData().addMetaData("security", "context", sc);
        try {
            Object object = invocation.invokeNext();
            return object;
        }
        finally {
            SecurityActions.setSecurityContext(sc);
        }
    }

    Object readResolve() throws ObjectStreamException {
        return singleton;
    }
}

