/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.proxy.container;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.jboss.aop.Advisor;
import org.jboss.aop.AspectManager;
import org.jboss.aop.InstanceAdvisor;
import org.jboss.aop.metadata.SimpleMetaData;
import org.jboss.aop.proxy.container.AspectManaged;
import org.jboss.aop.proxy.container.ClassProxyContainer;
import org.jboss.aop.proxy.container.Delegate;
import org.jboss.aop.proxy.container.InstanceProxyContainer;

public class ProxyTemplate
implements Delegate,
AspectManaged {
    private transient Advisor classAdvisor;
    private transient InstanceAdvisor instanceAdvisor;
    protected volatile transient Advisor currentAdvisor;
    private Object delegate;
    private Object[] mixins;
    private SimpleMetaData metadata;

    public Object getDelegate() {
        return this.delegate;
    }

    public void setDelegate(Object delegate) {
        this.delegate = delegate;
    }

    public Advisor getAdvisor() {
        return this.currentAdvisor;
    }

    public void setAdvisor(Advisor advisor) {
        this.currentAdvisor = this.classAdvisor = advisor;
    }

    public void setMetadata(SimpleMetaData metadata) {
        this.metadata = metadata;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setInstanceAdvisor(InstanceAdvisor ia) {
        ProxyTemplate proxyTemplate = this;
        synchronized (proxyTemplate) {
            if (this.instanceAdvisor != null) {
                throw new RuntimeException("InstanceAdvisor already set");
            }
            if (!(ia instanceof InstanceProxyContainer)) {
                throw new RuntimeException("Wrong type for instance advisor: " + this.instanceAdvisor);
            }
            this.instanceAdvisor = ia;
            this.currentAdvisor = (InstanceProxyContainer)ia;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InstanceAdvisor getInstanceAdvisor() {
        ProxyTemplate proxyTemplate = this;
        synchronized (proxyTemplate) {
            if (this.instanceAdvisor == null) {
                InstanceProxyContainer ipc = ((ClassProxyContainer)this.currentAdvisor).createInstanceProxyContainer();
                this.setInstanceAdvisor(ipc);
            }
        }
        return this.instanceAdvisor;
    }

    public boolean equals(Object obj) {
        if (this.delegate != null) {
            if (obj != null && obj instanceof Delegate) {
                obj = ((Delegate)obj).getDelegate();
            }
            return this.delegate.equals(obj);
        }
        return super.equals(obj);
    }

    public int hashCode() {
        if (this.delegate != null) {
            return this.delegate.hashCode();
        }
        return super.hashCode();
    }

    public String toString() {
        if (this.delegate != null) {
            return this.delegate.toString() + " (proxied by " + this.getClass().getName() + "@" + Integer.toHexString(System.identityHashCode(this)) + ")";
        }
        return super.toString() + "(empty proxy of " + this.getClass().getSuperclass().getName() + ")";
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeObject(this.delegate);
        out.writeObject(this.mixins);
        out.writeObject(this.metadata);
        out.writeObject(this.classAdvisor.getClazz());
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.delegate = in.readObject();
        this.mixins = (Object[])in.readObject();
        this.metadata = (SimpleMetaData)in.readObject();
        Class clazz = (Class)in.readObject();
        AspectManager manager = AspectManager.getTopLevelAspectManager();
        this.currentAdvisor = this.classAdvisor = manager.findAdvisor(clazz);
    }
}

