/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.microcontainer.beans;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jboss.aop.AspectManager;
import org.jboss.aop.advice.AspectDefinition;
import org.jboss.aop.advice.AspectFactory;
import org.jboss.aop.advice.AspectFactoryDelegator;
import org.jboss.aop.advice.AspectFactoryWithClassLoaderSupport;
import org.jboss.aop.advice.GenericAspectFactory;
import org.jboss.aop.advice.Scope;
import org.jboss.aop.advice.ScopeUtil;
import org.jboss.aop.instrument.Untransformable;
import org.jboss.aop.microcontainer.beans.Binding;
import org.jboss.aop.microcontainer.beans.DelegatingBeanAspectFactory;
import org.jboss.aop.microcontainer.beans.GenericBeanAspectFactory;
import org.jboss.aop.microcontainer.beans.ManagedAspectDefinition;
import org.jboss.beans.metadata.plugins.factory.GenericBeanFactory;
import org.jboss.dependency.spi.ControllerContext;
import org.jboss.kernel.spi.dependency.ConfigureKernelControllerContextAware;
import org.jboss.kernel.spi.dependency.KernelControllerContext;
import org.jboss.logging.Logger;
import org.jboss.util.id.GUID;

public class Aspect
implements ConfigureKernelControllerContextAware,
Untransformable {
    private static final Logger log = Logger.getLogger(Aspect.class);
    protected AspectManager manager;
    protected String adviceName = GUID.asString();
    protected boolean factory;
    protected Scope scope;
    protected ManagedAspectDefinition definition;
    protected GenericBeanFactory advice;
    protected String adviceBean;
    protected ControllerContext context;
    protected String myname;
    protected String aspectDefName;
    protected Map<String, Binding> bindings = new LinkedHashMap<String, Binding>();

    public String getAdviceName() {
        return this.adviceName;
    }

    public void setFactory(boolean factory) {
        this.factory = factory;
    }

    public void setAdviceName(String adviceName) {
        this.adviceName = adviceName;
    }

    public String getAdviceBean() {
        return this.adviceBean;
    }

    public void setAdviceBean(String adviceBean) {
        this.adviceBean = adviceBean;
    }

    public AspectDefinition getDefinition() {
        return this.definition;
    }

    public AspectManager getManager() {
        return this.manager;
    }

    public void setManager(AspectManager manager) {
        this.manager = manager;
    }

    public GenericBeanFactory getAdvice() {
        return this.advice;
    }

    public void setAdvice(GenericBeanFactory advice) {
        this.advice = advice;
    }

    public String getScope() {
        return this.scope.toString();
    }

    public void setScope(String scope) {
        this.scope = ScopeUtil.parse(scope);
    }

    public void setKernelControllerContext(KernelControllerContext context) throws Exception {
        this.myname = (String)context.getName();
        this.context = context;
    }

    public void unsetKernelControllerContext(KernelControllerContext context) throws Exception {
        this.context = null;
    }

    public void install(GenericBeanFactory factory) throws Exception {
        this.advice = factory;
        this.start();
    }

    public void start() throws Exception {
        if (this.definition == null) {
            String string = this.aspectDefName = this.adviceBean != null ? this.adviceBean : this.myname;
            if (this.manager == null) {
                throw new IllegalArgumentException("Null manager");
            }
            this.definition = this.advice != null ? this.getAspectDefinitionNoDependencies() : (this.adviceBean != null && this.context.getController() != null ? this.getAspectDefintionDependencies() : this.getAspectDefinitionPlainAspectFactory());
            this.addDefinitionToManager();
        }
        if (this.adviceBean != null && this.advice != null) {
            this.definition.setDeployed(true);
            GenericBeanAspectFactory factory = (GenericBeanAspectFactory)this.definition.getFactory();
            factory.setBeanFactory(this.advice);
        }
        ArrayList<Binding> clonedBindings = new ArrayList<Binding>();
        for (Binding aspectBinding : this.bindings.values()) {
            clonedBindings.add(aspectBinding);
        }
        for (Binding binding : clonedBindings) {
            binding.rebind();
        }
        log.debug("Bound aspect " + this.aspectDefName + "; deployed:" + this.definition.isDeployed());
    }

    protected ManagedAspectDefinition getAspectDefinitionNoDependencies() {
        AspectFactory factory = this.factory ? new DelegatingBeanAspectFactory(this.adviceName, this.advice) : new GenericBeanAspectFactory(this.adviceName, this.advice);
        return new ManagedAspectDefinition(this.aspectDefName, this.scope, factory);
    }

    protected ManagedAspectDefinition getAspectDefintionDependencies() {
        AspectFactory factory = this.factory ? new DelegatingBeanAspectFactory(this.aspectDefName, this.advice) : new GenericBeanAspectFactory(this.aspectDefName, this.advice);
        return new ManagedAspectDefinition(this.aspectDefName, this.scope, factory, false);
    }

    protected ManagedAspectDefinition getAspectDefinitionPlainAspectFactory() {
        AspectFactoryWithClassLoaderSupport factory = this.factory ? new AspectFactoryDelegator(this.adviceName, null) : new GenericAspectFactory(this.adviceName, null);
        return new ManagedAspectDefinition(this.aspectDefName, this.scope, factory);
    }

    protected void addDefinitionToManager() {
        this.manager.addAspectDefinition(this.definition);
    }

    public void uninstall() throws Exception {
        this.stop();
    }

    public void stop() {
        this.aspectDefName = this.adviceBean != null ? this.adviceBean : this.myname;
        log.debug("Unbinding aspect " + this.aspectDefName);
        this.manager.removeAspectDefinition(this.aspectDefName);
        if (this.definition != null) {
            this.definition.undeploy();
            this.definition = null;
        }
    }

    void addBinding(Binding binding) {
        this.bindings.put(binding.getName(), binding);
    }

    void removeBinding(Binding binding) {
        this.bindings.remove(binding.getName());
    }
}

